/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import TimGraph.Community.Partition;
import TimGraph.Community.VertexPartition;
import TimGraph.Coordinate;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import TimUtilities.JavaColours;
import java.awt.Color;
import java.io.PrintStream;

public class GraphMLGenerator {
    static final String[] firstLines = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\" xmlns:visone=\"http://visone.info/xmlns\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml http://www.yworks.com/xml/schema/graphml/1.0/ygraphml.xsd\">"};
    static final String[] keyDefinitions = new String[]{"<key id=\"d0\" for=\"node\" yfiles.type=\"nodegraphics\"/>", "<key id=\"d1\" for=\"node\" attr.name=\"id\" attr.type=\"string\"></key>", "<key id=\"d2\" for=\"edge\" yfiles.type=\"edgegraphics\"/>", "<key id=\"d5\" for=\"edge\" attr.name=\"id\" attr.type=\"string\"></key>"};
    int indent = 1;
    static final double DUNSET = -9.753472E48;
    static final double ARCFACTOR = -0.01;
    static final String indentString = "                                                        ";
    static final String DEFAULTEDGECOLOUR = JavaColours.RGB((Color)Color.BLACK);
    static final String DEFAULTEDGEGREY = JavaColours.RGB((Color)Color.LIGHT_GRAY);
    static final String DEFAULTVERTEXCOLOUR = JavaColours.RGB((Color)Color.RED);
    public static final double DEFAULT_VERTEX_SIZE = 30.0;
    public static final double DEFAULT_LAYOUT_SCALE = 300.0;
    public static final String[] shapeTypes = new String[]{"ellipse", "roundrectangle", "triangle", "diamond", "hexagon", "octagon", "trapezoid", "parallelogram", "trapezoid2"};
    public static final int DEFAULT_SHAPE_INDEX = 0;
    public static final String DEFAULT_SHAPE = GraphMLGenerator.getNodeShape(0);
    public static final int DEFAULT_GREY_SHAPE_INDEX = shapeTypes.length - 1;
    public static final String DEFAULT_GREY_SHAPE = GraphMLGenerator.getNodeShape(DEFAULT_GREY_SHAPE_INDEX);

    public void outputGraph(PrintStream PS, timgraph tg, double edgeWidthMultiplier, boolean targetArrowsOn) {
        double edgeWeightMinimum = 1.0E-44;
        double vertexPositionScale = 1.0;
        if (tg.getMaximumVertexLabel() == null) {
            tg.calcMaximumVertexLabel();
        }
        int numberVertexColours = tg.getMaximumVertexNumber();
        if (tg.getMaximumEdgeValue() == null) {
            tg.calcMaximumEdgeValue();
        }
        int numberEdgeColours = tg.getMaximumEdgeLabel();
        this.outputGraph(PS, tg, numberVertexColours, numberEdgeColours, vertexPositionScale, edgeWeightMinimum, edgeWidthMultiplier, targetArrowsOn);
    }

    public void outputGraph(PrintStream PS, timgraph tg, int numberVertexColours, int numberEdgeColours, double edgeWidthMultiplier, boolean targetArrowsOn) {
        double edgeWeightMinimum = 1.0E-44;
        double vertexPositionScale = 1.0;
        this.outputGraph(PS, tg, numberVertexColours, numberEdgeColours, vertexPositionScale, edgeWeightMinimum, edgeWidthMultiplier, targetArrowsOn);
    }

    public void outputGraph(PrintStream PS, timgraph tg, int numberVertexLabels, int numberEdgeLabels, double vertexPositionScale, double edgeWeightMinimum, double edgeWidthMultiplier, boolean targetArrowsOn) {
        JavaColours nc = null;
        if (numberEdgeLabels > 1) {
            nc = new JavaColours(numberEdgeLabels + 1, true);
        }
        JavaColours nvc = null;
        if (numberVertexLabels > 1) {
            nvc = new JavaColours(numberVertexLabels + 1, true);
        }
        if (tg.isInfoLeveLGreaterThan(1)) {
            if (numberEdgeLabels > 1) {
                nc.printAllColours(System.out);
            }
            if (numberVertexLabels > 1) {
                nvc.printAllColours(System.out);
            }
        }
        this.printInitialLines(PS, tg.outputName.getNameRoot(), tg.isDirected());
        double xpos = 0.0;
        double ypos = 0.0;
        double vsize = 30.0;
        double angle = 0.0;
        double dtheta = Math.PI * 2 / (double)tg.getNumberVertices();
        double radius = 30.0 / dtheta;
        VertexLabel vl = new VertexLabel();
        int vlabel = 0;
        String name = "";
        String vcstring = DEFAULTVERTEXCOLOUR;
        String ecstring = DEFAULTEDGECOLOUR;
        String nodeShape = DEFAULT_SHAPE;
        for (int v = 0; v < tg.getNumberVertices(); ++v) {
            angle = dtheta * (double)v;
            xpos = radius * Math.cos(angle);
            ypos = radius * Math.sin(angle);
            vcstring = DEFAULTVERTEXCOLOUR;
            nodeShape = DEFAULT_SHAPE;
            name = tg.getVertexName(v);
            if (tg.isVertexLabelled()) {
                vl = tg.getVertexLabel(v);
                if (vl.hasPosition()) {
                    xpos = vertexPositionScale * vl.getPosition().getX();
                    ypos = vertexPositionScale * vl.getPosition().getY();
                }
                if (vl.hasNumber()) {
                    vlabel = vl.getNumber();
                    if (vlabel < 0) {
                        vcstring = DEFAULTEDGEGREY;
                        nodeShape = DEFAULT_GREY_SHAPE;
                    } else {
                        vcstring = nvc == null ? DEFAULTVERTEXCOLOUR : nvc.RGB(vlabel + 1);
                        nodeShape = shapeTypes[vlabel % shapeTypes.length];
                    }
                }
            }
            this.printNodeColoured(PS, v, tg.getNumberVertices(), xpos, ypos, vsize, vsize, name, vcstring, nodeShape);
        }
        int s = -1;
        int t = -1;
        int el = -1;
        double arcFactor = tg.isDirected() ? -0.01 : -9.753472E48;
        for (int e = 0; e < tg.getNumberStubs(); ++e) {
            s = tg.getVertexFromEdge(e++);
            t = tg.getVertexFromEdge(e);
            Coordinate sCoordinate = tg.getVertexPosition(s);
            Coordinate tCoordinate = tg.getVertexPosition(t);
            ecstring = DEFAULTEDGECOLOUR;
            double ew = tg.getEdgeWeightSlow(e);
            if (ew < edgeWeightMinimum) continue;
            ew *= edgeWidthMultiplier;
            if (tg.isEdgeLabelled()) {
                el = tg.getEdgeLabel(e);
                ecstring = el < 0 ? DEFAULTEDGEGREY : (nc == null ? DEFAULTEDGECOLOUR : nc.RGB(el + 1));
            }
            this.printEdgeColoured(PS, e - 1, s, t, sCoordinate, tCoordinate, arcFactor, tg.getEdgeLabelString(e), ew, tg.isDirected(), ecstring);
        }
        this.printFinalLines(PS);
    }

    public void outputVertexPartition(PrintStream PS, timgraph tg, Partition c) {
        JavaColours nc = new JavaColours(c.getNumberOfCommunities() + 2, true);
        if (tg.isInfoLeveLGreaterThan(1)) {
            nc.printAllColours(System.out);
        }
        this.printInitialLines(PS, tg.outputName.getNameRoot(), tg.isDirected());
        for (int v = 0; v < tg.getNumberVertices(); ++v) {
            this.printNodeColoured(PS, v, tg.getNumberVertices(), tg.getVertexLabel(v), c.getCommunity(v) + 1, -1, nc);
        }
        int s = -1;
        int t = -1;
        String name = "";
        double arcFactor = tg.isDirected() ? -0.01 : -9.753472E48;
        for (int e = 0; e < tg.getNumberStubs(); ++e) {
            s = tg.getVertexFromEdge(e++);
            t = tg.getVertexFromEdge(e);
            Coordinate sCoordinate = tg.getVertexPosition(s);
            Coordinate tCoordinate = tg.getVertexPosition(t);
            double ew = tg.getEdgeWeightSlow(e);
            this.printEdgeColoured(PS, e - 1, s, t, sCoordinate, tCoordinate, arcFactor, tg.getEdgeLabelString(e), ew, tg.isDirected(), DEFAULTEDGECOLOUR);
        }
        this.printFinalLines(PS);
    }

    public void outputEdgePartition(PrintStream PS, timgraph tg, Partition c) {
        JavaColours nc = new JavaColours(c.getNumberOfCommunities() + 2, true);
        if (tg.isInfoLeveLGreaterThan(1)) {
            nc.printAllColours(System.out);
        }
        this.printInitialLines(PS, tg.outputName.getNameRoot(), tg.isDirected());
        for (int v = 0; v < tg.getNumberVertices(); ++v) {
            this.printNodeColoured(PS, v, tg.getNumberVertices(), tg.getVertexLabel(v), null);
        }
        int s = -1;
        int t = -1;
        double arcFactor = tg.isDirected() ? -0.01 : -9.753472E48;
        for (int e = 0; e < tg.getNumberStubs(); ++e) {
            s = tg.getVertexFromEdge(e++);
            t = tg.getVertexFromEdge(e);
            Coordinate sCoordinate = tg.getVertexPosition(s);
            Coordinate tCoordinate = tg.getVertexPosition(t);
            double ew = tg.getEdgeWeightSlow(e);
            this.printEdgeColoured(PS, e - 1, s, t, sCoordinate, tCoordinate, arcFactor, tg.getEdgeLabelString(e), ew, tg.isDirected(), nc.RGB(c.getCommunity(e / 2) + 1));
        }
        this.printFinalLines(PS);
    }

    public void outputEdgeLabels(PrintStream PS, timgraph tg, int numberLabels) {
        JavaColours nc = new JavaColours(numberLabels + 1, true);
        if (tg.isInfoLeveLGreaterThan(1)) {
            nc.printAllColours(System.out);
        }
        this.printInitialLines(PS, tg.outputName.getNameRoot(), tg.isDirected());
        for (int v = 0; v < tg.getNumberVertices(); ++v) {
            this.printNodeColoured(PS, v, tg.getNumberVertices(), tg.getVertexLabel(v), null);
        }
        int s = -1;
        int t = -1;
        double arcFactor = tg.isDirected() ? -0.01 : -9.753472E48;
        for (int e = 0; e < tg.getNumberStubs(); ++e) {
            s = tg.getVertexFromEdge(e++);
            t = tg.getVertexFromEdge(e);
            Coordinate sCoordinate = tg.getVertexPosition(s);
            Coordinate tCoordinate = tg.getVertexPosition(t);
            double ew = tg.getEdgeWeightSlow(e);
            this.printEdgeColoured(PS, e - 1, s, t, sCoordinate, tCoordinate, arcFactor, tg.getEdgeLabelString(e), ew, tg.isDirected(), nc.RGB(tg.getEdgeLabel(e) + 1));
        }
        this.printFinalLines(PS);
    }

    public void outputVertexEdgePartition(PrintStream PS, timgraph tg, VertexPartition vp, VertexPartition ep) {
        JavaColours nc = new JavaColours(Math.max(vp.getNumberOfCommunities(), ep.getNumberOfCommunities()) + 1, true);
        if (tg.isInfoLeveLGreaterThan(1)) {
            System.out.println("no vp = " + vp.getNumberOfCommunities() + ", no. EP = " + ep.getNumberOfCommunities());
            nc.printColourInfo(System.out);
        }
        this.printInitialLines(PS, tg.outputName.getNameRoot(), tg.isDirected());
        for (int v = 0; v < tg.getNumberVertices(); ++v) {
            int vc = vp.getCommunity(v);
            this.printNodeColoured(PS, v, tg.getNumberVertices(), tg.getVertexLabel(v), nc);
        }
        int cshift = 1;
        int s = -1;
        int t = -1;
        double arcFactor = tg.isDirected() ? -0.01 : -9.753472E48;
        for (int e = 0; e < tg.getNumberStubs(); ++e) {
            s = tg.getVertexFromEdge(e++);
            t = tg.getVertexFromEdge(e);
            double ew = tg.getEdgeWeightSlow(e);
            Coordinate sCoordinate = tg.getVertexPosition(s);
            Coordinate tCoordinate = tg.getVertexPosition(t);
            this.printEdgeColoured(PS, e - 1, s, t, sCoordinate, tCoordinate, arcFactor, tg.getEdgeLabelString(e), ew, tg.isDirected(), nc.RGB(ep.getCommunity(e / 2) + cshift));
        }
        this.printFinalLines(PS);
    }

    public void outputIncidenceVertexPartition(PrintStream PS, timgraph tg, VertexPartition ip) {
        JavaColours nc = new JavaColours(ip.getNumberOfCommunities() + 2, true);
        if (tg.isInfoLeveLGreaterThan(1)) {
            System.out.println("no ip = " + ip.getNumberOfCommunities());
            nc.printColourInfo(System.out);
        }
        this.printInitialLines(PS, tg.outputName.getNameRoot(), tg.isDirected());
        int nv1 = tg.getNumberVertices();
        for (int v = 0; v < nv1; ++v) {
            int ic = ip.getCommunity(v);
            this.printNodeColoured(PS, v, tg.getNumberVertices(), tg.getVertexLabel(v), nc);
        }
        int cshift = 1;
        int s = -1;
        int t = -1;
        double arcFactor = tg.isDirected() ? -0.01 : -9.753472E48;
        for (int e = 0; e < tg.getNumberStubs(); ++e) {
            s = tg.getVertexFromEdge(e++);
            t = tg.getVertexFromEdge(e);
            Coordinate sCoordinate = tg.getVertexPosition(s);
            Coordinate tCoordinate = tg.getVertexPosition(t);
            double ew = tg.getEdgeWeightSlow(e);
            this.printEdgeColoured(PS, e - 1, s, t, sCoordinate, tCoordinate, arcFactor, tg.getEdgeLabelString(e), ew, tg.isDirected(), nc.RGB(ip.getCommunity(nv1 + e / 2) + cshift));
        }
        this.printFinalLines(PS);
    }

    public static String startTag(String s) {
        return "<" + s + ">";
    }

    public static String startEndTag(String s) {
        return "<" + s + "/>";
    }

    public static String endTag(String s) {
        return "</" + s + ">";
    }

    public void printlnStartTag(PrintStream PS, String s) {
        PS.println(indentString.substring(0, this.indent++) + GraphMLGenerator.startTag(s));
    }

    public void printlnEndTag(PrintStream PS, String s) {
        PS.println(indentString.substring(0, --this.indent) + GraphMLGenerator.endTag(s));
    }

    public void printlnStartEndTag(PrintStream PS, String s) {
        PS.println(indentString.substring(0, this.indent) + GraphMLGenerator.startEndTag(s));
    }

    public void printlnStartEndTag(PrintStream PS, String tag, String info) {
        this.printlnStartTag(PS, tag);
        PS.println(indentString.substring(0, this.indent) + info);
        this.printlnEndTag(PS, tag);
    }

    public void printlnDataTag(PrintStream PS, String key, String s) {
        PS.println(indentString.substring(0, this.indent) + GraphMLGenerator.startTag("data key=\"" + key + "\" ") + s + GraphMLGenerator.endTag("data"));
    }

    public static String valueString(String valueName, int value) {
        return valueName + "=\"" + value + "\"";
    }

    public static String valueString(String valueName, String value) {
        return valueName + "=\"" + value + "\"";
    }

    public static String valueString(String valueName, double value) {
        return valueName + "=\"" + value + "\"";
    }

    public static String valueString(String valueName, float value) {
        return valueName + "=\"" + value + "\"";
    }

    public void printInitialLines(PrintStream PS, String name, boolean directed) {
        int i;
        for (i = 0; i < firstLines.length; ++i) {
            PS.println(firstLines[i]);
        }
        for (i = 0; i < keyDefinitions.length; ++i) {
            PS.println(keyDefinitions[i]);
        }
        String ds = "";
        if (!directed) {
            ds = "un";
        }
        this.printlnStartTag(PS, "graph id=\"" + name + "\" edgedefault=\"" + ds + "directed\"");
    }

    public void printFinalLines(PrintStream PS) {
        this.printlnEndTag(PS, "graph");
        this.printlnEndTag(PS, "graphml");
    }

    public String processNodeName(String name) {
        String s = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            s = c == '&' ? s + "and" : s + c;
        }
        return s;
    }

    public void printNodeNameTag(PrintStream PS, String name) {
        if (name.length() == 0) {
            return;
        }
        String s = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            s = c == '&' ? s + "and" : s + c;
        }
        this.printlnDataTag(PS, "d1", name);
    }

    public void printNode(PrintStream PS, int nodeNumber, String name) {
        this.printlnStartTag(PS, "node " + GraphMLGenerator.valueString("id", "n" + nodeNumber));
        this.printNodeNameTag(PS, name);
        this.printNodeNameTag(PS, name);
        this.printlnEndTag(PS, "node");
    }

    public void printNodeColoured(PrintStream PS, int nodeNumber, int totalNumberNodes, VertexLabel vl, JavaColours jc) {
        double w;
        double h = w = 30.0;
        this.printNodeColoured(PS, nodeNumber, totalNumberNodes, vl, -1, -1, w, h, jc);
    }

    public void printNodeColoured(PrintStream PS, int nodeNumber, int totalNumberNodes, VertexLabel vl, int colourNumber, int shapeNumber, JavaColours jc) {
        double w;
        double h = w = 30.0;
        this.printNodeColoured(PS, nodeNumber, totalNumberNodes, vl, colourNumber, shapeNumber, w, h, jc);
    }

    public void printNodeColoured(PrintStream PS, int nodeNumber, int totalNumberNodes, VertexLabel vl, int colourNumber, int shapeNumber, double w, double h, JavaColours jc) {
        double xpos = 300.0 * (double)nodeNumber / (double)totalNumberNodes;
        double ypos = 0.0;
        if (vl != null && vl.hasPosition()) {
            xpos = vl.getPosition().getX();
            ypos = vl.getPosition().getY();
        } else {
            double posScale = 300.0;
            double angle = Math.PI * 2 * (double)nodeNumber / (double)totalNumberNodes;
            xpos = posScale * Math.sin(angle);
            ypos = posScale * Math.cos(angle);
        }
        String name = vl != null && vl.hasName() ? vl.getName() : Integer.toString(nodeNumber);
        String cstring = DEFAULTVERTEXCOLOUR;
        int nodeShape = -1;
        if (vl != null && jc != null && vl.hasNumber()) {
            int n = nodeShape = shapeNumber < 0 ? vl.getNumber() : shapeNumber;
            if (colourNumber < 1 || colourNumber > jc.getNumberColours()) {
                colourNumber = nodeShape + 1;
            }
            cstring = jc.RGB(colourNumber);
        }
        this.printNodeColoured(PS, nodeNumber, totalNumberNodes, xpos, ypos, w, h, name, cstring, nodeShape);
    }

    public void printNodeColouredOLD(PrintStream PS, int nodeNumber, int totalNumberNodes, String name, String cstring, int nodeShape) {
        this.printlnStartTag(PS, "node " + GraphMLGenerator.valueString("id", "n" + nodeNumber));
        this.printlnStartTag(PS, "data key=\"d0\" ");
        this.printlnStartTag(PS, "visone:shapeNode ");
        this.printlnStartTag(PS, "y:ShapeNode ");
        this.printNodePosition(PS, nodeNumber, totalNumberNodes);
        if (cstring.length() == 6) {
            this.printlnStartEndTag(PS, "y:Fill color=\"#" + cstring + "\"  transparent=\"false\"");
        } else {
            this.printlnStartEndTag(PS, "y:Fill hasColor=\"false\"  transparent=\"false\"");
        }
        this.printlnStartEndTag(PS, "y:Shape type=\"" + GraphMLGenerator.getNodeShape(nodeShape) + "\"");
        this.printlnEndTag(PS, "y:ShapeNode ");
        this.printlnEndTag(PS, "visone:shapeNode ");
        this.printlnEndTag(PS, "data");
        this.printNodeNameTag(PS, name);
        this.printlnEndTag(PS, "node");
    }

    public void printNodeColoured(PrintStream PS, int nodeNumber, int totalNumberNodes, double xpos, double ypos, double w, double h, String name, String cstring, int nodeShape) {
        this.printNodeColoured(PS, nodeNumber, totalNumberNodes, xpos, ypos, w, h, name, cstring, GraphMLGenerator.getNodeShape(nodeShape));
    }

    public void printNodeColoured(PrintStream PS, int nodeNumber, int totalNumberNodes, double xpos, double ypos, double w, double h, String name, String cstring, String nodeShape) {
        this.printlnStartTag(PS, "node " + GraphMLGenerator.valueString("id", "n" + nodeNumber));
        this.printlnStartTag(PS, "data key=\"d0\" ");
        this.printlnStartTag(PS, "visone:shapeNode ");
        this.printlnStartTag(PS, "y:ShapeNode ");
        if (w > 0.0 && h > 0.0) {
            this.printNodePosition(PS, xpos, ypos, w, h);
        } else {
            this.printNodePosition(PS, nodeNumber, totalNumberNodes);
        }
        if (cstring.length() == 6) {
            this.printlnStartEndTag(PS, "y:Fill color=\"#" + cstring + "\"  transparent=\"false\"");
        } else {
            this.printlnStartEndTag(PS, "y:Fill hasColor=\"false\"  transparent=\"false\"");
        }
        this.printlnStartEndTag(PS, "y:Shape type=\"" + GraphMLGenerator.shape(nodeShape) + "\"");
        this.printlnEndTag(PS, "y:ShapeNode ");
        this.printlnEndTag(PS, "visone:shapeNode ");
        this.printlnEndTag(PS, "data");
        this.printNodeNameTag(PS, name);
        this.printlnEndTag(PS, "node");
    }

    private static String getNodeShape(int n) {
        if (n < 0 || n >= shapeTypes.length) {
            return shapeTypes[0];
        }
        return shapeTypes[n];
    }

    public static String shape(String input) {
        String s = input;
        for (int v = 0; v < shapeTypes.length; ++v) {
            if (!shapeTypes[v].equalsIgnoreCase(s)) continue;
            return shapeTypes[v];
        }
        return shapeTypes[0];
    }

    private void printNodePosition(PrintStream PS, int nodeNumber, int totalNumberNodes) {
        double w = 30.0;
        double h = 30.0;
        double posScale = 300.0;
        double angle = Math.PI * 2 * (double)nodeNumber / (double)totalNumberNodes;
        double xpos = posScale * Math.sin(angle);
        double ypos = posScale * Math.cos(angle);
        this.printNodePosition(PS, xpos, ypos, w, h);
    }

    public void printNodePosition(PrintStream PS, double xpos, double ypos, double w, double h) {
        this.printlnStartEndTag(PS, "y:Geometry  " + GraphMLGenerator.valueString("x", xpos) + " " + GraphMLGenerator.valueString("y", ypos) + " " + GraphMLGenerator.valueString("width", w) + " " + GraphMLGenerator.valueString("height", h));
    }

    private void printNodeLabel(PrintStream PS, String label) {
        this.printlnStartEndTag(PS, "y:Geometry", label);
    }

    public void printEdgeSimple(PrintStream PS, int edgeNumber, int source, int target, String name) {
        this.printlnStartTag(PS, "edge " + GraphMLGenerator.valueString("id", "e" + edgeNumber) + " " + GraphMLGenerator.valueString("source", "n" + source) + " " + GraphMLGenerator.valueString("target", "n" + target) + " ");
        if (name.length() > 0) {
            this.printlnDataTag(PS, "d5", name);
        }
        this.printlnEndTag(PS, "edge");
    }

    public void printEdgeSimple(PrintStream PS, int edgeNumber, int source, int target, String name, boolean targetArrowsOn) {
        this.printEdgeColoured(PS, edgeNumber, source, target, null, null, -9.753472E48, name, 1.0, targetArrowsOn, DEFAULTEDGECOLOUR);
    }

    public void printEdgeColoured(PrintStream PS, int edgeNumber, int source, int target, Coordinate sourcePosition, Coordinate targetPosition, double arcFactor, String name, double width, boolean targetArrowsOn, String cstring) {
        if (arcFactor == -9.753472E48 || sourcePosition == null || targetPosition == null) {
            this.printPolyLineEdge(PS, edgeNumber, source, target, name, width, targetArrowsOn, cstring);
        } else {
            this.printArcEdge(PS, edgeNumber, source, target, sourcePosition, targetPosition, arcFactor, name, width, targetArrowsOn, cstring);
        }
    }

    public void printPolyLineEdge(PrintStream PS, int edgeNumber, int source, int target, String name, double width, boolean targetArrowsOn, String cstring) {
        this.printlnStartTag(PS, "edge " + GraphMLGenerator.valueString("id", "e" + edgeNumber) + " " + GraphMLGenerator.valueString("source", "n" + source) + " " + GraphMLGenerator.valueString("target", "n" + target) + " ");
        this.printlnStartTag(PS, "data key=\"d2\" ");
        this.printlnStartTag(PS, "visone:polyLineEdge ");
        this.printlnStartTag(PS, "y:PolyLineEdge ");
        double visualWidth = width < 1.0 ? 1.0 : width;
        this.printlnStartEndTag(PS, "y:LineStyle type=\"line\" " + GraphMLGenerator.valueString("width", visualWidth) + " color=\"#" + (cstring.length() == 6 ? cstring : DEFAULTEDGECOLOUR) + "\"");
        if (targetArrowsOn) {
            this.printlnStartEndTag(PS, "y:Arrows source=\"none\" target=\"StandardArrow\"");
        }
        this.printlnEndTag(PS, "y:PolyLineEdge ");
        this.printlnEndTag(PS, "visone:polyLineEdge ");
        this.printlnEndTag(PS, "data");
        if (name.length() > 0) {
            this.printlnDataTag(PS, "d5", name);
        }
        this.printlnEndTag(PS, "edge");
    }

    public void printArcEdge(PrintStream PS, int edgeNumber, int source, int target, Coordinate sourcePosition, Coordinate targetPosition, double arcFactor, String name, double width, boolean targetArrowsOn, String cstring) {
        this.printlnStartTag(PS, "edge " + GraphMLGenerator.valueString("id", "e" + edgeNumber) + " " + GraphMLGenerator.valueString("source", "n" + source) + " " + GraphMLGenerator.valueString("target", "n" + target) + " ");
        this.printlnStartTag(PS, "data key=\"d2\" ");
        this.printlnStartTag(PS, "visone:arcEdge");
        this.printlnStartTag(PS, "y:ArcEdge");
        this.printlnStartTag(PS, "y:Path sx=\"-0.0\" sy=\"0.0\" tx=\"-0.0\" ty=\"0.0\" ");
        Coordinate arcCoordinate = Coordinate.calcArc2DCoordinate(sourcePosition, targetPosition, arcFactor);
        this.printlnStartEndTag(PS, "y:Point x=\"" + arcCoordinate.getX() + "\" y=\"" + arcCoordinate.getY() + "\" ");
        this.printlnEndTag(PS, "y:Path");
        double visualWidth = width < 1.0 ? 1.0 : width;
        this.printlnStartEndTag(PS, "y:LineStyle type=\"line\" " + GraphMLGenerator.valueString("width", visualWidth) + " color=\"#" + (cstring.length() == 6 ? cstring : DEFAULTEDGECOLOUR) + "\"");
        if (targetArrowsOn) {
            this.printlnStartEndTag(PS, "y:Arrows source=\"none\" target=\"StandardArrow\"");
        }
        this.printlnEndTag(PS, "y:ArcEdge");
        this.printlnEndTag(PS, "visone:arcEdge");
        this.printlnEndTag(PS, "data");
        if (name.length() > 0) {
            this.printlnDataTag(PS, "d5", name);
        }
        this.printlnEndTag(PS, "edge");
    }

    public void printTextTag(PrintStream PS, String tagName, String text) {
        this.printlnStartTag(PS, tagName);
        PS.println(text);
        this.printlnEndTag(PS, tagName);
    }

    public static String textTag(String tagName, String text) {
        return GraphMLGenerator.startTag(tagName) + text + GraphMLGenerator.endTag(tagName);
    }

    public void printName(PrintStream PS, String name) {
        this.printTextTag(PS, "name", name);
    }

    public void printDescription(PrintStream PS, String description) {
        this.printTextTag(PS, "description", description);
    }
}

