/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import JavaNotes.TextReader;
import TimUtilities.StringUtilities.Filters.StringFilter;
import TimUtilities.StringUtilities.Stemmers.Porter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Map;
import java.util.Set;

public class FileStemmer {
    public int nmax = 1000;

    public static void processStringFile(String inputFileName, String outputFileName, int ignoreColumn, String sep, Map<String, String> stemMap, StringFilter sf, int sampleFrequency, boolean showProcess) {
        PrintStream PS;
        TextReader data;
        boolean makeMap = true;
        if (stemMap == null) {
            makeMap = false;
        }
        boolean readSome = true;
        if (sampleFrequency < 2) {
            readSome = false;
        }
        Porter stemmer = new Porter();
        try {
            System.out.println(" Opening Input File:  " + inputFileName);
            data = new TextReader((Reader)new FileReader(inputFileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Input file " + inputFileName + " not found, " + e);
        }
        try {
            System.out.println(" Opening Output File: " + outputFileName);
            PS = new PrintStream(new FileOutputStream(outputFileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Output file " + outputFileName + " not found, " + e);
        }
        int linenumber = 0;
        int column = 0;
        try {
            while (!data.eof()) {
                column = 0;
                if (readSome && ++linenumber % sampleFrequency != 1) {
                    data.getln();
                    continue;
                }
                if (showProcess) {
                    System.out.print(linenumber + ": ");
                }
                while (!data.eoln()) {
                    String w = data.getWord();
                    ++column;
                    if (showProcess) {
                        System.out.print("\t" + w);
                    }
                    if (column == ignoreColumn) {
                        PS.print(w + sep);
                        continue;
                    }
                    if (sf.isAcceptableElseRemember(w)) {
                        String s = stemmer.stem(w);
                        PS.print(s + sep);
                        if (showProcess && s.length() != w.length()) {
                            System.out.print("->" + s);
                        }
                        if (!makeMap || s.length() == w.length()) continue;
                        stemMap.put(w, s);
                        continue;
                    }
                    if (!showProcess) continue;
                    System.out.print(w + "<-### " + sep);
                }
                if (showProcess) {
                    System.out.println();
                }
                PS.println();
            }
        }
        catch (TextReader.Error e) {
            throw new RuntimeException("*** Input Error on line " + linenumber + " column " + column + ": " + e.getMessage());
        }
        finally {
            data.close();
            PS.close();
        }
        System.out.println(" Finished " + outputFileName + " stemmed " + stemMap.size() + " words and filtered out " + sf.numberRejectedString() + " words");
    }

    public static void printMap(PrintStream PS, String sep, Map<String, String> stemMap) {
        Set<String> keys = stemMap.keySet();
        for (String k : keys) {
            PS.println(k + sep + stemMap.get(k));
        }
    }

    public static boolean isAlphabetic(String s) {
        for (int c = 0; c < s.length(); ++c) {
            if (Character.isLetter(s.charAt(c))) continue;
            return false;
        }
        return true;
    }
}

