/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import TimGraph.AdjacencyMatrix;
import TimGraph.Community.Community;
import TimGraph.Community.Partition;
import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.VertexLabel;
import TimGraph.io.GraphMLGenerator;
import TimGraph.io.GraphViz;
import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileNameSequence;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;

public class FileOutput {
    private static final String NOEDGELABELLINGNAME = "NOEDGELABELLINGNAME";
    timgraph tg;
    int infoLevel = 0;
    public FileNameSequence fileName;

    public FileOutput(timgraph inputtg) {
        this.tg = inputtg;
        this.infoLevel = inputtg.infoLevel;
        this.fileName = new FileNameSequence(this.tg.outputName);
    }

    public FileOutput(FileNameSequence inputFNS) {
        this.fileName = new FileNameSequence(inputFNS);
    }

    public static void map(Map m, String fileName, String[] headerLines, String sep, boolean infoOn) {
        if (infoOn) {
            System.out.println("Writing file of map to " + fileName);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fileName);
            PrintStream PS = new PrintStream(fout);
            for (int line = 0; line < headerLines.length; ++line) {
                PS.println(headerLines[line]);
            }
            for (Object k : m.keySet()) {
                PS.println(k + sep + m.get(k));
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                throw new RuntimeException("*** File Error with " + fileName + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("*** Error opening output file " + fileName + " " + e.getMessage());
        }
        if (infoOn) {
            System.out.println("Finished writing file of map to " + fileName);
        }
    }

    public void graphViz() {
        GraphViz gv = new GraphViz();
        this.fileName.setNameEnd("output.gv");
        if (this.infoLevel > -2) {
            System.out.println("Writing GraphViz file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gv.output(PS, this.tg, true);
            if (this.infoLevel > -2) {
                System.err.println("Finished writing GraphViz file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void adjacencyMatrix(String sep, boolean labelsOn, boolean namesOn) {
        this.fileName.setNameEnd("outputAdjMat.dat");
        String[] namesArray = null;
        if (labelsOn && namesOn) {
            namesArray = this.tg.getVertexNameArray();
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            AdjacencyMatrix am = new AdjacencyMatrix(this.tg);
            am.printMatrix(PS, sep, namesArray, namesOn);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing adjacecncy matrix file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void pajek() {
        this.pajek(true, true);
    }

    public void pajek(boolean vertexCoordinateOn, boolean colourOn) {
        this.fileName.setNameEnd("output.net");
        try {
            String s;
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println("*Vertices " + this.tg.getNumberVertices());
            this.tg.calcMinMaxVertexLabel();
            for (int v = 1; v <= this.tg.getNumberVertices(); ++v) {
                PS.print(v);
                if (this.tg.isVertexLabelled()) {
                    s = vertexCoordinateOn && this.tg.getMaximumVertexCoordinate() != null ? " " + this.tg.getVertexLabel(v - 1).pajekString(this.tg.getMinimumVertexCoordinate(), this.tg.getMaximumVertexCoordinate()) : " " + this.tg.getVertexLabel(v - 1).quotedNameString();
                    PS.print(s);
                }
                PS.println();
            }
            if (this.tg.isDirected()) {
                PS.println("*Arcs " + this.tg.getNumberEdges());
            } else {
                PS.println("*Edges " + this.tg.getNumberEdges());
            }
            int vs = -1;
            int vt = -1;
            int temp = -1;
            for (int e = 0; e < this.tg.getNumberStubs(); e += 2) {
                vs = this.tg.getVertexFromEdge(e);
                vt = this.tg.getVertexFromEdge(e + 1);
                if (!this.tg.isDirected() && vs > vt) {
                    PS.print(vt + 1 + "   " + (vs + 1));
                } else {
                    PS.print(vs + 1 + "   " + (vt + 1));
                }
                if (this.tg.isWeighted()) {
                    s = "  " + this.tg.getEdgeWeight(e);
                    if (colourOn) {
                        s = s + "  c " + this.tg.getPajekColour(this.tg.getEdgeLabel(e));
                    }
                    PS.println(s);
                    continue;
                }
                PS.println();
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing pajek file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void pajekPartition(String fileNameEnding, int[] values) {
        if (values.length != this.tg.getNumberVertices()) {
            System.err.println("*** Error length of partition " + values.length + " not equal to number of vertices " + this.tg.getNumberVertices());
            return;
        }
        this.fileName.setNameEnd(fileNameEnding);
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println("*Vertices " + this.tg.getNumberVertices());
            for (int v = 0; v < this.tg.getNumberVertices(); ++v) {
                PS.println(values[v]);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge list file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void pajekPartition(String fileNameEnding, VertexPartition vp) {
        if (vp.getNumberVertices() != this.tg.getNumberVertices()) {
            System.err.println("*** Error vertices in partition " + vp.getNumberVertices() + " not equal to number of vertices " + this.tg.getNumberVertices());
            return;
        }
        this.pajekPartition(fileNameEnding, vp.getCommunity());
    }

    public void edgeListSimple() {
        this.printEdges(-3.57986421E8, false, false, false, false, "");
    }

    public void edgeListSimple(boolean asNames) {
        this.printEdges(-3.57986421E8, asNames, false, false, false, "");
    }

    public void printEdges(double minWeight, boolean asNames, boolean infoOn, boolean headerOn, boolean edgeIndexOn, boolean edgeLabelOn) {
        if (edgeLabelOn) {
            this.printEdges(minWeight, asNames, infoOn, headerOn, edgeIndexOn, NOEDGELABELLINGNAME);
        } else {
            this.printEdges(minWeight, asNames, infoOn, headerOn, edgeIndexOn, "");
        }
    }

    public void printEdges(boolean asNames, boolean infoOn, boolean headerOn, boolean edgeIndexOn, boolean edgeLabelOn) {
        if (edgeLabelOn) {
            this.printEdges(-3.57986421E8, asNames, infoOn, headerOn, edgeIndexOn, NOEDGELABELLINGNAME);
        } else {
            this.printEdges(-3.57986421E8, asNames, infoOn, headerOn, edgeIndexOn, "");
        }
    }

    public void printEdges(boolean asNames, boolean infoOn, boolean headerOn, boolean edgeIndexOn, String edgeLabelName) {
        this.printEdges(-3.57986421E8, asNames, infoOn, headerOn, edgeIndexOn, edgeLabelName);
    }

    public void printEdges(double minWeight, boolean asNames, boolean infoOn, boolean headerOn, boolean edgeIndexOn, String edgeLabelName) {
        boolean useLabels;
        boolean edgeLabelOn = false;
        String fullfilename = this.fileName.getNameRootFullPath();
        if (edgeLabelName.length() > 0) {
            edgeLabelOn = true;
            if (!edgeLabelName.equals(NOEDGELABELLINGNAME)) {
                fullfilename = fullfilename + edgeLabelName;
            }
        }
        fullfilename = (useLabels = asNames & this.tg.isVertexLabelled()) ? fullfilename + "outputELS.dat" : fullfilename + "outputEL.dat";
        if (this.infoLevel > -2) {
            System.out.println("Writing edge list file with vertex " + (useLabels ? "labels" : "numbers") + " to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            this.tg.printEdges(PS, "#", " \t", minWeight, useLabels, infoOn, headerOn, edgeIndexOn, edgeLabelOn);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge list file to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }

    public void printPartitionStats(Partition vp, String cc, String sep, boolean infoOn, boolean headerOn) {
        String fullfilename = this.fileName.getNameRootFullPath() + vp.getName() + "stats.dat";
        if (this.infoLevel > -2) {
            System.out.println("Writing partition statistics to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            vp.printStatistics(PS, cc, sep, infoOn, headerOn);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing partition statistics to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }

    public void printEdgeCommunityStats(boolean asNames, boolean headerOn, boolean splitBipartite, boolean outputType1) {
        this.printEdgeCommunityStats("", asNames, headerOn, splitBipartite, outputType1);
    }

    public void printEdgeCommunityStats(String addToFileNameRoot, boolean asNames, boolean headerOn, boolean splitBipartite, boolean outputType1) {
        String fullfilename = this.fileName.getNameRootFullPath();
        boolean useLabels = asNames & this.tg.isVertexLabelled();
        fullfilename = useLabels ? fullfilename + "_" + addToFileNameRoot + "output.vcis" : fullfilename + "_" + addToFileNameRoot + "output.vci";
        if (this.infoLevel > -2) {
            System.out.println("Writing edge community information by vertex " + (useLabels ? "labels" : "numbers") + " to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            this.tg.printEdgeCommunityStats(PS, "\t", headerOn, useLabels, splitBipartite, outputType1);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge community information by vertex file to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }

    public void graphML() {
        this.graphML("", -3.57986421E8);
    }

    public void graphML(String ending, double edgeWeightMinimum) {
        GraphMLGenerator gml = new GraphMLGenerator();
        if (edgeWeightMinimum > 0.0) {
            this.fileName.setNameEnd(ending + "ew" + edgeWeightMinimum + ".graphML");
        } else {
            this.fileName.setNameEnd(ending + ".graphML");
        }
        boolean targetArrowsOn = this.tg.isDirected();
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gml.outputGraph(PS, this.tg, edgeWeightMinimum, targetArrowsOn);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void graphMLVertexPartition(Partition c) {
        GraphMLGenerator gml = new GraphMLGenerator();
        this.fileName.setNameEnd("_" + c.getName() + "VP.graphML");
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gml.outputVertexPartition(PS, this.tg, c);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void graphMLEdgePartition(Partition c) {
        GraphMLGenerator gml = new GraphMLGenerator();
        this.fileName.setNameEnd("_" + c.getName() + "EP.graphML");
        if (this.infoLevel > -2) {
            System.out.println("Writing edge partition GraphML file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gml.outputEdgePartition(PS, this.tg, c);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge partition GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void graphMLEdgePartition(int numberLabels) {
        GraphMLGenerator gml = new GraphMLGenerator();
        this.fileName.setNameEnd("_EP.graphML");
        if (this.infoLevel > -2) {
            System.out.println("Writing edge partition GraphML file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gml.outputEdgeLabels(PS, this.tg, numberLabels);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge partition GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void graphMLVertexEdgePartition(VertexPartition vp, VertexPartition ep) {
        GraphMLGenerator gml = new GraphMLGenerator();
        this.fileName.setNameEnd("_" + vp.getName() + "VP_" + ep.getName() + "EP.graphML");
        if (this.infoLevel > -2) {
            System.out.println("Writing DualGraphML file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gml.outputVertexEdgePartition(PS, this.tg, vp, ep);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing DualGraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void graphMLIncidencePartition(VertexPartition c) {
        GraphMLGenerator gml = new GraphMLGenerator();
        this.fileName.setNameEnd("_" + c.getName() + "IVP.graphML");
        if (this.infoLevel > -2) {
            System.out.println("Writing incidence matrix vertex partition GraphML file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gml.outputIncidenceVertexPartition(PS, this.tg, c);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing incidence matrix vertex partition GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void informationNetworkBasic(String cc, String sep) {
        this.fileName.setNameEnd("info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing basic network information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + this.fileName.getNameRoot());
            this.tg.printParametersBasic(PS, sep);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex and edge information file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void informationVertexEdgePartition(VertexPartition vp, VertexPartition ep, String cc, String sep, boolean listPartitionOn) {
        this.fileName.setNameEnd("_" + vp.getName() + "VP_" + ep.getName() + "EP_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing vertex and edge partition information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + this.fileName.getNameRoot());
            vp.printInformation(PS, cc + vp.getName() + " Vertex Partition" + sep, sep);
            ep.printInformation(PS, cc + ep.getName() + " Edge Partition" + sep, sep);
            if (listPartitionOn) {
                PS.println(cc + this.fileName.getNameRoot() + sep + "Vertex Partition");
                vp.printCommunityMatrix(PS, cc, sep);
                PS.println(cc + this.fileName.getNameRoot() + sep + "Edge Partition");
                ep.printCommunityMatrix(PS, cc, sep);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex and edge information file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void informationVertexCommunity(Community vc, String cc, String sep, boolean listCommunityOn) {
        this.fileName.setNameEnd("_" + vc.getName() + "VC_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing vertex community information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + this.fileName.getNameRoot());
            vc.printInformation(PS, cc + vc.getName() + "Vertex Community" + sep, sep);
            if (listCommunityOn) {
                PS.println(cc + this.fileName.getNameRoot() + sep + "Vertex Community");
                vc.printCommunityMatrix(PS, cc, sep);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex community information file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void printVertexCommunity(Community vc, String cc, String sep, boolean headerOn, boolean ElementLabelsOn) {
        this.fileName.setNameEnd("_" + vc.getName() + "VC.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing vertex community to file " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            vc.printCommunityMatrixSparse(PS, cc, sep, headerOn, ElementLabelsOn);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex community information file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void informationPartition(Partition vp, String cc, String sep, boolean listPartitionOn) {
        this.fileName.setNameEnd("_" + vp.getName() + "P_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing partition information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + this.fileName.getNameRoot());
            vp.printInformation(PS, cc + vp.getName() + "Partition" + sep, sep);
            if (listPartitionOn) {
                PS.println(cc + this.fileName.getNameRoot() + sep + "Vertex Partition");
                vp.printCommunityMatrix(PS, cc, sep);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing partition information file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void informationEdgePartition(Partition ep, String cc, String sep, boolean listPartitionOn) {
        this.fileName.setNameEnd("_" + ep.getName() + "EP_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing edge partition information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + this.fileName.getNameRoot());
            ep.printInformation(PS, cc + ep.getName() + "  Edge Partition" + sep, sep);
            if (listPartitionOn) {
                PS.println(cc + this.fileName.getNameRoot() + sep + "Edge Partition");
                ep.printCommunityMatrix(PS, cc, sep);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex partition information file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void informationIncidenceVertexPartition(VertexPartition ip, String cc, String sep, boolean listPartitionOn) {
        this.fileName.setNameEnd("_" + ip.getName() + "IVP_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing incidence matrix vertex partition information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + this.fileName.getNameRoot());
            ip.printInformation(PS, cc + ip.getName() + "Incidence Matrix Vertex Partition" + sep, sep);
            if (listPartitionOn) {
                PS.println(cc + this.fileName.getNameRoot() + sep + "Incidence Matrix Vertex Partition");
                ip.printCommunityMatrix(PS, cc, sep);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex information file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void printVertices(String cc, String sep, boolean infoOn, boolean headerOn, VertexPartition vp, boolean simpleListOn) {
        String ext = simpleListOn ? "inputBVNLS.dat" : "vertices.dat";
        this.fileName.setNameEnd((vp == null ? "" : vp.getName()) + ext);
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            if (simpleListOn) {
                vp.printSimpleVertexCommunityList(PS, cc, sep, infoOn, headerOn);
            } else {
                vp.printVertices(PS, cc, sep, infoOn, headerOn);
            }
            if (this.infoLevel > -2) {
                if (simpleListOn) {
                    System.out.println("Finished writing simple list of vertex - partition pairs to file " + this.fileName.getFullFileName());
                } else {
                    System.out.println("Finished writing vertices and their vertex partition information to file " + this.fileName.getFullFileName());
                }
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void printVertices(String cc, String sep, VertexPartition vp, boolean printTriangles, boolean printSquares, boolean printNearestNeighbours) {
        boolean printName = false;
        boolean printNumber = false;
        boolean printPosition = false;
        boolean printStrength = false;
        boolean printRank = false;
        if (this.tg.isVertexLabelled()) {
            VertexLabel l = this.tg.getVertexLabel(0);
            printName = l.hasName();
            printNumber = l.hasNumber();
            printPosition = l.hasPosition();
            printStrength = l.hasStrength();
            printRank = l.hasRank();
        }
        this.printVertices(cc, sep, vp, printTriangles, printSquares, printName, printNumber, printPosition, printStrength, printRank, printNearestNeighbours);
    }

    public void printVertices(String cc, String sep, VertexPartition vp, boolean printTriangles, boolean printSquares, boolean printName, boolean printNumber, boolean printPosition, boolean printStrength, boolean printRank, boolean printNearestNeighbours) {
        this.fileName.setNameEnd((vp == null ? "" : "_" + vp.getName()) + "vertices.dat");
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            this.tg.printVertices(PS, cc, sep, vp, printTriangles, printSquares, printName, printNumber, printPosition, printStrength, printRank, printNearestNeighbours);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex information file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void printMotifs(String cc, String sep, String ext, int[] motifToLabel, ArrayList<ArrayList<Integer>> motifToVertex, boolean motifIndexOn, boolean headerOn) {
        this.fileName.setNameEnd(ext);
        if (this.infoLevel > -2) {
            System.out.println("Writing motifs to file " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            int numberMotif = -9753257;
            boolean motifLabelOn = false;
            if (motifToLabel.length > 0) {
                motifLabelOn = true;
                numberMotif = motifToLabel.length;
            }
            boolean motifVerticesOn = false;
            if (motifToVertex != null) {
                motifVerticesOn = true;
                if (numberMotif > 0) {
                    if (numberMotif != motifToVertex.size()) {
                        throw new RuntimeException("Two different numbers of motifs " + numberMotif + " and " + motifToVertex.size());
                    }
                } else {
                    numberMotif = motifToVertex.size();
                }
            }
            if (numberMotif <= 0) {
                System.err.println("Nothing to print in printMotifs");
                return;
            }
            if (headerOn) {
                PS.println((motifIndexOn ? "Motif_Index" + sep : "") + (motifLabelOn ? "Motif_Label" + sep : "") + (motifLabelOn ? "Motif_Vertex_List" : ""));
            }
            for (int m = 0; m < numberMotif; ++m) {
                PS.print((motifIndexOn ? m + sep : "") + (motifLabelOn ? motifToLabel[m] + sep : ""));
                ArrayList<Integer> motif = motifToVertex.get(m);
                for (int v = 0; v < motif.size(); ++v) {
                    PS.print((v == 0 ? "" : sep) + motif.get(v));
                }
                PS.println();
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing motif file to " + this.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + e.getMessage());
            return;
        }
    }

    public void informationGeneral(String cc, String sep) {
        this.informationGeneral(cc, sep, true, true, true, true, false, null);
    }

    public void informationGeneral(String cc, String sep, boolean printTriangles, boolean printSquares, boolean vertexListOn, boolean edgeListOn, boolean graphMLOn, OutputMode outputControl) {
        this.informationNetworkBasic(cc, sep);
        if (edgeListOn) {
            this.edgeListSimple();
            if (this.tg.isVertexLabelled()) {
                this.edgeListSimple(true);
            }
        }
        if (this.tg.isWeighted() && this.tg.isVertexLabelled()) {
            this.tg.calcStrength();
        }
        boolean printNearestNeighbours = false;
        if (vertexListOn) {
            this.printVertices(cc, sep, null, printTriangles, printSquares, printNearestNeighbours);
        }
        boolean infoOn = true;
        boolean headersOn = true;
        OutputMode om = outputControl == null ? this.tg.outputControl : outputControl;
        if (graphMLOn || om.graphMLFileOn) {
            this.graphML();
        }
        try {
            if (om.degreeDistributionOn) {
                this.tg.calcDegreeDistribution();
                boolean normalise = false;
                this.tg.FileOutputDegreeDistribution(cc, normalise, headersOn);
                double lbratio = 1.1;
                if (this.tg.getNumberVertices() > 100) {
                    this.tg.FileOutputLogBinnedDegreeDistribution(cc, lbratio, infoOn, headersOn);
                }
            }
        }
        catch (RuntimeException e) {
            System.err.println("*** Error in informationGeneral calculating degree distribution: " + e);
        }
        try {
            if (om.distancesOn) {
                this.tg.calcDistanceSample(0.01, 10, 100);
                this.tg.FileOutputDistanceStatistics(cc);
                this.tg.FileOutputDistanceTotalDistribution(cc);
            }
        }
        catch (RuntimeException e) {
            System.err.println("*** Error in informationGeneral calculating distances: " + e);
        }
        try {
            if (om.componentsOn) {
                this.tg.calcComponents();
                this.tg.FileOutputComponentInfo(cc);
                this.tg.FileOutputComponentDistribution(cc);
                this.tg.FileOutputVertexToComponentList(cc);
            }
        }
        catch (RuntimeException e) {
            System.err.println("*** Error in informationGeneral calculating components: " + e);
        }
        try {
            if (om.rankingOn) {
                this.tg.calcRanking();
            }
        }
        catch (RuntimeException e) {
            System.err.println("*** Error in informationGeneral calculating ranking: " + e);
        }
        try {
            if (om.pajekFileOn) {
                this.pajek();
            }
        }
        catch (RuntimeException e) {
            System.err.println("*** Error in informationGeneral calculating pajek output: " + e);
        }
        try {
            if (om.adjacencyFileOn) {
                this.adjacencyMatrix("\t ", true, true);
            }
        }
        catch (RuntimeException e) {
            System.err.println("*** Error in informationGeneral calculating adjacency matrix output: " + e);
        }
        try {
            if (om.clusteringOn) {
                this.tg.calcCCEdgeSample(0.01, 100, 10000);
                this.tg.FileOutputCC(cc);
            }
        }
        catch (RuntimeException e) {
            System.err.println("*** Error in informationGeneral calculating clustering: " + e);
        }
    }
}

