/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import JavaNotes.TextReader;
import JavaNotes.TextReaderTabSeparated;
import TimGraph.Coordinate;
import TimGraph.EdgeValue;
import TimGraph.VertexLabel;
import TimGraph.io.FileOutput;
import TimGraph.io.InputGML;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FileInput {
    private String SEP = "\t";
    static final int UNSET = -975573;
    TextReader data;
    private int infoLevel = 0;
    public static int nmax = 1000;

    public FileInput(int infoLevel) {
        this.infoLevel = infoLevel;
    }

    public FileInput(timgraph tginput) {
        this.infoLevel = tginput.infoLevel;
    }

    public static TextReader openFile(String fullfilename) {
        TextReader newTR;
        System.out.println("Starting to read from " + fullfilename);
        try {
            newTR = new TextReader((Reader)new FileReader(fullfilename));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("*** Can't find file " + fullfilename + ", " + e.getMessage());
        }
        return newTR;
    }

    public static TextReaderTabSeparated openTabSeparatedFile(String fullfilename) {
        TextReaderTabSeparated newTR;
        System.out.println("Starting to read from " + fullfilename);
        try {
            newTR = new TextReaderTabSeparated((Reader)new FileReader(fullfilename));
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Can't find file " + fullfilename);
            return null;
        }
        return newTR;
    }

    public static ArrayList<String> readStringList(String fullFileName) {
        TextReader tr = FileInput.openFile(fullFileName);
        if (tr == null) {
            return null;
        }
        System.out.println("Starting to read list of strings from " + fullFileName);
        ArrayList<String> words = new ArrayList<String>();
        try {
            while (!tr.eof()) {
                words.add(tr.getWord());
            }
            System.out.println("Finished reading list of strings from file " + fullFileName + " found " + words.size() + " words");
        }
        catch (TextReader.Error e) {
            throw new RuntimeException("*** Input Error: readStringList failed after " + words.size() + " words, " + e.getMessage());
        }
        finally {
            tr.close();
        }
        return words;
    }

    public int processAdjacencyMatrixOld(timgraph tg) {
        FileReader inputReader;
        int res = 0;
        String fullFileName = tg.inputName.getFullFileName();
        try {
            inputReader = new FileReader(fullFileName);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("*** Can't find file " + fullFileName + ", " + ex);
        }
        Scanner inputScanner = new Scanner(inputReader);
        System.out.println("Starting to read " + (tg.isWeighted() ? "" : "un") + "weighted adjacency matrix file from " + fullFileName);
        double[][] matrix = new double[1][1];
        int linenumber = 0;
        ArrayList<String> numbers = new ArrayList<String>();
        int dimension = -1;
        int row = 0;
        try {
            while (inputScanner.hasNextLine()) {
                ++linenumber;
                String lineString = inputScanner.nextLine();
                int start = 0;
                int end = 0;
                numbers.clear();
                while (end < lineString.length()) {
                    end = lineString.indexOf(9, start);
                    if (end < 0) {
                        end = lineString.length();
                    }
                    numbers.add(lineString.substring(start, end));
                    start = end + 1;
                }
                if (this.infoLevel > 1) {
                    System.out.print(linenumber);
                    for (String s : numbers) {
                        System.out.print(", " + s);
                    }
                    System.out.println();
                }
                try {
                    if (dimension < 0) {
                        dimension = numbers.size();
                        matrix = new double[dimension][dimension];
                    } else if (numbers.size() != dimension) {
                        throw new RuntimeException(" found " + numbers.size() + " columns, wanted dimension " + dimension);
                    }
                    if (row == dimension) {
                        System.out.println("!!!Warning, found one row too many, wanted only " + dimension + ", ignoring remaining lines");
                        break;
                    }
                    for (int c = 0; c < dimension; ++c) {
                        matrix[row][c] = Double.parseDouble((String)numbers.get(c));
                    }
                    ++row;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            System.out.println("Finished adjacency file input from " + fullFileName + " found " + dimension + " rows and columns ");
        }
        catch (Error e) {
            throw new RuntimeException("*** Input Error on line " + linenumber + ", " + e.getMessage());
        }
        finally {
            inputScanner.close();
        }
        tg.setNetworkFromMatrix(matrix);
        return res;
    }

    public int processAdjacencyMatrixTabSeparated(timgraph tg) {
        boolean headerOn = false;
        boolean rowLabelOn = false;
        boolean trimLabelWhiteSpaceOn = true;
        return this.processAdjacencyMatrix(tg, '\t', headerOn, rowLabelOn, trimLabelWhiteSpaceOn);
    }

    public int processAdjacencyMatrixTabSeparated(timgraph tg, boolean headerOn, boolean rowLabelOn, boolean trimLabelWhiteSpaceOn) {
        return this.processAdjacencyMatrix(tg, '\t', headerOn, rowLabelOn, trimLabelWhiteSpaceOn);
    }

    /*
     * Unable to fully structure code
     */
    public int processAdjacencyMatrix(timgraph tg, char wordSeparator, boolean headerOn, boolean rowLabelOn, boolean trimLabelWhiteSpaceOn) {
        res = 0;
        fullFileName = tg.inputName.getFullFileName();
        try {
            inputReader = new FileReader(fullFileName);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("*** Can't find file " + fullFileName + ", " + ex);
        }
        inputScanner = new Scanner(inputReader);
        System.out.println("Starting to read " + (tg.isWeighted() != false ? "" : "un") + "weighted adjacency matrix file from " + fullFileName);
        System.out.println("   word separator character is " + wordSeparator + ", header labels " + StringFilter.onOffString((boolean)headerOn) + ", row labels on " + StringFilter.onOffString((boolean)rowLabelOn) + ", trimming white space from labels " + StringFilter.onOffString((boolean)trimLabelWhiteSpaceOn));
        numbers = new ArrayList<String>();
        vertexLabelSet = new TreeSet<String>();
        dimension = -1;
        linenumber = 0;
        matrix = null;
        row = 0;
        vertexName = null;
        firstColumn = rowLabelOn != false ? 1 : 0;
lbl19:
        // 2 sources

        try {
            while (inputScanner.hasNextLine()) {
                ++linenumber;
                lineString = inputScanner.nextLine();
                start = 0;
                end = 0;
                numbers.clear();
                while (end < lineString.length()) {
                    end = lineString.indexOf(9, start);
                    if (end < 0) {
                        end = lineString.length();
                    }
                    numbers.add(lineString.substring(start, end));
                    start = end + 1;
                }
                if (this.infoLevel > 1) {
                    System.out.print(linenumber);
                    for (w = 0; w < numbers.size(); ++w) {
                        System.out.print(", " + (String)numbers.get(w));
                    }
                    System.out.println();
                }
                try {
                    block35: {
                        block34: {
                            if (dimension >= 0) break block34;
                            dimension = numbers.size() - firstColumn;
                            matrix = new double[dimension][dimension];
                            if (!headerOn) break block35;
                            vertexName = new String[dimension];
                            if (trimLabelWhiteSpaceOn) {
                                for (c = 0; c < dimension; ++c) {
                                    vertexName[c] = ((String)numbers.get(c + firstColumn)).trim();
                                }
                            }
                            for (c = 0; c < dimension; ++c) {
                                newLabel = (String)numbers.get(c + firstColumn);
                                if (newLabel.length() < 1) {
                                    newLabel = "v" + c;
                                    System.err.println("!!!Warning, on column " + c + " column label is null, using \"" + newLabel + "\" instead");
                                }
                                vertexName[c] = newLabel;
                            }
                            ** GOTO lbl19
                        }
                        if (numbers.size() != dimension + firstColumn) {
                            throw new RuntimeException(" found " + numbers.size() + " columns, wanted " + (dimension + firstColumn));
                        }
                    }
                    if (row == dimension) {
                        System.err.println("!!!Warning, found one row too many, wanted only " + dimension + ", ignoring remaining lines");
                        break;
                    }
                    if (rowLabelOn) {
                        rowLabel = (String)numbers.get(0);
                        colLabel = headerOn != false ? vertexName[row] : rowLabel;
                        newLabel = rowLabel;
                        if (!rowLabel.equals(colLabel)) {
                            if (rowLabel.length() > colLabel.length()) {
                                if (rowLabel.startsWith(colLabel)) {
                                    System.err.println("!!!Warning, on row " + row + " column label \"" + colLabel + "\" is a substring of the label \"" + rowLabel + "\", using longer row string");
                                } else {
                                    System.err.println("!!!Warning, on row " + row + " column label \"" + colLabel + "\" is not substring of the label \"" + rowLabel + "\", using longer row string");
                                }
                                newLabel = rowLabel;
                            } else {
                                if (colLabel.startsWith(rowLabel)) {
                                    System.err.println("!!!Warning, on row " + row + " row label \"" + rowLabel + "\" is a substring of the label \"" + colLabel + "\", using longer col string");
                                } else {
                                    System.err.println("!!!Warning, on row " + row + " row label \"" + rowLabel + "\" is not a substring of the label \"" + colLabel + "\", using longer col string");
                                }
                                newLabel = rowLabel;
                            }
                        }
                        if (vertexLabelSet.contains(newLabel)) {
                            System.err.println("!!!Warning, on row " + row + " new label \"" + newLabel + "\" is not unique, already used.  Will use for a ditinct vertex.");
                        }
                        vertexName[row] = newLabel;
                        vertexLabelSet.add(newLabel);
                    }
                    for (c = 0; c < dimension; ++c) {
                        s = (String)numbers.get(c + firstColumn);
                        if (s.length() == 0) {
                            matrix[row][c] = 0.0;
                            continue;
                        }
                        try {
                            matrix[row][c] = Double.parseDouble(s);
                            continue;
                        }
                        catch (RuntimeException e) {
                            System.err.println("!!!Warning, entry \"" + s + "\" is not a double at line " + linenumber + ", column " + (c + firstColumn) + ", row " + row + ", treated as zero.");
                            matrix[row][c] = 0.0;
                        }
                    }
                    ++row;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            System.out.println("Finished adjacency file input from " + fullFileName + " found " + dimension + " rows and columns ");
        }
        catch (TextReader.Error e) {
            throw new RuntimeException("*** Input Error: " + e.getMessage());
        }
        finally {
            inputScanner.close();
        }
        tg.setNetworkFromMatrix(vertexName, matrix);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public int processAdjacencyMatrixOld(timgraph tg, String wordSeparator, boolean headerOn, boolean rowLabelOn, boolean trimLabelWhiteSpaceOn) {
        res = 0;
        fullFileName = tg.inputName.getFullFileName();
        try {
            inputReader = new FileReader(fullFileName);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("*** Can't find file " + fullFileName + ", " + ex);
        }
        inputScanner = new Scanner(inputReader);
        System.out.println("Starting to read " + (tg.isWeighted() != false ? "" : "un") + "weighted adjacency matrix file from " + fullFileName);
        System.out.println("  " + wordSeparator.length() + " word separator characters are " + StringFilter.toHex((String)wordSeparator, (String)" ") + ", header labels " + StringFilter.onOffString((boolean)headerOn) + ", row labels on " + StringFilter.onOffString((boolean)rowLabelOn) + ", trimming white space from labels " + StringFilter.onOffString((boolean)trimLabelWhiteSpaceOn));
        dimension = -1;
        linenumber = 0;
        matrix = null;
        row = 0;
        vertexName = null;
        firstColumn = rowLabelOn != false ? 1 : 0;
lbl17:
        // 2 sources

        try {
            while (inputScanner.hasNextLine()) {
                ++linenumber;
                lineString = inputScanner.nextLine();
                words = lineString.split(wordSeparator);
                if (this.infoLevel > -1) {
                    System.out.print(linenumber);
                    for (w = 0; w < words.length; ++w) {
                        System.out.print(", " + words[w]);
                    }
                    System.out.println();
                }
                try {
                    block25: {
                        block24: {
                            if (dimension >= 0) break block24;
                            dimension = words.length - firstColumn;
                            matrix = new double[dimension][dimension];
                            if (!headerOn) break block25;
                            vertexName = new String[dimension];
                            if (trimLabelWhiteSpaceOn) {
                                for (c = 0; c < dimension; ++c) {
                                    vertexName[c] = words[c + firstColumn].trim();
                                }
                            }
                            for (c = 0; c < dimension; ++c) {
                                vertexName[c] = words[c + firstColumn];
                            }
                            ** GOTO lbl17
                        }
                        if (words.length != dimension + firstColumn) {
                            throw new RuntimeException(" found " + words.length + " columns, wanted " + (dimension + firstColumn));
                        }
                    }
                    if (row == dimension) {
                        System.err.println("!!!Warning, found one row too many, wanted only " + dimension + ", ignoring remaining lines");
                        break;
                    }
                    if (!words[0].equals(vertexName[row])) {
                        System.err.println("!!!Warning, row " + row + " label \"" + words[0] + "\" does not match column label \"" + vertexName[row] + "\"");
                        if (vertexName[row].length() > words[0].length()) {
                            System.err.println("!!!         switching to use the longer row label");
                            vertexName[row] = words[0];
                        }
                    }
                    for (c = 0; c < dimension; ++c) {
                        s = words[c + firstColumn];
                        if (s.length() == 0) {
                            matrix[row][c] = 0.0;
                            continue;
                        }
                        try {
                            matrix[row][c] = Double.parseDouble(s);
                            continue;
                        }
                        catch (RuntimeException e) {
                            System.err.println("!!!Warning, entry \"" + s + "\" is not a double at line " + linenumber + ", column " + (c + firstColumn) + ", row " + row + ", treated as zero.");
                            matrix[row][c] = 0.0;
                        }
                    }
                    ++row;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            System.out.println("Finished adjacency file input from " + fullFileName + " found " + dimension + " rows and columns ");
        }
        catch (TextReader.Error e) {
            throw new RuntimeException("*** Input Error: " + e.getMessage());
        }
        finally {
            inputScanner.close();
        }
        tg.setNetworkFromMatrix(vertexName, matrix);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processGMLFile(timgraph tg, String ext, boolean weighted, boolean vertexLabelled) {
        int res = 0;
        String fullFileName = tg.inputName.getFullFileName();
        this.data = FileInput.openFile(fullFileName);
        if (this.data == null) {
            return -1;
        }
        InputGML gml = new InputGML(this.data, weighted);
        System.out.println("Starting to read " + (tg.isWeighted() ? "" : "un") + "weighted gml network file from " + fullFileName);
        try {
            System.out.println(" File: " + fullFileName);
            gml.findGraph();
            System.out.println("Finished GML file input from " + fullFileName + " found " + gml.getNumberVertices() + " vertices, " + gml.getNumberEdges() + " edges");
        }
        catch (TextReader.Error e) {
            System.err.println("*** Input Error: " + e.getMessage());
            res = -2;
        }
        finally {
            this.data.close();
        }
        gml.setTimGraph(tg, weighted, vertexLabelled);
        FileOutput fo = new FileOutput(tg);
        fo.printVertices("", "\t", null, false, false, false);
        return 0;
    }

    public static int processIntEdgeFile(timgraph tg, String ext, int columnSource, int columnTarget, int columnWeight, int columnLabel, boolean directed, boolean vertexLabelled, boolean infoOn) {
        return FileInput.processIntEdgeFile(tg, -987654321, ext, columnSource, columnTarget, columnWeight, columnLabel, directed, vertexLabelled, infoOn);
    }

    public static int processIntEdgeFile(timgraph tg, int numberVertices, String ext, int columnSource, int columnTarget, int columnWeight, int columnLabel, boolean directed, boolean vertexLabelled, boolean infoOn) {
        boolean weightsOn = true;
        if (columnWeight < 0) {
            weightsOn = false;
        }
        boolean labelsOn = true;
        if (columnLabel < 0) {
            labelsOn = false;
        }
        tg.setWeightedEdges(weightsOn | labelsOn);
        tg.setVertexlabels(vertexLabelled);
        tg.setDirectedGraph(directed);
        ArrayList<Integer> edgeLL = new ArrayList<Integer>();
        DoubleArrayList weightLL = new DoubleArrayList();
        IntArrayList labelLL = new IntArrayList();
        TreeSet<Integer> sourceLL = new TreeSet<Integer>();
        int res = FileInput.readIntEdgeFile(tg, ext, columnSource, columnTarget, columnWeight, columnLabel, sourceLL, edgeLL, weightLL, labelLL, infoOn);
        if (res <= 0) {
            throw new RuntimeException("FileInput.processIntEdgeFile returned maximum vertex index as " + res);
        }
        int nv = Math.max(res + 1, numberVertices);
        System.out.println("Largest vertex index was " + res + " creating graph with " + nv + " vertices");
        tg.setMaximumVertices(nv);
        tg.setMaximumStubs(edgeLL.size());
        tg.setNetwork();
        for (int v = 0; v < nv; ++v) {
            tg.addVertex();
        }
        int source = -1;
        int target = -1;
        double weight = -1.0;
        int label = -1;
        for (int e = 0; e < edgeLL.size(); ++e) {
            source = edgeLL.get(e++);
            target = edgeLL.get(e);
            if (tg.isWeighted()) {
                weight = weightsOn ? weightLL.get(e / 2) : 1.0;
                label = labelsOn ? labelLL.get(e / 2) : 0;
                tg.addEdge(source, target, new EdgeValue(label, weight));
                continue;
            }
            tg.addEdge(source, target);
        }
        return nv;
    }

    public static int readIntEdgeFile(timgraph tg, String ext, int columnSource, int columnTarget, int columnWeight, int columnLabel, TreeSet<Integer> sourceLL, ArrayList<Integer> edgeLL, DoubleArrayList weightLL, IntArrayList labelLL, boolean infoOn) {
        boolean weightsOn = true;
        if (columnWeight < 0) {
            weightsOn = false;
        }
        boolean labelsOn = true;
        if (columnLabel < 0) {
            labelsOn = false;
        }
        int maxVertexIndex = -9999999;
        int res = 0;
        tg.inputName.setNameEnd(ext);
        String fullFileName = tg.inputName.getFullFileName();
        TextReader data = FileInput.openFile(fullFileName);
        if (data == null) {
            return -1;
        }
        System.out.println("Starting to read " + (tg.isDirected() ? "" : "un") + "directed " + (tg.isWeighted() ? "" : "un") + "weighted network file using an edge list from " + fullFileName);
        try {
            System.out.println(" File: " + fullFileName);
            int linenumber = 0;
            String[] numbers = new String[nmax];
            Integer source = new Integer(-975573);
            Integer target = new Integer(-975573);
            double weight = -97531.0;
            int label = -86420;
            while (!data.eof()) {
                ++linenumber;
                int column = 0;
                while (!data.eoln()) {
                    numbers[column++] = data.getWord();
                }
                if (infoOn) {
                    System.out.print(linenumber);
                    for (int c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                try {
                    if (columnSource > column) {
                        res = -10;
                        edgeLL.add(-975573);
                        throw new RuntimeException("*** Too few columns on line " + linenumber + " expected edge source in " + columnSource + " found " + column);
                    }
                    source = Integer.parseInt(numbers[columnSource - 1]);
                    edgeLL.add(source);
                    sourceLL.add(source);
                    maxVertexIndex = Math.max(maxVertexIndex, source);
                    if (columnTarget > column) {
                        edgeLL.add(-975573);
                        res = -11;
                        throw new RuntimeException("*** Too few columns on line " + linenumber + " expected edge target in " + columnTarget + " found " + column);
                    }
                    target = Integer.parseInt(numbers[columnTarget - 1]);
                    edgeLL.add(target);
                    sourceLL.add(target);
                    maxVertexIndex = Math.max(maxVertexIndex, target);
                    if (weightsOn) {
                        if (columnWeight <= column) {
                            weight = Double.parseDouble(numbers[columnWeight - 1]);
                            weightLL.add(weight);
                        } else {
                            res = -12;
                            throw new RuntimeException("*** Too few columns on line " + linenumber + " expected weight in" + columnWeight + " found " + column);
                        }
                    }
                    if (!labelsOn) continue;
                    if (columnLabel <= column) {
                        label = Integer.parseInt(numbers[columnLabel - 1]);
                        labelLL.add(label);
                        continue;
                    }
                    res = -13;
                    throw new RuntimeException("*** Too few columns on line " + linenumber + " expected label in " + columnLabel + " found " + column);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            if (res == 0) {
                res = sourceLL.size();
            }
            System.out.println("Finished edge list file input from " + fullFileName + " found " + sourceLL.size() + " vertices, " + edgeLL.size() + " stubs");
        }
        catch (TextReader.Error e) {
            res = -2;
            throw new RuntimeException("*** Input Error: " + e.getMessage());
        }
        finally {
            data.close();
        }
        return maxVertexIndex;
    }

    public int processStringEdgeFile(timgraph tg, String ext, int columnSource, int columnTarget, int columnWeight, int columnLabel, boolean directed, boolean vertexLabelled) {
        boolean weightsOn = true;
        if (columnWeight < 0) {
            weightsOn = false;
        }
        boolean labelsOn = true;
        if (columnLabel < 0) {
            labelsOn = false;
        }
        tg.setWeightedEdges(weightsOn | labelsOn);
        tg.setVertexlabels(vertexLabelled);
        tg.setDirectedGraph(directed);
        ArrayList<String> edgeLL = new ArrayList<String>();
        DoubleArrayList weightLL = new DoubleArrayList();
        IntArrayList labelLL = new IntArrayList();
        TreeSet<String> sourceLL = new TreeSet<String>();
        tg.inputName.setNameEnd(ext);
        String fullFileName = tg.inputName.getFullFileName();
        int res = this.readStringEdgeFile(fullFileName, columnSource, columnTarget, columnWeight, columnLabel, sourceLL, null, edgeLL, weightLL, labelLL);
        if (res < 0) {
            return res;
        }
        tg.setMaximumVertices(sourceLL.size());
        tg.setMaximumStubs(edgeLL.size());
        tg.setNetwork();
        TreeMap<String, Integer> vertexLabelToIndex = new TreeMap<String, Integer>();
        Iterator<String> iter = sourceLL.iterator();
        int v = 0;
        String current = "NOTUSED";
        VertexLabel newLabel = new VertexLabel();
        while (iter.hasNext()) {
            current = iter.next();
            vertexLabelToIndex.put(current, v++);
            if (tg.isVertexLabelled()) {
                newLabel.setName(current);
                tg.addVertex(newLabel);
                continue;
            }
            tg.addVertex();
        }
        int source = -1;
        int target = -1;
        double weight = -1.0;
        int label = -1;
        int maxWarning = 20;
        res = 0;
        for (int e = 0; e < edgeLL.size(); ++e) {
            if ((source = ((Integer)vertexLabelToIndex.get(edgeLL.get(e++))).intValue()) == (target = ((Integer)vertexLabelToIndex.get(edgeLL.get(e))).intValue()) && tg.isSelfLooped()) continue;
            if (tg.isWeighted()) {
                weight = weightsOn ? weightLL.get(e / 2) : 1.0;
                label = labelsOn ? labelLL.get(e / 2) : -98542182;
                if (tg.isMultiEdge() || !tg.edgeExists(source, target)) {
                    tg.addEdge(source, target, new EdgeValue(label, weight));
                    continue;
                }
                if (res > -maxWarning && this.infoLevel > -2) {
                    System.out.println("!!! second edge from " + source + " to " + target + " is ignored");
                }
                if (res == -maxWarning) {
                    System.out.println("!!! Reached maximum number of warnings, " + -res + ", no more given.");
                }
                --res;
                continue;
            }
            if (tg.isMultiEdge() || !tg.edgeExists(source, target)) {
                tg.addEdge(source, target);
                continue;
            }
            if (res > -maxWarning && this.infoLevel > -2) {
                System.out.println("!!! second edge from " + source + " to " + target + " is ignored");
            }
            if (res == -maxWarning) {
                System.out.println("!!! Reached maximum number of warnings, " + -res + ", no more given.");
            }
            --res;
        }
        return res - maxWarning;
    }

    public int readStringEdgeFile(String fullFileName, int columnSource, int columnTarget, int columnWeight, int columnLabel, TreeSet<String> sourceLL, TreeSet<String> targetLL, ArrayList<String> edgeLL, DoubleArrayList weightLL, IntArrayList labelLL) {
        boolean headerOn = false;
        return this.readStringEdgeFile(fullFileName, columnSource, columnTarget, columnWeight, columnLabel, sourceLL, targetLL, edgeLL, weightLL, labelLL, headerOn);
    }

    public int readStringEdgeFile(String fullFileName, int columnSource, int columnTarget, int columnWeight, int columnLabel, TreeSet<String> sourceLL, TreeSet<String> targetLL, ArrayList<String> edgeLL, DoubleArrayList weightLL, IntArrayList labelLL, boolean headerOn) {
        boolean weightsOn = true;
        if (columnWeight < 0) {
            weightsOn = false;
        }
        boolean labelsOn = true;
        if (columnLabel < 0) {
            labelsOn = false;
        }
        boolean targetSetOn = true;
        if (targetLL == null) {
            targetSetOn = false;
        }
        int minVertexLabel = 9999999;
        int maxVertexLabel = -minVertexLabel;
        int res = 0;
        this.data = FileInput.openFile(fullFileName);
        if (this.data == null) {
            return -1;
        }
        System.out.println("Starting to read edge list with string vertex labels from " + fullFileName);
        try {
            System.out.println(" File: " + fullFileName);
            int linenumber = 0;
            String[] numbers = new String[nmax];
            String source = "NOTSET";
            String target = "NOTSET";
            double weight = -97531.0;
            int label = -86420;
            if (headerOn) {
                this.data.getln();
                ++linenumber;
            }
            while (!this.data.eof()) {
                ++linenumber;
                if (this.infoLevel > 2) {
                    System.out.println(linenumber + ": ");
                }
                int column = 0;
                while (!this.data.eoln()) {
                    numbers[column++] = this.data.getWord();
                }
                if (this.infoLevel > 1) {
                    System.out.print(linenumber);
                    for (int c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                try {
                    if (columnSource > column) {
                        res = -10;
                        edgeLL.add("T.F.C. line " + linenumber);
                        throw new RuntimeException("*** Too few columns on line " + linenumber + " expected " + columnSource + " found " + column);
                    }
                    source = numbers[columnSource - 1];
                    edgeLL.add(source);
                    sourceLL.add(source);
                    if (columnTarget > column) {
                        edgeLL.add("T.F.C. line " + linenumber);
                        res = -11;
                        throw new RuntimeException("*** Too few columns on line " + linenumber + " expected " + columnTarget + " found " + column);
                    }
                    target = numbers[columnTarget - 1];
                    edgeLL.add(target);
                    if (targetSetOn) {
                        targetLL.add(target);
                    } else {
                        sourceLL.add(target);
                    }
                    if (weightsOn) {
                        if (columnWeight <= column) {
                            weight = Double.parseDouble(numbers[columnWeight - 1]);
                            weightLL.add(weight);
                        } else {
                            res = -12;
                            throw new RuntimeException("*** Too few columns on line " + linenumber + " expected weight in" + columnWeight + " found " + column);
                        }
                    }
                    if (!labelsOn) continue;
                    if (columnLabel <= column) {
                        label = Integer.parseInt(numbers[columnLabel - 1]);
                        labelLL.add(label);
                        continue;
                    }
                    res = -13;
                    throw new RuntimeException("*** Too few columns on line " + linenumber + " expected label in " + columnLabel + " found " + column);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            if (res == 0) {
                res = sourceLL.size();
            }
            System.out.println("Finished edge list file input from " + fullFileName + " found " + sourceLL.size() + " vertices, " + edgeLL.size() + " stubs");
        }
        catch (TextReader.Error e) {
            res = -2;
            throw new RuntimeException("*** Input Error: " + e.getMessage());
        }
        finally {
            this.data.close();
        }
        return res;
    }

    public ArrayList<String> readStringColumnFromFile(String fullFileName, String cc, int columnRead, boolean forceLowerCase) {
        int res = 0;
        this.data = FileInput.openFile(fullFileName);
        if (this.data == null) {
            throw new RuntimeException("Failed to open " + fullFileName);
        }
        System.out.println("Starting to read edge list with string vertex labels from " + fullFileName);
        ArrayList<String> columnList = new ArrayList<String>();
        boolean testForComments = true;
        if (cc.length() < 1) {
            testForComments = false;
        }
        try {
            int linenumber = 0;
            String[] numbers = new String[nmax];
            while (!this.data.eof()) {
                ++linenumber;
                if (this.infoLevel > 2) {
                    System.out.println(linenumber + ": ");
                }
                int column = 0;
                while (!this.data.eoln()) {
                    numbers[column++] = this.data.getWord();
                }
                if (this.infoLevel > 1) {
                    System.out.print(linenumber);
                    for (int c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                try {
                    if (testForComments && numbers[0].startsWith(cc)) continue;
                    if (columnRead > column) {
                        res = -10;
                        columnList.add("T.F.C. line " + linenumber);
                        throw new RuntimeException("*** Too few columns on line " + linenumber + " expected " + columnList + " found " + column);
                    }
                    String source = numbers[columnRead - 1];
                    if (forceLowerCase) {
                        columnList.add(source.toLowerCase());
                        continue;
                    }
                    columnList.add(source);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            if (res == 0) {
                res = columnList.size();
            }
            System.out.println("Finished reading column +" + columnRead + " from input file " + fullFileName + " found " + linenumber + " lines but took only " + columnList.size() + " entries");
        }
        catch (TextReader.Error e) {
            res = -2;
            throw new RuntimeException("*** Input Error: " + e.getMessage());
        }
        finally {
            this.data.close();
        }
        return columnList;
    }

    public ArrayList<String> readStringColumnsFromFile(String fullFileName, String cc, Set<Integer> vertexColumnList, boolean forceLowerCase) {
        int[] columnList = new int[vertexColumnList.size()];
        int i = 0;
        for (Integer vertexColumn : vertexColumnList) {
            columnList[i++] = vertexColumn;
        }
        return FileInput.readStringColumnsFromFile(fullFileName, cc, columnList, forceLowerCase, false, this.infoLevel > 1);
    }

    public static ArrayList<String> readStringColumnsFromFile(String fullFileName, String cc, int[] columnReadList, boolean forceLowerCase, boolean headerOn, boolean infoOn) {
        int res = 0;
        TextReader datafile = FileInput.openFile(fullFileName);
        if (datafile == null) {
            throw new RuntimeException("Failed to open " + fullFileName);
        }
        System.out.print("Starting to read columns ");
        ArrayList<String> columnList = new ArrayList<String>();
        int column2 = -1;
        int maxColumn = -1;
        for (int i = 0; i < columnReadList.length; ++i) {
            column2 = columnReadList[i];
            if (column2 < 1) {
                throw new RuntimeException("\nFirst column is numbered 1, specified one column as number " + column2);
            }
            maxColumn = Math.max(column2, maxColumn);
            System.out.print(column2 + ", ");
        }
        System.out.println(" of file " + fullFileName);
        boolean testForComments = true;
        if (cc.length() < 1) {
            testForComments = false;
        }
        try {
            int linenumber = 0;
            String[] numbers = new String[nmax];
            while (!datafile.eof()) {
                ++linenumber;
                if (infoOn) {
                    System.out.println(linenumber + ": ");
                }
                int column = 0;
                while (!datafile.eoln()) {
                    numbers[column++] = datafile.getWord();
                }
                if (infoOn) {
                    System.out.print(linenumber);
                    for (int c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                if (headerOn && linenumber == 1) continue;
                try {
                    if (testForComments && numbers[0].startsWith(cc)) continue;
                    if (maxColumn > column) {
                        res = -10;
                        columnList.add("TooFewColumnsOnLine" + linenumber);
                        throw new RuntimeException("*** Too few columns on line " + linenumber + " expected " + columnList + " found " + column);
                    }
                    for (int i = 0; i < columnReadList.length; ++i) {
                        String source = numbers[columnReadList[i] - 1];
                        if (forceLowerCase) {
                            columnList.add(source.toLowerCase());
                            continue;
                        }
                        columnList.add(source);
                    }
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            if (res == 0) {
                res = columnList.size();
            }
            System.out.print("Finished reading columns ");
            for (int i = 0; i < columnReadList.length; ++i) {
                System.out.print(columnReadList[i] + ", ");
            }
            System.out.println(" of file " + fullFileName);
            System.out.println(" Found " + linenumber + " lines but took only " + columnList.size() + " entries");
        }
        catch (TextReader.Error e) {
            res = -2;
            throw new RuntimeException("*** Input Error: " + e.getMessage());
        }
        finally {
            datafile.close();
        }
        return columnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readStringIndexLabelList(String fullfilename, int columnIndex, int columnLabel, ArrayList<String> indexL, ArrayList<String> labelL, boolean headerOn) {
        int res = 0;
        this.data = FileInput.openFile(fullfilename);
        if (this.data == null) {
            return -1;
        }
        System.out.println("Starting to read index and label list as strings from " + fullfilename);
        try {
            System.out.println(" File: " + fullfilename);
            int linenumber = 0;
            String[] numbers = new String[nmax];
            String index = "NOTSET";
            String label = "NOTSET";
            if (headerOn) {
                System.out.println("Header Line = " + this.data.getln());
                ++linenumber;
            }
            while (!this.data.eof()) {
                ++linenumber;
                if (this.infoLevel > 1) {
                    System.out.println(linenumber + ": ");
                }
                int column = 0;
                while (!this.data.eoln()) {
                    numbers[column++] = this.data.getWord();
                }
                if (this.infoLevel > 1) {
                    System.out.print(linenumber);
                    for (int c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                try {
                    if (columnIndex > column) {
                        System.out.println("*** Too few columns on line " + linenumber + " expected " + columnIndex + " found " + column);
                        res = -10;
                        indexL.add("T.F.C. line " + linenumber);
                    } else {
                        index = numbers[columnIndex - 1];
                        indexL.add(index);
                    }
                    if (columnLabel > column) {
                        System.out.println("*** Too few columns on line " + linenumber + " expected " + columnLabel + " found " + column);
                        labelL.add("T.F.C. line " + linenumber);
                        res = -11;
                        continue;
                    }
                    label = numbers[columnLabel - 1];
                    labelL.add(label);
                }
                catch (RuntimeException e) {
                    System.err.println("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                    int n = -100;
                    this.data.close();
                    return n;
                }
            }
            if (res == 0) {
                res = indexL.size();
            }
            System.out.println("Finished index/label list file input from " + fullfilename + " found " + indexL.size() + " indices, " + labelL.size() + " labels");
        }
        catch (TextReader.Error e) {
            System.err.println("*** Input Error: " + e.getMessage());
            res = -2;
        }
        finally {
            this.data.close();
        }
        if (indexL.size() != labelL.size()) {
            System.err.println("*** Two lists have different sizes");
        }
        return res;
    }

    public int readIntIndexLabelList(String fullfilename, int columnIndex, int columnLabel, ArrayList<Integer> indexL, ArrayList<Integer> labelL, boolean headerOn) {
        String commentLine = "";
        return FileInput.readIntIndexLabelList(fullfilename, columnIndex, columnLabel, indexL, labelL, headerOn, commentLine, this.infoLevel);
    }

    public static int readIntIndexLabelList(String fullfilename, int columnIndex, int columnLabel, ArrayList<Integer> indexL, ArrayList<Integer> labelL, String commentLine, int infoLevel) {
        boolean headerOn = false;
        return FileInput.readIntIndexLabelList(fullfilename, columnIndex, columnLabel, indexL, labelL, headerOn, commentLine, infoLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readIntIndexLabelList(String fullfilename, int columnIndex, int columnLabel, ArrayList<Integer> indexL, ArrayList<Integer> labelL, boolean headerOn, String commentLine, int infoLevel) {
        if (columnLabel < 1) {
            throw new RuntimeException("Column number must be between 1 and number of columns in file");
        }
        int res = 0;
        TextReader tr = FileInput.openFile(fullfilename);
        if (tr == null) {
            return -1;
        }
        boolean findIndex = true;
        if (indexL == null) {
            findIndex = false;
        }
        boolean findLabel = true;
        if (labelL == null) {
            findLabel = false;
        }
        boolean commentLineOn = true;
        if (commentLine == null || commentLine.length() == 0) {
            commentLineOn = false;
        }
        System.out.println("Starting to read integer " + (findIndex ? "index" : "") + " " + (findLabel ? "label" : "") + " from " + fullfilename);
        try {
            System.out.println(" File: " + fullfilename);
            int linenumber = 0;
            String[] numbers = new String[nmax];
            Integer index = -975573;
            Integer label = -975573;
            if (headerOn) {
                System.out.println("--- Ignoring first (header) line = " + tr.getln());
                ++linenumber;
            }
            while (!tr.eof()) {
                ++linenumber;
                int column = 0;
                while (!tr.eoln()) {
                    numbers[column++] = tr.getWord();
                }
                if (infoLevel > 1) {
                    System.out.print(linenumber + ":");
                }
                if (infoLevel > 2) {
                    for (int c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                }
                if (infoLevel > 1) {
                    System.out.println();
                }
                try {
                    if (commentLineOn && column > 0 && numbers[0].startsWith(commentLine)) {
                        System.out.println("--- Ignoring comment on line " + linenumber + " is " + numbers[0]);
                        continue;
                    }
                    if (findIndex) {
                        if (columnIndex > column) {
                            System.out.println("*** Too few columns on line " + linenumber + " expected " + columnIndex + " found " + column);
                            res = -10;
                            indexL.add(-975573);
                        } else {
                            index = columnIndex < 1 ? linenumber - 1 : new Integer(numbers[columnIndex - 1]);
                            indexL.add(index);
                        }
                    }
                    if (!findLabel) continue;
                    if (columnLabel > column) {
                        System.out.println("*** Too few columns on line " + linenumber + " expected " + columnLabel + " found " + column);
                        labelL.add(-975573);
                        res = -11;
                        continue;
                    }
                    label = new Integer(numbers[columnLabel - 1]);
                    labelL.add(label);
                }
                catch (RuntimeException e) {
                    System.out.println("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                    int n = -100;
                    tr.close();
                    return n;
                }
            }
            if (res == 0) {
                res = indexL.size();
            }
            System.out.print("Finished index/label list file input from " + fullfilename + " found");
            if (findIndex) {
                System.out.print(" : " + indexL.size() + " indices");
            }
            if (findIndex) {
                System.out.print(" : " + labelL.size() + " labels");
            }
            System.out.println();
        }
        catch (TextReader.Error e) {
            System.out.println("*** Input Error: " + e.getMessage());
            res = -2;
        }
        finally {
            tr.close();
        }
        if (indexL.size() != labelL.size()) {
            System.err.println("*** Two lists have different sizes");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readIntIndexNeighbourList(String fullfilename, ArrayList<Integer> labelToLabel, ArrayList<ArrayList<Integer>> indexToLabel, ArrayList<ArrayList<Integer>> labelToIndex, boolean firstColumnIndex, boolean headerOn, int infoLevel) {
        int res = 0;
        TextReader tr = FileInput.openFile(fullfilename);
        if (tr == null) {
            return -1;
        }
        boolean labelTranslate = labelToLabel != null;
        System.out.println("Starting to read integer " + (firstColumnIndex ? "index" : "") + " label lists from " + fullfilename);
        boolean labelToIndexOn = false;
        if (labelToIndex != null) {
            labelToIndexOn = true;
            System.out.println("Creating label to index list");
        }
        boolean indexToLabelOn = false;
        if (indexToLabel != null) {
            indexToLabelOn = true;
            System.out.println("Creating index to label list");
        }
        try {
            System.out.println(" File: " + fullfilename);
            int linenumber = 0;
            String[] numbers = new String[nmax];
            int index = -1;
            int nextNumber = -975573;
            int column = -975573;
            int label = -975573;
            if (headerOn) {
                System.out.println("Header Line = " + tr.getln());
                ++linenumber;
            }
            while (!tr.eof()) {
                ++linenumber;
                column = 0;
                while (!tr.eoln()) {
                    numbers[column++] = tr.getWord();
                }
                if (column == 0) {
                    System.err.println("Empty line at line number " + linenumber);
                    continue;
                }
                if (infoLevel > 1) {
                    System.out.print(linenumber + ":");
                }
                if (infoLevel > 2) {
                    for (int c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                }
                if (infoLevel > 1) {
                    System.out.println();
                }
                try {
                    nextNumber = 0;
                    index = firstColumnIndex ? Integer.parseInt(numbers[nextNumber++]) : ++index;
                    for (int i = nextNumber; i < column; ++i) {
                        label = Integer.parseInt(numbers[i]);
                        if (labelTranslate) {
                            if (label < 0 || label >= labelToLabel.size()) {
                                System.err.println("*** found label " + label + " but do not have a labelToLabel entry for it");
                            }
                            label = labelToLabel.get(label);
                        }
                        if (indexToLabelOn) {
                            while (index >= indexToLabel.size()) {
                                indexToLabel.add(new ArrayList());
                            }
                            indexToLabel.get(index).add(label);
                        }
                        if (!labelToIndexOn) continue;
                        while (label >= labelToIndex.size()) {
                            labelToIndex.add(new ArrayList());
                        }
                        labelToIndex.get(label).add(index);
                    }
                }
                catch (RuntimeException e) {
                    System.out.println("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                    int n = -100;
                    tr.close();
                    return n;
                }
            }
            if (res == 0) {
                res = labelToIndex.size();
            }
            System.out.println("Finished index/label int neighbour list file input from " + fullfilename + " found " + labelToIndex.size() + " indices on " + linenumber + " lines");
        }
        catch (TextReader.Error e) {
            System.out.println("*** Input Error: " + e.getMessage());
            res = -2;
        }
        finally {
            tr.close();
        }
        return res;
    }

    public int processStringVertexNeighbourFileUnipartite(timgraph tg, String ext, boolean directed, boolean vertexLabelled) {
        tg.setWeightedEdges(false);
        tg.setVertexlabels(vertexLabelled);
        tg.setDirectedGraph(directed);
        ArrayList<String> edgeLL = new ArrayList<String>();
        TreeSet<String> sourceLL = new TreeSet<String>();
        int res = this.readStringVertexNeighbourFileUnipartite(tg, ext, sourceLL, edgeLL);
        if (res < 0) {
            return res;
        }
        tg.setMaximumVertices(sourceLL.size());
        tg.setMaximumStubs(edgeLL.size());
        tg.setNetwork();
        TreeMap<String, Integer> vertexLabelToIndex = new TreeMap<String, Integer>();
        Iterator<String> iter = sourceLL.iterator();
        int v = 0;
        String current = "NOTUSED";
        VertexLabel newLabel = new VertexLabel();
        while (iter.hasNext()) {
            current = iter.next();
            System.out.println(v + " " + current);
            vertexLabelToIndex.put(current, v++);
            if (tg.isVertexLabelled()) {
                newLabel.setName(current);
                tg.addVertex(newLabel);
                continue;
            }
            tg.addVertex();
        }
        int source = -1;
        int target = -1;
        for (int e = 0; e < edgeLL.size(); ++e) {
            source = (Integer)vertexLabelToIndex.get(edgeLL.get(e++));
            target = (Integer)vertexLabelToIndex.get(edgeLL.get(e));
            tg.addEdge(source, target);
        }
        return 0;
    }

    public int processStringVertexNeighbourFile(timgraph tg, String ext, boolean weighted, boolean directed, boolean multiedge, boolean vertexLabelled, boolean bipartite, boolean forceLowerCase, boolean checkBipartite, int sampleFrequency, StringFilter stringFilterSource, StringFilter stringFilterTarget, TreeSet<String> filterL) {
        tg.setWeightedEdges(weighted);
        tg.setVertexlabels(vertexLabelled);
        tg.setDirectedGraph(directed);
        tg.setMultiEdge(multiedge);
        ArrayList<String> edgeLL = new ArrayList<String>();
        TreeSet<String> sourceLL = new TreeSet<String>();
        TreeSet<String> vertex2LL = bipartite ? new TreeSet<String>() : null;
        DoubleArrayList edgeWeightLL = weighted ? new DoubleArrayList() : null;
        tg.inputName.setNameEnd(ext);
        String fullFileName = tg.inputName.getFullFileName();
        int res = FileInput.readStringVertexNeighbourFile(fullFileName, sourceLL, vertex2LL, edgeLL, edgeWeightLL, forceLowerCase, checkBipartite, sampleFrequency, stringFilterSource, stringFilterTarget, filterL, this.infoLevel > 1);
        if (res < 0) {
            return res;
        }
        if (bipartite) {
            tg.setBipartite(sourceLL.size(), vertex2LL.size());
            tg.setMaximumVertices(sourceLL.size() + vertex2LL.size());
        } else {
            tg.setMaximumVertices(sourceLL.size());
        }
        tg.setMaximumStubs(edgeLL.size());
        tg.setNetwork();
        TreeMap<String, Integer> vertexLabelToIndex = new TreeMap<String, Integer>();
        this.addVertices(sourceLL, vertexLabelToIndex, tg);
        if (bipartite) {
            this.addVertices(vertex2LL, vertexLabelToIndex, tg);
        }
        int source = -1;
        int target = -1;
        double dw = 1.0;
        for (int e = 0; e < edgeLL.size(); ++e) {
            source = vertexLabelToIndex.get(edgeLL.get(e++));
            target = vertexLabelToIndex.get(edgeLL.get(e));
            if (weighted) {
                edgeWeightLL.getQuick(e / 2);
            }
            tg.addEdgeWithTests(source, target, dw);
        }
        return 0;
    }

    private void addVertices(Collection<String> sourceLL, TreeMap<String, Integer> vertexLabelToIndex, timgraph tg) {
        Iterator<String> iter = sourceLL.iterator();
        int v = tg.getNumberVertices();
        String current = "NOTUSED";
        VertexLabel newLabel = new VertexLabel();
        while (iter.hasNext()) {
            current = iter.next();
            if (this.infoLevel > 0) {
                System.out.println(v + " " + current);
            }
            if (tg.getMaximumVertices() == tg.getNumberVertices()) {
                System.err.println("*** Imminent failure - reached capacity of " + tg.getNumberVertices() + " vertices, " + current + " vertex is one too many");
            }
            vertexLabelToIndex.put(current, v++);
            if (this.infoLevel > 0) {
                System.out.println(v + " " + current);
            }
            if (tg.isVertexLabelled()) {
                newLabel.setName(current);
                tg.addVertex(newLabel);
                continue;
            }
            tg.addVertex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readStringVertexNeighbourFile(String fullFileName, Set<String> sourceLL, Set<String> vertex2LL, ArrayList<String> edgeLL, DoubleArrayList edgeWeightLL, boolean forceLowerCase, boolean checkBipartite, int sampleFrequency, StringFilter stringFilterSource, StringFilter stringFilterTarget, TreeSet<String> filterL, boolean infoOn) {
        int minVertexLabel = 9999999;
        int maxVertexLabel = -minVertexLabel;
        int res = 0;
        boolean bipartite = true;
        if (vertex2LL == null) {
            bipartite = false;
        }
        boolean readSome = true;
        if (sampleFrequency < 2) {
            readSome = false;
        }
        boolean filterSource = stringFilterSource != null;
        boolean filterTarget = stringFilterTarget != null;
        TextReader tr = FileInput.openFile(fullFileName);
        if (tr == null) {
            return -1;
        }
        System.out.println("Starting to read " + (bipartite ? "bipartite" : "unipartite") + " vertex neighbour list with string vertex labels from " + fullFileName);
        try {
            System.out.println(" File: " + fullFileName);
            int linenumber = 0;
            String[] numbers = new String[nmax];
            String source = "NOTSET";
            String target = "NOTSET";
            while (!tr.eof()) {
                ++linenumber;
                if (infoOn) {
                    System.out.println(linenumber + ": ");
                }
                if (readSome && linenumber % sampleFrequency != 1) {
                    tr.getln();
                    continue;
                }
                int column = 0;
                if (forceLowerCase) {
                    while (!tr.eoln()) {
                        numbers[column++] = tr.getWord().toLowerCase();
                    }
                } else {
                    while (!tr.eoln()) {
                        numbers[column++] = tr.getWord();
                    }
                }
                if (infoOn) {
                    for (int c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                try {
                    if (column < 1) {
                        System.err.println("*** Too few columns on line " + linenumber + " expected at least one, found " + column);
                        res = -10;
                        edgeLL.add("T.F.C. line " + linenumber);
                        continue;
                    }
                    source = numbers[0];
                    if (filterSource && !stringFilterSource.isAcceptable(source)) {
                        if (filterL == null) continue;
                        filterL.add(source);
                        continue;
                    }
                    sourceLL.add(source);
                    double ew = 1.0 / (double)(column - 1);
                    for (int c = 1; c < column; ++c) {
                        target = numbers[c];
                        edgeLL.add(source);
                        edgeLL.add(target);
                        if (filterTarget && !stringFilterTarget.isAcceptable(target)) {
                            if (filterL == null) continue;
                            filterL.add(target);
                            continue;
                        }
                        if (edgeWeightLL != null) {
                            edgeWeightLL.add(ew);
                        }
                        if (bipartite) {
                            vertex2LL.add(target);
                            continue;
                        }
                        sourceLL.add(target);
                    }
                }
                catch (RuntimeException e) {
                    System.err.println("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                    int n = -100;
                    tr.close();
                    return n;
                }
            }
            if (res == 0) {
                res = sourceLL.size();
            }
            System.out.println("Finished vertex neighbour list file input from " + fullFileName + " found " + sourceLL.size() + " vertices, " + edgeLL.size() + " stubs");
        }
        catch (TextReader.Error e) {
            System.err.println("*** Input Error: " + e.getMessage());
            res = -2;
        }
        finally {
            tr.close();
        }
        if (bipartite && checkBipartite) {
            if (FileInput.checkBiPartite(sourceLL, vertex2LL)) {
                System.out.println("--- Bipartite structure OK");
            } else {
                System.err.println("*** Requested bipartite structure not found");
                res = -3;
            }
        }
        return res;
    }

    public TreeSet<String> readStringVerticesFile(String fullFileName) {
        boolean checkBipartite = false;
        int sampleFrequency = 1;
        boolean forceLowerCase = true;
        return this.readStringVerticesFile(fullFileName, forceLowerCase, checkBipartite, sampleFrequency);
    }

    public TreeSet<String> readStringVerticesFile(String fullFileName, boolean forceLowerCase, boolean checkBipartite, int sampleFrequency) {
        System.out.println("Starting to read list with vertices in first column from " + fullFileName);
        TreeSet<String> vertexLL = new TreeSet<String>();
        TreeSet<String> neighboursLL = new TreeSet<String>();
        ArrayList<String> edgeLL = new ArrayList<String>();
        DoubleArrayList edgeWeightLL = new DoubleArrayList();
        StringFilter stringFilterSource = null;
        StringFilter stringFilterTarget = null;
        TreeSet<String> filterL = null;
        FileInput.readStringVertexNeighbourFile(fullFileName, vertexLL, neighboursLL, edgeLL, edgeWeightLL, forceLowerCase, checkBipartite, sampleFrequency, stringFilterSource, stringFilterTarget, filterL, this.infoLevel > 1);
        return vertexLL;
    }

    public static boolean checkBiPartite(Collection<String> sourceLL, Collection<String> vertex2LL) {
        Collection<String> v2;
        Collection<String> v1;
        boolean result = true;
        if (sourceLL.size() > vertex2LL.size()) {
            v1 = sourceLL;
            v2 = vertex2LL;
        } else {
            v2 = sourceLL;
            v1 = vertex2LL;
        }
        for (String s : v2) {
            if (!v1.contains(s)) continue;
            result = false;
            System.out.println("checkBiPartite: both vertex sets contain \"" + s + "\"");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readStringVertexNeighbourFileUnipartite(timgraph tg, String ext, TreeSet<String> sourceLL, ArrayList<String> edgeLL) {
        int minVertexLabel = 9999999;
        int maxVertexLabel = -minVertexLabel;
        tg.inputName.setNameEnd(ext);
        String fullFileName = tg.inputName.getFullFileName();
        this.data = FileInput.openFile(fullFileName);
        if (this.data == null) {
            return -1;
        }
        int res = 0;
        System.out.println("Starting to read vertex neighbour list with string vertex labels from " + fullFileName);
        try {
            System.out.println(" File: " + fullFileName);
            int linenumber = 0;
            String[] numbers = new String[nmax];
            String source = "NOTSET";
            String target = "NOTSET";
            while (!this.data.eof()) {
                int c;
                ++linenumber;
                if (this.infoLevel > 2) {
                    System.out.println(linenumber + ": ");
                }
                int column = 0;
                while (!this.data.eoln()) {
                    numbers[column++] = this.data.getWord();
                }
                if (this.infoLevel > 1) {
                    System.out.print(linenumber);
                    for (c = 0; c < column; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                try {
                    if (column < 1) {
                        System.err.println("*** Too few columns on line " + linenumber + " expected at least one, found " + column);
                        res = -10;
                        edgeLL.add("T.F.C. line " + linenumber);
                        continue;
                    }
                    source = numbers[0];
                    sourceLL.add(source);
                    for (c = 1; c < column; ++c) {
                        target = numbers[c];
                        edgeLL.add(source);
                        edgeLL.add(target);
                        sourceLL.add(target);
                    }
                }
                catch (RuntimeException e) {
                    System.err.println("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                    int n = -100;
                    this.data.close();
                    return n;
                }
            }
            if (res == 0) {
                res = sourceLL.size();
            }
            System.out.println("Finished vertex neighbour list file input from " + fullFileName + " found " + sourceLL.size() + " vertices, " + edgeLL.size() + " stubs");
        }
        catch (TextReader.Error e) {
            System.err.println("*** Input Error: " + e.getMessage());
            res = -2;
        }
        finally {
            this.data.close();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processPajekFile(timgraph tg, String ext, boolean directed, boolean weighted) {
        tg.setVertexlabels(true);
        tg.setDirectedGraph(directed);
        tg.setNetwork();
        tg.inputName.setNameEnd(ext);
        String fullFileName = tg.inputName.getFullFileName();
        System.out.println("Starting to read " + (directed ? "" : "un") + "directed " + (weighted ? "" : "un") + "weighted Pajek Network file from " + fullFileName);
        int res = 0;
        this.data = FileInput.openFile(fullFileName);
        if (this.data == null) {
            return -1;
        }
        int linenumber = 1;
        try {
            System.out.println(" File: " + fullFileName);
            int TNV = -1;
            String s = this.data.getWord();
            if (s.charAt(0) != '*') {
                System.err.println("*** ERROR line " + linenumber + " first word should not be _" + s + "_");
                int n = -1;
                return n;
            }
            TNV = this.data.getlnInt();
            if (TNV < 1) {
                System.err.println("*** ERROR line " + linenumber + "  total number of vertices should not be " + TNV);
                int n = -2;
                return n;
            }
            System.out.println("Vertex Section starts on line " + linenumber + " Total number of vertices given as " + TNV);
            int vn = -1;
            ++linenumber;
            while (linenumber < TNV + 2) {
                if (this.infoLevel > 2) {
                    System.out.println(linenumber + "/" + TNV + ": ");
                }
                if (this.data.eof()) {
                    System.err.println("*** ERROR line " + linenumber + "  end of file encountered before all" + TNV + " vertices read.");
                    int n = -3;
                    return n;
                }
                String label = "[" + linenumber + "]";
                vn = -1;
                s = "";
                double x = 0.0;
                double y = 0.0;
                double z = linenumber;
                int column = 1;
                while (!this.data.eoln()) {
                    switch (column) {
                        case 1: {
                            vn = this.data.getInt();
                            break;
                        }
                        case 2: {
                            String temp = this.data.getWord();
                            label = temp.substring(1, temp.length() - 1);
                            break;
                        }
                        case 3: {
                            x = this.data.getDouble();
                            break;
                        }
                        case 4: {
                            y = this.data.getDouble();
                            break;
                        }
                        case 5: {
                            z = this.data.getDouble();
                            break;
                        }
                        default: {
                            s = this.data.getWord();
                        }
                    }
                    ++column;
                }
                if (vn != linenumber - 1 || vn > TNV + 1) {
                    System.err.println("*** ERROR line " + linenumber + "  vertex number should not be " + vn);
                    column = -4;
                    return column;
                }
                Coordinate position = new Coordinate(x, y, z);
                tg.addVertex(new VertexLabel(label, position));
                ++linenumber;
            }
            s = this.data.getWord();
            if (s.charAt(0) != '*') {
                System.err.println("*** ERROR line " + linenumber + " next word should be start of edge/arc section, not _" + s + "_");
                int label = -5;
                return label;
            }
            boolean tempdirected = false;
            if (s.charAt(1) == 'A') {
                tempdirected = true;
            } else if (s.charAt(1) == 'E') {
                tempdirected = false;
            } else {
                System.err.println("*** ERROR line " + linenumber + "  first word of edge section should not be " + s);
                int position = -6;
                return position;
            }
            if (tempdirected != tg.isDirected()) {
                System.out.println("--- WARNING line " + linenumber + "  file requests " + s + " but graph will set to be opposite");
            }
            int TNE = -1;
            TNE = this.data.getInt();
            if (TNE < 1) {
                System.err.println("*** ERROR line " + linenumber + "  total number of edges should not be " + TNE);
                int temp = -7;
                return temp;
            }
            System.out.println("Starting to read edges on line " + linenumber + " graph Type is " + tg.graphType(this.SEP));
            int en = -1;
            int vs = -1;
            int vt = -1;
            int vw = -1;
            while (!this.data.eof()) {
                ++linenumber;
                if (this.infoLevel > 2) {
                    System.out.println(linenumber + ": ");
                }
                if ((vs = this.data.getInt()) < 1 || vs > tg.getNumberVertices()) {
                    System.err.println("*** ERROR line " + linenumber + "  source vertex number of " + vs + " when total is " + tg.getNumberVertices());
                    int n = -8;
                    return n;
                }
                vt = this.data.getlnInt();
                if (vt < 1 || vt > tg.getNumberVertices()) {
                    System.err.println("*** ERROR line " + linenumber + "  target vertex number of " + vt + " when total is " + tg.getNumberVertices());
                    int n = -9;
                    return n;
                }
                if (weighted) {
                    vw = this.data.getlnInt();
                    if (vt < 1 || vt > tg.getNumberVertices()) {
                        System.err.println("*** ERROR line " + linenumber + "  weight " + vw + " of edge from " + vs + " to " + vt + " when total is " + tg.getNumberVertices());
                        int n = -10;
                        return n;
                    }
                    tg.addEdge(vs - 1, vt - 1, vw);
                    continue;
                }
                this.data.getln();
                tg.addEdge(vs - 1, vt - 1);
            }
            System.out.println("Finished reading pajek file " + fullFileName + "  number of lines was " + linenumber);
        }
        catch (TextReader.Error e) {
            System.err.println("*** Input Error " + fullFileName + " on line " + linenumber + " " + e.getMessage());
            res = -99;
        }
        finally {
            this.data.close();
        }
        tg.calcMinimumVertexLabel();
        tg.calcMaximumVertexLabel();
        if (tg.getMinimumVertexCoordinate().distance2D(tg.getMaximumVertexCoordinate()) < 1.0E-6) {
            double angle = 0.0;
            for (int v = 0; v < tg.getNumberVertices(); ++v) {
                double f = (double)v / (double)tg.getNumberVertices();
                angle = Math.PI * 2 * f;
                tg.setVertexPositionQuick(v, new Coordinate(0.5 + Math.cos(angle) / 2.0, 0.5 + Math.sin(angle) / 2.0, f));
            }
            tg.getMinimumVertexCoordinate().set(0.0, 0.0, 0.0);
            tg.getMaximumVertexCoordinate().set(1.0, 1.0, 1.0);
        }
        return res;
    }
}

