/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import JavaNotes.TextReader;
import TimGraph.io.FileInput;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class EdgeListTransformer {
    public static void main(String[] args) {
        System.out.println("EdgeListTransformer Arguments: fullInputFileName fullOutputFileName columnWeight weightCut");
        String fullInputFileName = args[0];
        String fullOutputFileName = args[1];
        int columnWeight = Integer.parseInt(args[2]);
        double weightCut = Double.parseDouble(args[3]);
        String cc = "";
        String sep = "\t";
        boolean infoOn = true;
        if (infoOn) {
            System.out.println("\n !!! EdgeListTransformer !!! Input file = " + fullInputFileName + ", output file = " + fullOutputFileName);
            System.out.println("Weights in column " + columnWeight + ", minimum weight " + weightCut);
            System.out.println(cc.length() == 0 ? "No comment lines" : "Comment lines start with" + cc);
        }
        EdgeListTransformer.edgeListPercolationFile(fullInputFileName, fullOutputFileName, cc, sep, columnWeight, weightCut, infoOn);
    }

    public static int edgeListPercolationFile(String fullInputFileName, String fullOutputFileName, String cc, String sep, int columnWeight, double weightCut, boolean infoOn) {
        PrintStream PS;
        FileOutputStream fout;
        int res = 0;
        boolean dontTestForCommentLine = false;
        if (cc.length() == 0) {
            dontTestForCommentLine = true;
        }
        if (columnWeight < 1) {
            throw new RuntimeException("*** column with weights must be positive (first column numbered 1), found " + columnWeight);
        }
        TextReader data = FileInput.openFile(fullInputFileName);
        if (data == null) {
            System.err.println("*** edgeListPercolationFile input file " + fullInputFileName + " not opened");
            return -1;
        }
        if (infoOn) {
            System.out.println("Starting to do edge percolation on edge list file " + fullInputFileName);
        }
        try {
            fout = new FileOutputStream(fullOutputFileName);
            PS = new PrintStream(fout);
        }
        catch (FileNotFoundException e) {
            System.err.println("**** edgeListPercolationFile output file " + fullOutputFileName + " not opened, " + e.getMessage());
            return -2;
        }
        try {
            int linenumber = 0;
            int numberWeightsInput = 0;
            int numberWeightsOutput = 0;
            String[] numbers = new String[1000];
            double weight = -97531.0;
            int column = 0;
            while (!data.eof()) {
                ++linenumber;
                column = 0;
                while (!data.eoln()) {
                    numbers[column++] = data.getWord();
                }
                try {
                    if (dontTestForCommentLine || !numbers[0].startsWith(cc)) {
                        if (columnWeight <= column) {
                            ++numberWeightsInput;
                            weight = Double.parseDouble(numbers[columnWeight - 1]);
                            if (weight < weightCut) continue;
                            ++numberWeightsOutput;
                        } else {
                            res = -12;
                            throw new RuntimeException("*** Too few columns on line " + linenumber + " expected weight in" + columnWeight + " found " + column);
                        }
                    }
                    for (int c = 0; c < column; ++c) {
                        PS.print(numbers[c] + (c == column ? "" : sep));
                    }
                    PS.println();
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + " of input file, " + e.getMessage());
                }
            }
            if (infoOn) {
                System.out.println("Finished edge list percolation from " + fullInputFileName + " to " + fullOutputFileName);
                System.out.println("    " + linenumber + " input lines found " + numberWeightsInput + " lines with weight, wrote " + numberWeightsOutput + " lines with weight.");
            }
        }
        catch (TextReader.Error e) {
            res = -3;
            throw new RuntimeException("*** File Error in " + fullInputFileName + " or " + fullOutputFileName + ", " + e.getMessage());
        }
        finally {
            try {
                data.close();
                fout.close();
            }
            catch (IOException e) {
                throw new RuntimeException("*** File Error closing " + fullInputFileName + " or " + fullOutputFileName + ", " + e.getMessage());
            }
        }
        return res;
    }

    public static void processEdgeListTableFile(String fullInputFileName, String fullOutputFileName, String cc, String sep, int columnSource, int columnTarget, int columnWeight, int columnLabel, boolean headerOn, boolean infoOn) {
    }
}

