/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.algorithms;

import TimGraph.EdgeValue;
import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileNameSequence;

public class Projections {
    public static timgraph ontoVertexPartition(String rootName, timgraph oldtg, int[] partition, int numberPartitions, boolean forceUndirected, boolean makeUnweighted) {
        timgraph tg = new timgraph();
        tg.infoLevel = oldtg.infoLevel;
        tg.setVertexEdgeList(true);
        tg.setDirectedGraph(oldtg.isDirected());
        if (forceUndirected) {
            tg.setDirectedGraph(false);
        }
        tg.setWeightedEdges(!makeUnweighted);
        tg.setVertexlabels(false);
        tg.inputName = new FileNameSequence(oldtg.inputName);
        tg.outputName = new FileNameSequence(oldtg.outputName);
        tg.setNameRoot(rootName);
        int maximumVertices = numberPartitions;
        int maximumEdges = 0;
        maximumEdges = tg.isDirected() ? maximumVertices * maximumVertices * 2 : maximumVertices * (maximumVertices + 1);
        tg.setMaximumVertices(maximumVertices);
        tg.setMaximumStubs(maximumEdges);
        tg.setNetwork();
        for (int v = 0; v < numberPartitions; ++v) {
            tg.addVertex();
        }
        int s = -1;
        int t = -1;
        int cs = -1;
        int ct = -1;
        double w = 1.0;
        boolean oldIsWeighted = oldtg.isWeighted();
        for (int e = 0; e < oldtg.getNumberStubs(); ++e) {
            s = oldtg.getVertexFromEdge(e++);
            t = oldtg.getVertexFromEdge(e);
            cs = partition[s];
            ct = partition[t];
            if (tg.isWeighted()) {
                double d = w = oldIsWeighted ? oldtg.getEdgeWeight(e) : 1.0;
                if (!oldtg.isDirected() && cs == ct && s != t) {
                    w += w;
                }
                tg.increaseEdgeWeight(cs, ct, w);
                continue;
            }
            tg.addEdgeUnique(cs, ct);
        }
        return tg;
    }

    public static timgraph makeConsolidated(timgraph intg, boolean forceUndirected, boolean makeLabelled, boolean makeVertexEdgeList) {
        timgraph tg = new timgraph();
        tg.infoLevel = intg.infoLevel;
        tg.setVertexEdgeList(makeVertexEdgeList);
        tg.setDirectedGraph(intg.isDirected());
        if (forceUndirected) {
            tg.setDirectedGraph(false);
        }
        tg.setWeightedEdges(true);
        tg.setVertexlabels(makeLabelled);
        tg.inputName = new FileNameSequence(intg.inputName);
        tg.outputName = new FileNameSequence(intg.outputName);
        tg.setMaximumVertices(intg.getNumberVertices());
        tg.setMaximumStubs(intg.getNumberStubs());
        tg.setNetwork();
        for (int v = 0; v < tg.getMaximumVertices(); ++v) {
            if (tg.isVertexLabelled()) {
                if (intg.isVertexLabelled()) {
                    tg.addVertex(intg.getVertexLabel(v));
                    continue;
                }
                tg.addVertex("v" + v, v);
                continue;
            }
            tg.addVertex();
        }
        int s = -1;
        int t = -1;
        int ns = -1;
        int nt = -1;
        double dw = -1.0;
        for (int e = 0; e < intg.getNumberStubs(); ++e) {
            dw = intg.isWeighted() ? intg.getEdgeWeight(e) : 1.0;
            s = intg.getVertexFromEdge(e++);
            t = intg.getVertexFromEdge(e);
            if (forceUndirected && s > t) {
                tg.increaseEdgeWeight(t, s, dw);
                continue;
            }
            tg.increaseEdgeWeight(s, t, dw);
        }
        return tg;
    }

    public static timgraph makeConsolidated(timgraph intg, double minWeight, boolean forceUndirected, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList) {
        timgraph tg = Projections.makeConsolidated(intg, forceUndirected, makeLabelled, makeVertexEdgeList);
        if (makeWeighted) {
            return tg;
        }
        return tg.makeUnweighted(minWeight, forceUndirected, makeLabelled, makeVertexEdgeList);
    }

    public static timgraph minimumEdgeWeight(timgraph intg, double minWeight, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList) {
        if (!intg.isWeighted()) {
            System.err.println("*** Projections.minimumEdgeWeight requires input graph to be weighted but is wasn't.");
            return null;
        }
        timgraph tg = new timgraph();
        tg.infoLevel = intg.infoLevel;
        tg.setVertexEdgeList(makeVertexEdgeList);
        tg.setDirectedGraph(intg.isDirected());
        tg.setWeightedEdges(makeWeighted);
        tg.setVertexlabels(makeLabelled);
        tg.inputName = new FileNameSequence(intg.inputName);
        tg.outputName = new FileNameSequence(intg.outputName);
        tg.setMaximumVertices(intg.getNumberVertices());
        tg.setMaximumStubs(intg.getNumberStubs());
        tg.setNetwork();
        for (int v = 0; v < tg.getMaximumVertices(); ++v) {
            if (tg.isVertexLabelled()) {
                if (intg.isVertexLabelled()) {
                    tg.addVertex(intg.getVertexLabel(v));
                    continue;
                }
                tg.addVertex("v" + v, v);
                continue;
            }
            tg.addVertex();
        }
        int s = -1;
        int t = -1;
        for (int e = 0; e < intg.getNumberStubs(); ++e) {
            EdgeValue ew = intg.getEdgeWeightAll(e);
            if (ew.getWeight() < minWeight) continue;
            s = intg.getVertexFromEdge(e++);
            t = intg.getVertexFromEdge(e);
            if (makeWeighted) {
                tg.addEdge(s, t, ew);
                continue;
            }
            tg.addEdge(s, t);
        }
        return tg;
    }
}

