/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.algorithms;

import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileNameSequence;
import TimUtilities.TimCounting;
import TimUtilities.TimMemory;
import TimUtilities.TimTiming;

public class LineGraphProjector {
    public static final String[] lgExtensionList = new String[]{"LG", "LGsl", "DWLG", "DWLGsl", "SWLG", "SWLGsl"};
    public static final String[] lgExtensionDescription = new String[]{"Line Graph L(G)=C(G)", "Line Graph with self-loops, Ctilde", "Degree Weighted Line Graph, D(G)", "Degree Weighted Line Graph with self-loops, Dtilde(G)", "Strength Weighted Line Graph, E(G)", "Strength Weighted Line Graph with self-loops, Etilde(G)"};

    public static timgraph makeLineGraph(timgraph tg, int newtype, boolean infoOn) {
        int v;
        if (!tg.isVertexEdgeListOn()) {
            System.err.println("!!! WARNING LineGraphProjector is creating the vertexEdgeList it needs.");
            tg.createVertexGlobalEdgeList();
        }
        double MINNORMALISATION = 1.0E-20;
        int type = 2;
        if (newtype < 0 || newtype >= lgExtensionList.length) {
            throw new RuntimeException("*** LineGraphProjector needs type to be between 0 and " + (lgExtensionList.length - 1) + ", was given " + type);
        }
        type = newtype;
        TimTiming timing = new TimTiming();
        TimMemory memory = new TimMemory();
        System.out.println("--- makeLineGraph Initial Memory: " + memory.StringAllValues());
        timgraph lg = new timgraph();
        lg.infoLevel = tg.infoLevel;
        lg.setVertexEdgeList(true);
        lg.setDirectedGraph(tg.isDirected() || tg.isWeighted());
        lg.setWeightedEdges(tg.isWeighted() || type > 1);
        lg.setVertexlabels(false);
        lg.inputName = new FileNameSequence(tg.inputName);
        lg.outputName = new FileNameSequence(tg.outputName);
        lg.inputName.appendToNameRoot("_" + lgExtensionList[type]);
        lg.outputName.appendToNameRoot("_" + lgExtensionList[type]);
        lg.setInitialGraphExternalAlgorithm();
        int noselfloops = 1;
        boolean includeSelfLoops = false;
        int countfactor = -1;
        if (type == 1 || type == 3 || type == 5) {
            countfactor = 1;
            noselfloops = 0;
            includeSelfLoops = true;
        }
        boolean unitNormalisation = true;
        if (type > 1) {
            unitNormalisation = false;
        }
        boolean strengthNormalisation = false;
        if (type > 3 && tg.isWeighted()) {
            strengthNormalisation = true;
        }
        lg.setMaximumVertices(tg.getNumberStubs() / 2);
        int maximumStubs = 0;
        if (tg.isDirected()) {
            for (v = 0; v < tg.getNumberVertices(); ++v) {
                maximumStubs += tg.getVertexInDegree(v) * tg.getVertexOutDegree(v);
            }
            maximumStubs *= 2;
        } else {
            for (v = 0; v < tg.getNumberVertices(); ++v) {
                int k = tg.getVertexDegree(v);
                maximumStubs += k * (k + countfactor);
            }
            if (lg.isDirected()) {
                maximumStubs += maximumStubs;
            }
        }
        lg.setMaximumStubs(maximumStubs);
        if (infoOn) {
            System.out.println("Predicting " + lg.getMaximumVertices() + " vertices and " + lg.getMaximumStubs() + " stubs in line graph ");
            System.out.println("Line graph will be " + lg.graphTypeString(" "));
        }
        System.out.println("--- makeLineGraph\n    Time: " + timing.elapsedTimeString() + ". Memory: " + memory.StringAllValues());
        lg.setNetwork();
        for (v = 0; v < lg.getMaximumVertices(); ++v) {
            lg.addVertex();
        }
        System.out.println("--- makeLineGraph, vertices added.\n    Time: " + timing.elapsedTimeString() + ". Memory: " + memory.StringAllValues());
        TimCounting counting = new TimCounting(tg.getNumberVertices(), true);
        int e1 = -1;
        int e2 = -1;
        double dnv = tg.getNumberVertices();
        if (tg.isDirected()) {
            int kin = -1;
            int kout = -1;
            double w = 1.0;
            double norm = -1.0;
            for (int v2 = 0; v2 < tg.getNumberVertices(); ++v2) {
                if (infoOn && counting.increment()) {
                    System.out.println(" : " + timing.elapsedTimeString() + ": " + timing.estimateRemainingTimeString((double)v2 / dnv));
                    System.out.println("           : " + memory.StringAllValues());
                }
                if ((kin = tg.getVertexDegree(v2)) < 1 || (kout = tg.getVertexDegree(v2)) < 1) continue;
                if (lg.isWeighted()) {
                    double d = unitNormalisation ? 1.0 : (norm = strengthNormalisation ? tg.getVertexOutStrength(v2) : (double)kout);
                    if (norm < 1.0E-20) continue;
                }
                for (int ei = 0; ei < tg.getVertexInDegree(v2); ++ei) {
                    e1 = tg.getInEdge(v2, ei);
                    for (int eo = 0; eo < tg.getVertexOutDegree(v2); ++eo) {
                        e2 = tg.getEdge(v2, eo);
                        if (lg.isWeighted()) {
                            lg.increaseEdgeWeight(e1 / 2, e2 / 2, tg.getEdgeWeight(e2) / norm);
                            continue;
                        }
                        lg.addEdgeUnique(e1 / 2, e2 / 2);
                    }
                }
            }
            if (infoOn && counting.increment()) {
                System.out.println("\nFinished makeLineGraph.\n    Time: " + timing.elapsedTimeString() + ". Memory: " + memory.StringAllValues());
            }
            return lg;
        }
        if (!tg.isDirected() && !lg.isDirected()) {
            if (tg.isWeighted()) {
                throw new RuntimeException(" Input graph must be unweighted in this case");
            }
            int kv = -1;
            double w = 1.0;
            double norm = 1.0;
            double s = -1.0;
            boolean lgweighted = lg.isWeighted();
            for (int v3 = 0; v3 < tg.getNumberVertices(); ++v3) {
                if (infoOn && counting.increment()) {
                    System.out.println(" : " + timing.elapsedTimeString() + ": " + timing.estimateRemainingTimeString((double)v3 / dnv));
                    System.out.println("           : " + memory.StringAllValues());
                }
                if ((kv = tg.getVertexDegree(v3)) <= noselfloops) continue;
                norm = 1.0;
                if (!unitNormalisation) {
                    double d = s = strengthNormalisation ? tg.getVertexOutStrength(v3) : (double)kv;
                    if (s < 1.0E-20) continue;
                    norm = s;
                }
                for (int ei = 0; ei < tg.getVertexDegree(v3); ++ei) {
                    e1 = tg.getEdge(v3, ei);
                    if (!unitNormalisation && !includeSelfLoops) {
                        norm = s - (strengthNormalisation ? tg.getEdgeWeight(e1) : 1.0);
                    }
                    if (norm < 1.0E-20) continue;
                    for (int eo = ei + noselfloops; eo < tg.getVertexDegree(v3); ++eo) {
                        e2 = tg.getEdge(v3, eo);
                        if (lgweighted) {
                            lg.increaseEdgeWeight(e1 / 2, e2 / 2, tg.getEdgeWeight(e2) / norm);
                            continue;
                        }
                        lg.addEdgeUnique(e1 / 2, e2 / 2);
                    }
                }
            }
            if (infoOn && counting.increment()) {
                System.out.println("\nFinished makeLineGraph.\n    Time: " + timing.elapsedTimeString() + ". Memory: " + memory.StringAllValues());
            }
            return lg;
        }
        if (lg.isDirected() && !tg.isDirected()) {
            if (!lg.isWeighted()) {
                throw new RuntimeException(" LG must be weighted in this case");
            }
            if (!tg.isWeighted()) {
                throw new RuntimeException(" Input graph must be weighted in this case");
            }
            int kv = -1;
            double s = -1.0;
            double norm = -1.0;
            for (int v4 = 0; v4 < tg.getNumberVertices(); ++v4) {
                if (infoOn && counting.increment()) {
                    System.out.println(" : " + timing.elapsedTimeString() + ": " + timing.estimateRemainingTimeString((double)v4 / dnv));
                    System.out.println("           : " + memory.StringAllValues());
                }
                if ((kv = tg.getVertexDegree(v4)) <= noselfloops) continue;
                double d = unitNormalisation ? 1.0 : (s = strengthNormalisation ? tg.getVertexOutStrength(v4) : (double)tg.getVertexOutDegree(v4));
                if (s < 1.0E-20) continue;
                norm = s;
                for (int ei = 0; ei < tg.getVertexDegree(v4); ++ei) {
                    e1 = tg.getEdge(v4, ei);
                    if (!unitNormalisation && !includeSelfLoops) {
                        norm = s - (strengthNormalisation ? tg.getEdgeWeight(e1) : 1.0);
                    }
                    if (norm < 1.0E-20) continue;
                    for (int eo = 0; eo < tg.getVertexDegree(v4); ++eo) {
                        if (ei == eo && !includeSelfLoops) continue;
                        e2 = tg.getEdge(v4, eo);
                        lg.increaseEdgeWeight(e1 / 2, e2 / 2, tg.getEdgeWeight(e2) / norm);
                    }
                }
            }
            if (infoOn && counting.increment()) {
                System.out.println("\nFinished makeLineGraph.\n    Time: " + timing.elapsedTimeString() + ". Memory: " + memory.StringAllValues());
            }
            return lg;
        }
        return null;
    }
}

