/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.algorithms;

import TimGraph.VertexLabel;
import TimGraph.timgraph;
import java.util.TreeMap;

public class BipartiteTransformations {
    public static timgraph project(timgraph tg, boolean ontoTypeOne, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList, boolean noSelfLoops) {
        int v;
        timgraph ng = new timgraph();
        ng.initialiseSomeParameters(tg.inputName.getNameRoot(), tg.inputName.getDirectoryRoot(), tg.infoLevel, tg.outputControl.getNumber());
        ng.setNameRoot(tg.inputName.getNameRoot());
        boolean directed = false;
        ng.setGraphProperties(directed, makeLabelled && tg.isVertexLabelled(), makeWeighted, makeVertexEdgeList);
        int nv = -1;
        int firstVertex = -1;
        int lastVertex = -1;
        int firstProjectedVertex = -1;
        int lastProjectedVertex = -1;
        if (ontoTypeOne) {
            nv = tg.getNumberVerticesType1();
            firstVertex = 0;
            lastVertex = nv;
            firstProjectedVertex = nv;
            lastProjectedVertex = tg.getNumberVertices();
        } else {
            nv = tg.getNumberVerticesType2();
            firstVertex = tg.getNumberVerticesType1();
            lastVertex = tg.getNumberVertices();
            firstProjectedVertex = 0;
            lastProjectedVertex = firstVertex;
        }
        int ns = 0;
        for (v = firstProjectedVertex; v < lastProjectedVertex; ++v) {
            int k = tg.getVertexDegree(v);
            ns += k * (k - 1);
        }
        if (tg.infoLevel > -1) {
            System.out.println("Porjected graph has  " + nv + " vertices and " + ns + " stubs");
        }
        ng.setNetwork(nv, ns);
        for (v = firstVertex; v < lastVertex; ++v) {
            if (ng.isVertexLabelled()) {
                if (tg.isVertexLabelled()) {
                    ng.addVertex(tg.getVertexLabel(v));
                    continue;
                }
                ng.addVertex("v" + v, v);
                continue;
            }
            ng.addVertex();
        }
        int s = -1;
        int t = -1;
        int ve = -1;
        int nsl = noSelfLoops ? 1 : 0;
        double w = 1.0;
        for (int v2 = firstProjectedVertex; v2 < lastProjectedVertex; ++v2) {
            int k = tg.getVertexDegree(v2);
            if (k < 1 + nsl) continue;
            if (makeWeighted) {
                w = 1.0 / (double)(k - nsl);
            }
            for (int e1 = 0; e1 < k; ++e1) {
                s = tg.getNeighbour(v2, e1) - firstVertex;
                for (int e2 = e1 + nsl; e2 < k; ++e2) {
                    t = tg.getNeighbour(v2, e2) - firstVertex;
                    if (makeWeighted) {
                        ng.increaseEdgeWeight(s, t, w);
                        continue;
                    }
                    ng.addEdgeUnique(s, t);
                }
            }
        }
        return ng;
    }

    public static timgraph randomise(timgraph tg, String addToNameRoot) {
        if (!tg.isBipartite()) {
            throw new RuntimeException("Must randomise a bipartite graph");
        }
        if (tg.isDirected()) {
            throw new RuntimeException("Can not randomise a directed bipartite graph yet");
        }
        boolean makeUndirected = false;
        boolean makeUnlabelled = false;
        boolean reverseDirection = false;
        timgraph ng = new timgraph(tg, 0, 0, makeUndirected, makeUnlabelled, reverseDirection);
        ng.addToNameRoot(addToNameRoot);
        int n1 = ng.getNumberVerticesType1();
        int n2 = ng.getNumberVerticesType2();
        int s1 = -1;
        int s2 = -1;
        int e2 = -1;
        int nstubs = ng.getNumberStubs();
        for (int e = 0; e < nstubs; ++e) {
            s1 = ng.getStubType1(e);
            if (s1 < 0) {
                throw new RuntimeException("Can't find type one stub from edge " + e);
            }
            s2 = s1;
            while (s1 == s2) {
                e2 = ng.Rnd.nextInt(nstubs);
                s2 = ng.getStubType1(e2);
            }
            if (s2 < 0) {
                throw new RuntimeException("Can't find type two stub from edge " + e2);
            }
            ng.rewireEdgePair(s1, s2);
        }
        return ng;
    }

    public static timgraph merge(timgraph tg1, timgraph tg2, boolean typeOneIsCommonIn1, boolean typeOneIsCommonIn2, String newNameRoot, String newDirectoryRoot, int infoLevel, int outputControlNumber, boolean makeLabelled, boolean makeVertexEdgeList) {
        int v;
        Integer temp;
        if (!tg1.isBipartite()) {
            throw new RuntimeException("First graph must be bipartite");
        }
        if (!tg2.isBipartite()) {
            throw new RuntimeException("Second graph must be bipartite");
        }
        if (!tg1.isVertexLabelled()) {
            throw new RuntimeException("First graph must have vertex labels");
        }
        if (!tg2.isVertexLabelled()) {
            throw new RuntimeException("Second graph must have vertex labels");
        }
        timgraph ng = new timgraph();
        ng.initialiseSomeParameters(newNameRoot, newDirectoryRoot, infoLevel + 10, outputControlNumber);
        ng.setNameRoot(newNameRoot);
        boolean directed = false;
        ng.setGraphProperties(directed, makeLabelled, true, makeVertexEdgeList);
        int n1 = tg1.getNumberVerticesType1();
        String name1 = tg1.getNameVerticesType1();
        int nCommon1 = tg1.getNumberVerticesType2();
        int commonVertexOffset1 = n1;
        int typeOneVertexOffset = 0;
        if (typeOneIsCommonIn1) {
            nCommon1 = n1;
            n1 = tg1.getNumberVerticesType2();
            name1 = tg1.getNameVerticesType2();
            typeOneVertexOffset = commonVertexOffset1;
            commonVertexOffset1 = 0;
        }
        TreeMap<String, Integer> commonOne = new TreeMap<String, Integer>();
        for (int v2 = 0; v2 < nCommon1; ++v2) {
            int vvv = v2 + commonVertexOffset1;
            VertexLabel vl = tg1.getVertexLabel(vvv);
            commonOne.put(vl.getName(), vvv);
        }
        int n2 = tg2.getNumberVerticesType1();
        String name2 = tg2.getNameVerticesType1();
        int nCommon2 = tg2.getNumberVerticesType2();
        int commonVertexOffset2 = n2;
        int typeTwoVertexOffset = 0;
        if (typeOneIsCommonIn2) {
            nCommon2 = n2;
            n2 = tg2.getNumberVerticesType2();
            name2 = tg2.getNameVerticesType2();
            typeTwoVertexOffset = commonVertexOffset2;
            commonVertexOffset2 = 0;
        }
        TreeMap<String, Integer> commonTwo = new TreeMap<String, Integer>();
        for (int v3 = 0; v3 < nCommon2; ++v3) {
            int vvv = v3 + commonVertexOffset2;
            VertexLabel vl = tg2.getVertexLabel(vvv);
            commonTwo.put(vl.getName(), vvv);
        }
        int vc1 = -1;
        int vc2 = -1;
        int ne = 0;
        for (String c : commonOne.keySet()) {
            temp = (Integer)commonOne.get(c);
            if (temp == null) continue;
            vc1 = temp;
            temp = (Integer)commonTwo.get(c);
            if (temp == null) continue;
            vc2 = temp;
            int k1 = tg1.getVertexDegree(vc1);
            int k2 = tg2.getVertexDegree(vc2);
            if (k1 == 0 || k2 == 0) continue;
            ne += k1 * k2;
        }
        System.out.println("*** Merged graph has " + (n1 + n2) + " vertices and at most " + ne + " edges ");
        ng.setBipartite(n1, n2, name1, name2);
        ng.setNetwork(n1 + n2, ne * 2);
        if (makeLabelled) {
            for (v = 0; v < n1; ++v) {
                ng.addVertex(tg1.getVertexLabel(v + typeOneVertexOffset));
            }
        } else {
            for (v = 0; v < n1; ++v) {
                ng.addVertex();
            }
        }
        if (makeLabelled) {
            for (v = 0; v < n2; ++v) {
                ng.addVertex(tg2.getVertexLabel(v + typeTwoVertexOffset));
            }
        } else {
            for (v = 0; v < n2; ++v) {
                ng.addVertex();
            }
        }
        vc1 = -1;
        vc2 = -1;
        int v1 = -1;
        int v2 = -1;
        double dw = 0.0;
        for (String c : commonOne.keySet()) {
            temp = (Integer)commonOne.get(c);
            if (temp == null) continue;
            vc1 = temp;
            temp = (Integer)commonTwo.get(c);
            if (temp == null) continue;
            vc2 = temp;
            int k1 = tg1.getVertexDegree(vc1);
            int k2 = tg2.getVertexDegree(vc2);
            if (k1 == 0 || k2 == 0) continue;
            dw = 1.0 / (double)(k1 * k2);
            for (int el1 = 0; el1 < k1; ++el1) {
                for (int el2 = 0; el2 < k2; ++el2) {
                    v1 = tg1.getNeighbour(vc1, el1);
                    v2 = tg2.getNeighbour(vc2, el2);
                    ng.increaseEdgeWeight(v1 - typeOneVertexOffset, v2 + n1 - typeTwoVertexOffset, dw);
                }
            }
        }
        return ng;
    }
}

