/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.Coordinate;
import TimGraph.Rank;

public class VertexLabel {
    static final String DEFAULTNAME = "";
    static final String SUNSET = "UNSET";
    static final int IUNSET = -918273645;
    static final double DUNSET = -9.182736E45;
    private String name = "";
    private Integer number;
    private Double strength;
    Coordinate position;
    Rank rank;

    public VertexLabel() {
    }

    public VertexLabel(Integer setNumber) {
        this.setName(setNumber.toString());
        this.setNumber(setNumber);
    }

    public VertexLabel(String setname, Integer setNumber) {
        this.setName(setname);
        this.setNumber(setNumber);
    }

    public VertexLabel(double setstrength, Coordinate setposition) {
        this.setStrength(setstrength);
        this.position = setposition;
    }

    public VertexLabel(String setname, Coordinate setposition) {
        this.setName(setname);
        this.position = setposition;
    }

    public VertexLabel(Integer setNumber, String setname, Coordinate setposition) {
        this.setName(setname);
        this.position = setposition;
    }

    public VertexLabel(String setname, double setstrength, Coordinate setposition) {
        this.setName(setname);
        this.setStrength(setstrength);
        this.position = setposition;
    }

    public VertexLabel(VertexLabel old) {
        if (old.hasNumber()) {
            this.setNumber(old.getNumber());
        }
        if (old.hasName()) {
            this.setName(old.getName());
        }
        if (old.hasStrength()) {
            this.setStrength(old.getStrength());
        }
        if (old.hasPosition()) {
            this.position = new Coordinate(old.position);
        }
        if (old.hasRank()) {
            this.rank = new Rank(old.rank);
        }
    }

    public void setValues(String setname, int setNumber, double setstrength, Coordinate setposition, Rank setrank) {
        this.setName(this.name);
        this.setNumber(this.number);
        this.setStrength(setstrength);
        this.position = new Coordinate(setposition);
        this.rank = new Rank(setrank);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void removeName() {
        this.name = DEFAULTNAME;
    }

    public String getName() {
        if (this.name.equals(SUNSET)) {
            return DEFAULTNAME;
        }
        return this.name;
    }

    public boolean hasName() {
        return this.name.length() >= 1 && !this.name.equals(SUNSET);
    }

    public boolean hasNumber() {
        return this.number != null;
    }

    public void setNumber(int newNumber) {
        this.number = this.number == null ? new Integer(newNumber) : Integer.valueOf(newNumber);
    }

    public void setPosition(Coordinate c) {
        if (this.position == null) {
            this.position = new Coordinate();
        }
        this.position = new Coordinate(c);
    }

    public void setPosition(double x, double y) {
        this.setPosition(new Coordinate(x, y));
    }

    public void setRank(Rank r) {
        if (this.rank == null) {
            this.rank = new Rank();
        }
        this.rank = new Rank(r);
    }

    public int getNumber() {
        if (this.number == null) {
            return -918273645;
        }
        return this.number;
    }

    public boolean hasStrength() {
        return this.strength != null;
    }

    public void setStrength(double newStrength) {
        this.strength = this.strength == null ? new Double(newStrength) : Double.valueOf(newStrength);
    }

    public double getStrength() {
        if (this.strength == null) {
            return -9.182736E45;
        }
        return this.strength;
    }

    public Coordinate getPosition() {
        return this.position;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void addStrength(double newStrength) {
        this.strength = this.strength == null ? new Double(newStrength) : Double.valueOf(this.strength + newStrength);
    }

    public boolean hasRank() {
        return this.rank != null;
    }

    public boolean hasPosition() {
        return this.position != null;
    }

    public void setMinimum(VertexLabel minLabel) {
        if (minLabel == null) {
            minLabel = new VertexLabel(this);
            return;
        }
        if (this.hasName() && this.getName().compareToIgnoreCase(minLabel.getName()) < 0) {
            minLabel.setName(this.getName());
        }
        if (this.hasNumber() && this.getNumber() < minLabel.getNumber()) {
            minLabel.setNumber(this.getNumber());
        }
        if (this.hasStrength() && this.getStrength() < minLabel.getStrength()) {
            minLabel.setStrength(this.getStrength());
        }
        if (this.hasPosition()) {
            if (minLabel.hasPosition()) {
                minLabel.getPosition().setToMinimum(this.getPosition());
            } else {
                minLabel.setPosition(this.getPosition());
            }
        }
        if (this.hasRank()) {
            if (minLabel.hasRank()) {
                minLabel.getRank().setMinimum(this.getRank());
            } else {
                minLabel.setRank(this.getRank());
            }
        }
    }

    public void setMaximum(VertexLabel maxLabel) {
        if (maxLabel == null) {
            maxLabel = new VertexLabel(this);
            return;
        }
        if (this.hasName() && this.getName().compareToIgnoreCase(maxLabel.getName()) > 0) {
            maxLabel.setName(this.getName());
        }
        if (this.hasNumber() && this.getNumber() > maxLabel.getNumber()) {
            maxLabel.setNumber(this.getNumber());
        }
        if (this.hasStrength() && this.getStrength() > maxLabel.getStrength()) {
            maxLabel.setStrength(this.getStrength());
        }
        if (this.hasPosition()) {
            if (maxLabel.hasPosition()) {
                maxLabel.getPosition().setToMaximum(this.getPosition());
            } else {
                maxLabel.setPosition(this.getPosition());
            }
        }
        if (this.hasRank()) {
            if (maxLabel.hasRank()) {
                maxLabel.getRank().setMaximum(this.getRank());
            } else {
                maxLabel.setRank(this.getRank());
            }
        }
    }

    public String pajekString() {
        String s = (this.hasName() ? this.quotedNameString() : DEFAULTNAME) + "  " + (this.hasPosition() ? this.position.toString2D(" ") + " 0" : DEFAULTNAME);
        return s;
    }

    public String pajekString(double minx, double miny, double maxx, double maxy) {
        double scalex = maxx - minx;
        double scaley = maxy - miny;
        String s = DEFAULTNAME;
        s = scalex == 0.0 || scaley == 0.0 ? this.pajekString() : " " + (this.hasName() ? this.quotedNameString() : DEFAULTNAME) + "  " + (this.hasPosition() ? (this.position.x - minx) / scalex + " " + (this.position.y - miny) / scaley + " 0" : DEFAULTNAME);
        return s;
    }

    public String quotedNameString() {
        return "\"" + this.name + "\"";
    }

    public String pajekString(Coordinate min, Coordinate max) {
        return this.pajekString(min.x, min.y, max.x, max.y);
    }

    public String printString(String sep) {
        String s = DEFAULTNAME;
        if (this.hasName()) {
            s = s + this.name + sep;
        }
        if (this.hasNumber()) {
            s = s + this.valueString(this.number) + sep;
        }
        if (this.hasPosition()) {
            s = s + this.position.toString(sep) + sep;
        }
        if (this.hasStrength()) {
            s = s + this.valueString(this.strength) + sep;
        }
        if (this.hasRank()) {
            s = s + this.rank.printString(5, sep) + sep;
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - sep.length());
        }
        return s;
    }

    public String printString(String sep, boolean printName, boolean printNumber, boolean printPosition, boolean printStrength, boolean printRank) {
        String s = DEFAULTNAME;
        if (printName) {
            s = s + this.name + sep;
        }
        if (printNumber) {
            s = s + this.valueString(this.number) + sep;
        }
        if (printPosition) {
            s = s + Coordinate.toString(this.position, sep) + sep;
        }
        if (printStrength) {
            s = s + this.valueString(this.strength) + sep;
        }
        if (printRank) {
            s = s + Rank.toString(this.rank, 5, sep) + sep;
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - sep.length());
        }
        return s;
    }

    public String labelString(String sep) {
        return VertexLabel.labelString(sep, this.hasName(), this.hasNumber(), this.hasPosition(), this.hasStrength(), this.hasRank());
    }

    public static String labelString(String sep, boolean printName, boolean printNumber, boolean printPosition, boolean printStrength, boolean printRank) {
        String s = DEFAULTNAME;
        if (printName) {
            s = s + "name" + sep;
        }
        if (printNumber) {
            s = s + "number" + sep;
        }
        if (printPosition) {
            s = s + Coordinate.labelString(sep) + sep;
        }
        if (printStrength) {
            s = s + "strength" + sep;
        }
        if (printRank) {
            s = s + Rank.labelString(sep) + sep;
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - sep.length());
        }
        return s;
    }

    private String valueString(int i) {
        String s = i == -918273645 ? "Unset" : Integer.toString(i);
        return s;
    }

    private String valueString(double d) {
        String s = d == -9.182736E45 ? "Unset" : Double.toString(d);
        return s;
    }

    private String valueString(Integer i) {
        String s = i == null ? "Unset" : i.toString();
        return s;
    }

    private String valueString(Double d) {
        String s = d == null ? "Unset" : d.toString();
        return s;
    }
}

