/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileNameSequence;

public class Utility {
    public static timgraph makeLineGraph(timgraph oldtg, boolean makeUndirected, boolean makeUnweighted, boolean useSelfLoops, boolean makeUnlabelled, boolean reverseDirection) {
        int v;
        if (!oldtg.isVertexEdgeListOn()) {
            System.err.println("*** timgraph Line Graph constructor needs vertexEdgeList to be on.");
        }
        timgraph tg = new timgraph();
        tg.infoLevel = oldtg.infoLevel;
        tg.setVertexEdgeList(true);
        tg.directedGraph = oldtg.directedGraph;
        if (makeUndirected) {
            tg.directedGraph = false;
        }
        tg.weightedEdges = !makeUnweighted;
        tg.vertexlabels = false;
        tg.inputName = new FileNameSequence(oldtg.inputName);
        tg.outputName = new FileNameSequence(oldtg.outputName);
        int noselfloops = 1;
        if (useSelfLoops) {
            noselfloops = 0;
        }
        tg.setMaximumVertices(oldtg.getNumberStubs() / 2);
        int maximumEdges = 0;
        if (tg.directedGraph) {
            for (v = 0; v < oldtg.getNumberVertices(); ++v) {
                maximumEdges += oldtg.getVertexInDegree(v) * oldtg.getVertexOutDegree(v);
            }
        } else {
            for (v = 0; v < oldtg.getNumberVertices(); ++v) {
                int k = oldtg.getVertexDegree(v);
                maximumEdges += k * (k - noselfloops) / 2;
            }
        }
        tg.setMaximumStubs(maximumEdges * 2);
        tg.setNetwork();
        for (v = 0; v < tg.getMaximumVertices(); ++v) {
            tg.addVertex();
        }
        int e1 = -1;
        int e2 = -1;
        double w = 1.0;
        if (oldtg.isDirected()) {
            int kin = -1;
            int kout = -1;
            for (int v2 = 0; v2 < oldtg.getNumberVertices(); ++v2) {
                kin = oldtg.getVertexDegree(v2);
                if (kin < 1 || (kout = oldtg.getVertexDegree(v2)) < 1) continue;
                if (tg.weightedEdges) {
                    w = 1.0 / Math.sqrt((double)kin * (double)kout);
                }
                for (int ei = 0; ei < oldtg.vertexInEdgeList[v2].size(); ++ei) {
                    e1 = oldtg.vertexInEdgeList[v2].get(ei);
                    for (int eo = 0; eo < oldtg.vertexEdgeList[v2].size(); ++eo) {
                        e2 = oldtg.vertexEdgeList[v2].get(eo);
                        if (tg.weightedEdges) {
                            tg.increaseEdgeWeight(e1 / 2, e2 / 2, w);
                            continue;
                        }
                        tg.addEdgeUnique(e1 / 2, e2 / 2);
                    }
                }
            }
        } else {
            int kv = -1;
            for (int v3 = 0; v3 < oldtg.getNumberVertices(); ++v3) {
                kv = oldtg.getVertexDegree(v3);
                if (kv < 1 + noselfloops) continue;
                if (tg.weightedEdges) {
                    w = 1.0 / (double)(kv - noselfloops);
                }
                for (int ei = 0; ei < oldtg.vertexEdgeList[v3].size(); ++ei) {
                    e1 = oldtg.vertexEdgeList[v3].get(ei);
                    for (int eo = ei + noselfloops; eo < oldtg.vertexEdgeList[v3].size(); ++eo) {
                        e2 = oldtg.vertexEdgeList[v3].get(eo);
                        if (tg.weightedEdges) {
                            tg.increaseEdgeWeight(e1 / 2, e2 / 2, w);
                            continue;
                        }
                        tg.addEdgeUnique(e1 / 2, e2 / 2);
                    }
                }
            }
        }
        return tg;
    }
}

