/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.AdjacencyMatrix;
import TimGraph.timgraph;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

public class TransferMatrix
extends AdjacencyMatrix {
    private void initialiseMatrix() {
        this.matrix = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        this.totalWeight = 0.0;
    }

    @Override
    public void calculateInOutVectors() {
        throw new RuntimeException("Note defined yet for TransferMatrix class");
    }

    @Override
    public void make(double[][] m) {
        throw new RuntimeException("Note defined yet for TransferMatrix class");
    }

    @Override
    public void makeA2mA(double[][] m) {
        throw new RuntimeException("Note defined yet for TransferMatrix class");
    }

    @Override
    public void make(timgraph graph) {
        if (!graph.isVertexEdgeListOn()) {
            throw new RuntimeException("*** " + graph.inputName.getNameRoot() + " needs vertexEdgeList");
        }
        this.inVector = new double[this.dimension];
        this.outVector = new double[this.dimension];
        boolean undirected = !graph.isDirected();
        boolean weighted = graph.isWeighted();
        this.dimension = graph.getNumberVertices();
        int numberEdges = graph.getNumberStubs();
        double w = -1.0;
        this.initialiseMatrix();
        for (int e = 0; e < numberEdges; ++e) {
            int s = graph.getVertexFromEdge(e++);
            w = weighted ? graph.getEdgeWeight(e) : 1.0;
            double str = graph.getVertexOutStrength(s);
            if (str < 1.0E-20) {
                throw new RuntimeException("strength of vertex " + s + " is too small at " + str);
            }
            int t = graph.getVertexFromEdge(e);
            this.increaseEdgeWeight(s, t, w, undirected);
            int n = t;
            this.inVector[n] = this.inVector[n] + w;
            int n2 = s;
            this.outVector[n2] = this.outVector[n2] + w;
        }
    }
}

