/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.timgraph;
import java.io.PrintStream;
import java.util.Random;

public class RandomWalk {
    String SEP = "\t";
    private timgraph graph;
    private int numberVertices;
    private int numberEdges;
    public int randomWalkMode = 1;
    private boolean StartWalkWithVertex;
    private boolean always_new_walk_start;
    private boolean markov_walk;
    private boolean StartWalkWithFixedVertex;
    private boolean binomialDistribution;
    private double averageWalkLength;
    private double walkprob;
    private double maximumWalkLength;
    private int intAverageWalkLength;
    private int startVertex;
    private int stepOnWalk;
    int walkvertex;
    int degree;
    private boolean rankingOn;
    private double diffuseValue;
    private double rankingProbability;
    int numberWalks;
    int totalStepLength;
    int longestWalk;
    private Random Rnd;
    public int infoLevel = -2;

    public RandomWalk(timgraph tg) {
        this.initialise(tg, tg.randomWalkMode, tg.averageWalkLength, tg.maxWalkLength);
    }

    public RandomWalk(timgraph tg, int randomWalkMode, double avWalkLength, double maxWalkLength) {
        this.initialise(tg, randomWalkMode, avWalkLength, maxWalkLength);
    }

    public void initialise(timgraph tg, int randomWalkMode, double avWalkLength, double maxWalkLength) {
        this.graph = tg;
        this.numberVertices = this.graph.getNumberVertices();
        this.numberEdges = this.graph.getNumberStubs();
        this.Rnd = tg.Rnd;
        this.infoLevel = this.graph.infoLevel;
        this.setStartVertex(-1);
        this.StartWalkWithVertex = (randomWalkMode & 1) > 0;
        this.always_new_walk_start = (randomWalkMode & 2) > 0;
        this.markov_walk = (randomWalkMode & 4) > 0;
        this.binomialDistribution = (randomWalkMode & 0x10) > 0;
        this.averageWalkLength = avWalkLength;
        this.walkprob = this.averageWalkLength / (1.0 + this.averageWalkLength);
        maxWalkLength = (int)(this.averageWalkLength + 0.5) * 4;
        this.intAverageWalkLength = (int)(this.averageWalkLength + 0.5);
        this.maximumWalkLength = maxWalkLength;
        this.startVertex = -1;
        this.walkvertex = -1;
        this.degree = -1;
        this.longestWalk = -1;
        this.totalStepLength = 0;
        this.numberWalks = 0;
        this.rankingOn = false;
        this.diffuseValue = -1.0;
        if (this.infoLevel > 2) {
            System.out.println("StartWalkWithVertex, always_new_walk_start, markov_walk, random_connectivity " + this.StartWalkWithVertex + this.SEP + this.markov_walk);
        }
    }

    public void setRankingOn(double rankingProbabilityLengthScale) {
        this.rankingOn = true;
        this.rankingProbability = rankingProbabilityLengthScale / (1.0 + rankingProbabilityLengthScale);
    }

    public int setStartVertex(int newStartVertex) {
        this.startVertex = newStartVertex;
        if (this.startVertex >= this.graph.getNumberVertices()) {
            System.out.println("*** Error startVertex " + this.startVertex + ">=" + this.graph.getNumberVertices() + " TotalNumberVertices");
            return -1;
        }
        this.StartWalkWithFixedVertex = this.startVertex >= 0;
        return this.startVertex;
    }

    public int doOneWalk(int binomialNumber) {
        this.stepOnWalk = -1;
        int e = -1;
        if (this.markov_walk) {
            this.stepOnWalk = this.binomialDistribution ? this.getRandomBinomial(this.averageWalkLength, binomialNumber) : this.getRandomMarkov(this.walkprob, binomialNumber);
            if (this.maximumWalkLength < (double)this.stepOnWalk) {
                this.stepOnWalk = (int)this.maximumWalkLength;
            }
        } else {
            this.stepOnWalk = this.intAverageWalkLength;
        }
        if (this.longestWalk < this.stepOnWalk) {
            this.longestWalk = this.stepOnWalk;
        }
        this.diffuseValue = 1.0;
        if (this.always_new_walk_start || this.walkvertex < 0) {
            if (this.StartWalkWithVertex) {
                this.walkvertex = this.StartWalkWithFixedVertex ? (this.walkvertex = this.startVertex) : this.Rnd.nextInt(this.numberVertices);
            } else {
                e = this.graph.directedGraph ? this.graph.makeEven(this.Rnd.nextInt(this.numberEdges)) : this.Rnd.nextInt(this.numberEdges);
                this.walkvertex = this.graph.getVertexFromEdge(e);
            }
            this.degree = this.graph.vertexList[this.walkvertex].size();
        }
        if (this.rankingOn && this.graph.vertexlabels) {
            this.updateRanking();
        }
        while (this.stepOnWalk > 0 && this.degree > 0) {
            --this.stepOnWalk;
            ++this.totalStepLength;
            this.walkvertex = this.graph.vertexList[this.walkvertex].getQuick(this.Rnd.nextInt(this.degree));
            this.degree = this.graph.vertexList[this.walkvertex].size();
            if (!this.rankingOn || !this.graph.vertexlabels) continue;
            this.updateRanking();
        }
        ++this.numberWalks;
        return this.walkvertex;
    }

    public void updateRanking() {
        this.graph.vertexLabelList[this.walkvertex].rank.updateRanking(this.stepOnWalk, this.diffuseValue);
        this.diffuseValue *= this.rankingProbability;
    }

    public void printrandomWalkMode() {
        this.printRandomWalkMode(System.out, "");
    }

    public int getRandomBinomial(double average, int N) {
        if (N < 1) {
            return (int)(average + 1.0E-6);
        }
        double total = 0.0;
        for (int n = 0; n < N; ++n) {
            total += this.Rnd.nextDouble();
        }
        return (int)(total * average / (double)N);
    }

    public int getRandomMarkov(double prob, int N) {
        if (N < 0) {
            return -N;
        }
        int n = 0;
        for (n = 0; n < N && !(this.Rnd.nextDouble() > prob); ++n) {
        }
        return n;
    }

    public void printRandomWalkMode() {
        this.printRandomWalkMode(System.out, "");
    }

    public void printRandomWalkMode(PrintStream PS, String cc) {
        this.printRandomWalkMode(PS, cc, this.randomWalkMode);
    }

    public void printRandomWalkMode(PrintStream PS, String cc, int rwMode) {
        if ((rwMode & 1) > 0) {
            PS.println(cc + "   Start every walk from random vertex");
        } else {
            PS.println(cc + "   Start every walk from random end of random edge");
        }
        if ((rwMode & 2) > 0) {
            PS.println(cc + "   Jump to new vertex when walk length reached (every new edge)");
        } else {
            PS.println(cc + "   Do not jump to new vertex when walk length reached (unless new event in walk graph creation or no exits in random walk");
        }
        if ((rwMode & 4) > 0) {
            PS.println(cc + "   Walk length variable, average fixed");
        } else {
            PS.println(cc + "   Walk length fixed");
        }
        if ((rwMode & 8) > 0) {
            PS.println(cc + "   No. of edges added to each new vertex variable, average fixed");
        } else {
            PS.println(cc + "   No. of edges added to each new vertex fixed");
        }
        if ((rwMode & 0x10) > 0) {
            PS.println(cc + "   Binomial distributed walk lengths");
        } else {
            PS.println(cc + "   Markovian walk lengths");
        }
    }

    public void printAllModes(PrintStream PS, String cc) {
        for (int m = 1; m < 32; m <<= 1) {
            this.printRandomWalkMode(PS, cc + "(rwm & " + m + "): ", m);
        }
    }
}

