/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import java.io.PrintStream;

public class OutputMode {
    static final int maxNumber = 511;
    private int number;
    String modeString;
    public boolean degreeDistributionOn;
    public boolean distancesOn;
    public boolean clusteringOn;
    public boolean pajekFileOn;
    public boolean componentsOn;
    public boolean rankingOn;
    public boolean unusedOn;
    public boolean graphMLFileOn;
    public boolean adjacencyFileOn;

    public OutputMode(double newNumber) {
        this.set(newNumber);
    }

    public OutputMode(OutputMode old) {
        this.set(old.number);
    }

    public int getNumber() {
        return this.number;
    }

    public void set(double newNumber) {
        this.number = (int)(newNumber + 0.5);
        this.setModeString();
        this.degreeDistributionOn = (this.number & 1) > 0;
        this.distancesOn = (this.number & 2) > 0;
        this.clusteringOn = (this.number & 4) > 0;
        this.pajekFileOn = (this.number & 8) > 0;
        this.componentsOn = (this.number & 0x10) > 0;
        this.rankingOn = (this.number & 0x20) > 0;
        this.unusedOn = (this.number & 0x40) > 0;
        this.graphMLFileOn = (this.number & 0x80) > 0;
        this.adjacencyFileOn = (this.number & 0x100) > 0;
    }

    public void set(String newNumber) {
        this.set(Double.parseDouble(newNumber));
    }

    public void printMode(PrintStream PS, String cc) {
        PS.println("Output control method is " + this.modeString);
        if (this.degreeDistributionOn) {
            PS.println("   Degree distribution calculation ON");
        } else {
            PS.println("   Degree distribution calculation OFF");
        }
        if (this.distancesOn) {
            PS.println("   Distance calculation ON");
        } else {
            PS.println("   Distance calculation OFF");
        }
        if (this.clusteringOn) {
            PS.println("   Clustering calculation ON");
        } else {
            PS.println("   Clustering calculation OFF");
        }
        if (this.pajekFileOn) {
            PS.println("   PAJEK file output  ON");
        } else {
            PS.println("   PAJEK file output  OFF");
        }
        if (this.componentsOn) {
            PS.println("  Component calculations ON");
        } else {
            PS.println("   Component calculations OFF");
        }
        PS.println("   Ranking calculations " + (this.rankingOn ? "ON" : "OFF"));
        PS.println("   Adjacency matrix output " + (this.adjacencyFileOn ? "ON" : "OFF"));
        PS.println("   GraphML output " + (this.graphMLFileOn ? "ON" : "OFF"));
    }

    public void printUsage(PrintStream PS, String cc) {
        PS.println(cc + "(OutputMode &  1)  Degree distribution calculation ON/OFF");
        PS.println(cc + "(OutputMode &  2)  Distance calculation ON/OFF");
        PS.println(cc + "(OutputMode &  4)  Clustering calculation ON/OFF");
        PS.println(cc + "(OutputMode &  8)  PAJEK file output  ON/OFF");
        PS.println(cc + "(OutputMode & 16)  Component calculations ON/OFF");
        PS.println(cc + "(OutputMode & 32)  Ranking calculations ON/OFF");
        PS.println(cc + "(OutputMode & 64)  not used");
        PS.println(cc + "(OutputMode & 128) GraphML output ON/OFF");
        PS.println(cc + "(OutputMode & 256) Adjacency matrix output ON/OFF");
    }

    public String getModeString(String sep) {
        String s = "unknown";
        if (this.degreeDistributionOn) {
            s = s + "DD" + sep;
        }
        if (this.distancesOn) {
            s = s + "dist" + sep;
        }
        if (this.clusteringOn) {
            s = s + "clust" + sep;
        }
        if (this.pajekFileOn) {
            s = s + "pajek" + sep;
        }
        if (this.componentsOn) {
            s = s + "comp" + sep;
        }
        if (this.rankingOn) {
            s = s + "rank" + sep;
        }
        if (this.graphMLFileOn) {
            s = s + "graphML" + sep;
        }
        if (this.adjacencyFileOn) {
            s = s + "adj" + sep;
        }
        return s;
    }

    public String getModeString() {
        if (this.modeString == null) {
            this.setModeString();
        }
        return this.modeString;
    }

    private void setModeString() {
        this.modeString = this.getModeString(" ");
    }
}

