/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import JavaNotes.TextReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;

public class NetworkReader {
    int[][] intMatrix;
    int maximumDimension;
    String filename;

    public NetworkReader() {
        this.maximumDimension = 1010;
        this.filename = "/PRG/networks/timgraph/input/ERn100k4.0r0tgadjmat.dat";
    }

    public NetworkReader(String fName, int maxDim) {
        this.maximumDimension = maxDim;
        this.filename = fName;
    }

    public static void main(String[] args) {
        NetworkReader nr = new NetworkReader();
        int result = nr.readSquareIntegerMatrix();
        if (result < 0) {
            System.out.println("*** ERROR readSquareIntegerMatrix returned " + result);
            return;
        }
        nr.printOutStatistics();
    }

    public void printOutStatistics() {
        int edges = 0;
        double secondMoment = 0.0;
        int vertices = this.intMatrix.length;
        int e = -1;
        for (int i = 0; i < vertices; ++i) {
            for (int j = 0; j < vertices; ++j) {
                e = this.intMatrix[i][j];
                if (e == 0) continue;
                edges += e;
                secondMoment += (double)(e * e);
            }
        }
        System.out.println(" Network in file " + this.filename + " has " + vertices + " vertices, " + edges + " edges");
        double averageDegree = (double)edges / (double)vertices;
        System.out.println("     average degree " + averageDegree + ", second moment " + (secondMoment /= (double)vertices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readSquareIntegerMatrix() {
        TextReader data;
        System.out.println("Starting to read double matrix data from " + this.filename);
        int[] number = new int[this.maximumDimension];
        int line = 1;
        try {
            data = new TextReader((Reader)new FileReader(this.filename));
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't find file " + this.filename);
            return -1;
        }
        try {
            int j;
            int dimension = 0;
            while (!data.eoln()) {
                if (dimension == this.maximumDimension) {
                    System.out.println("*** ERROR more than " + this.maximumDimension + " numbers of first line of file " + this.filename);
                    int e = -2;
                    return e;
                }
                number[dimension++] = data.getInt();
            }
            this.intMatrix = new int[dimension][dimension];
            for (j = 0; j < dimension; ++j) {
                this.intMatrix[0][j] = number[j];
            }
            while (!data.eof()) {
                if (line == dimension) {
                    System.out.println("*** ERROR more than " + dimension + " lines of data in file " + this.filename);
                    j = -3;
                    return j;
                }
                int column = 0;
                while (!data.eoln()) {
                    if (column == dimension) {
                        System.out.println("*** ERROR more than " + dimension + " numbers on line " + (line + 1) + " of file " + this.filename);
                        int n = -4;
                        return n;
                    }
                    this.intMatrix[line][column++] = data.getInt();
                }
                ++line;
            }
            System.out.println("Finished reading from " + this.filename);
        }
        catch (TextReader.Error e) {
            System.out.println("*** Input Error: " + e.getMessage());
            int n = -5;
            return n;
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("*** Too many numbers in data file" + this.filename);
            System.out.println("    Processing has been aborted.");
            int n = -6;
            return n;
        }
        finally {
            data.close();
        }
        return 0;
    }
}

