/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import DistributionAnalysis.DistributionAnalysis;
import TimGraph.timgraph;
import java.io.File;
import java.io.PrintStream;

public class NetworkGenerator {
    final String NGVERSION = "NG070202";
    String SEP = "\t";
    int repeat = 2;
    int type = 0;
    int numberVertices = 100;
    double averageDegree = 2.0;
    timgraph tg;
    String fileName = "NetGenDefault";
    String directoryName = "";
    int outputcontrol = 1;
    int infoLevel = -2;
    DistributionAnalysis ddAnalysis;

    public NetworkGenerator() {
    }

    public NetworkGenerator(int type, int numberVertices, double averageDegree, int outputNumber, String fileName, String directoryName) {
        this.type = type;
        this.numberVertices = numberVertices;
        this.averageDegree = averageDegree;
        this.outputcontrol = outputNumber;
        this.fileName = fileName;
        this.directoryName = directoryName;
    }

    public static void main(String[] args) {
        NetworkGenerator ng = new NetworkGenerator();
        ng.parseParam(args);
        ng.printParameters();
        String filenameRoot = ng.fileName;
        ng.ddAnalysis = new DistributionAnalysis(filenameRoot, ng.directoryName, 1.1);
        ng.ddAnalysis.infolevel = 2;
        for (int r = 0; r < ng.repeat; ++r) {
            if (ng.infoLevel > -2) {
                System.out.println("\n *** NetworkGenerator run " + r);
            }
            ng.fileName = filenameRoot + "r" + r;
            ng.makeNetwork();
        }
        ng.outputAverageDegreeDistribution();
    }

    public void makeNetwork() {
        if (this.infoLevel > -2) {
            System.out.println("*** Making " + this.typeString());
        }
        switch (this.type) {
            case 5: {
                this.make3DTorus();
                break;
            }
            case 4: {
                this.make2DTorus();
                break;
            }
            case 3: {
                this.makeCircle();
                break;
            }
            case 2: {
                this.makeBA();
                break;
            }
            case 1: {
                this.makeRandomExponential();
                break;
            }
            case 0: {
                this.makeER();
                break;
            }
            default: {
                System.out.println(" *** Error - no network of type " + this.type);
            }
        }
        if (this.numberVertices < 30 && this.infoLevel > 0) {
            System.out.println("--- Network ---");
            this.printNetwork();
        }
    }

    public String typeString() {
        String s = "UNKNOWN";
        switch (this.type) {
            case 5: {
                s = "3D Torus ";
                break;
            }
            case 4: {
                s = "2D Torus ";
                break;
            }
            case 3: {
                s = "Circle ";
                break;
            }
            case 2: {
                s = "Scale Free";
                break;
            }
            case 1: {
                s = "Random Exponential ";
                break;
            }
            case 0: {
                s = "Random Erdos-Reyni";
                break;
            }
        }
        return s;
    }

    public void makeER() {
        String[] args = new String[7];
        int n = 0;
        args[n++] = "-e" + this.numberVertices;
        args[n++] = "-m" + this.averageDegree / 2.0;
        args[n++] = "-ve1";
        args[n++] = "-gn1";
        args[n++] = "-lw0";
        args[n++] = "-vw3";
        args[n++] = "-p1.0";
        this.makeNetwork(args);
    }

    public void makeRandomExponential() {
        String[] args = new String[7];
        int n = 0;
        args[n++] = "-e" + this.numberVertices;
        args[n++] = "-m" + this.averageDegree / 2.0;
        args[n++] = "-gn2";
        args[n++] = "-ve0";
        args[n++] = "-lw0";
        args[n++] = "-vw2";
        args[n++] = "-p1.0";
        this.makeNetwork(args);
    }

    public void makeBA() {
        String[] args = new String[7];
        int n = 0;
        args[n++] = "-e" + this.numberVertices;
        args[n++] = "-m" + this.averageDegree / 2.0;
        args[n++] = "-gn2";
        args[n++] = "-ve0";
        args[n++] = "-lw0";
        args[n++] = "-vw3";
        args[n++] = "-p1.0";
        this.makeNetwork(args);
    }

    public void makeCircle() {
        String[] args = new String[6];
        int m = (int)(0.5 + this.averageDegree / 2.0);
        int n = 0;
        args[n++] = "-e" + this.numberVertices;
        args[n++] = "-m" + m;
        args[n++] = "-gn-2";
        args[n++] = "-gv" + this.numberVertices;
        args[n++] = "-gm" + m;
        args[n++] = "-p1.0";
        this.makeNetwork(args);
    }

    public void make2DTorus() {
        String[] args = new String[7];
        int m = (int)(0.5 + this.averageDegree / 2.0);
        int n = 0;
        args[n++] = "-e" + this.numberVertices;
        args[n++] = "-m" + m;
        args[n++] = "-gn-4";
        args[n++] = "-gv" + this.numberVertices;
        args[n++] = "-gx-1";
        args[n++] = "-gm" + m;
        args[n++] = "-p1.0";
        this.makeNetwork(args);
    }

    public void make3DTorus() {
        String[] args = new String[7];
        int m = (int)(0.5 + this.averageDegree / 2.0);
        int n = 0;
        args[n++] = "-e" + this.numberVertices;
        args[n++] = "-m" + m;
        args[n++] = "-gn-6";
        args[n++] = "-gv" + this.numberVertices;
        args[n++] = "-gx-1";
        args[n++] = "-gm" + m;
        args[n++] = "-p1.0";
        this.makeNetwork(args);
    }

    private void makeNetwork(String[] args) {
        this.tg = new timgraph(this.fileName + "tg", this.directoryName, this.infoLevel, this.outputcontrol);
        this.tg.setNumberEvents(this.numberVertices);
        this.tg.parseParam(args);
        if (this.tg.getInitialVertices() > this.numberVertices) {
            this.tg.setInitialVertices(this.numberVertices);
        }
        this.tg.doOneRun(1);
        this.ddAnalysis.addOneDD(this.tg.DDtotal.ddarr, this.fileName + "tg", "#", "dd.dat", "lbdd.dat", true);
    }

    private void outputAverageDegreeDistribution() {
        this.ddAnalysis.FileOutputTotDD(this.fileName + "tot.DD.dat", "");
    }

    public void printNetwork() {
        this.tg.printNetwork(true);
    }

    public int parseParam(String[] ArgList) {
        if (this.infoLevel > -1) {
            for (int j = 0; j < ArgList.length; ++j) {
                System.out.println("NG Argument " + j + " = " + ArgList[j]);
            }
        }
        block11: for (int i = 0; i < ArgList.length; ++i) {
            if (ArgList[i].length() < 3) {
                System.out.println("\n*** NF Argument " + i + " is too short");
                this.printUsage();
                return 3;
            }
            if (ArgList[i].charAt(0) != '-') {
                System.out.println("\n*** NG Argument " + i + " does not start with -, use -? for usage");
                return 4;
            }
            switch (ArgList[i].charAt(1)) {
                case 'f': {
                    if (ArgList[i].charAt(2) == 'n') {
                        this.fileName = ArgList[i].substring(3);
                    }
                    if (ArgList[i].charAt(2) != 'd') continue block11;
                    this.directoryName = ArgList[i].substring(3);
                    continue block11;
                }
                case 'k': {
                    this.averageDegree = Double.parseDouble(ArgList[i].substring(2));
                    continue block11;
                }
                case 'n': {
                    this.numberVertices = Integer.parseInt(ArgList[i].substring(2));
                    continue block11;
                }
                case 'o': {
                    this.outputcontrol = Integer.parseInt(ArgList[i].substring(2));
                    continue block11;
                }
                case 'r': {
                    this.repeat = Integer.parseInt(ArgList[i].substring(2));
                    continue block11;
                }
                case 't': {
                    this.type = Integer.parseInt(ArgList[i].substring(2));
                    continue block11;
                }
                case 'x': {
                    if (ArgList[i].charAt(2) != 'i') continue block11;
                    this.infoLevel = Integer.parseInt(ArgList[i].substring(3));
                    continue block11;
                }
                case '?': {
                    this.printUsage();
                    return 1;
                }
                default: {
                    System.out.println("\n*** NG Argument " + i + " " + ArgList[i] + " not known, usage:");
                    this.printUsage();
                    return 2;
                }
            }
        }
        File dir = new File(this.directoryName);
        if (!dir.isDirectory()) {
            System.out.println("*** Error " + this.directoryName + " is not a directory");
            return 1;
        }
        return 0;
    }

    public void printUsage() {
        NetworkGenerator temp = new NetworkGenerator();
        System.out.println("OPTIONS for NetworkGenerator version NG070202\n");
        System.out.println(" -fn<filenameroot> root of filename, default " + temp.fileName);
        System.out.println(" -fd<dirname>      directory using forward slashes, default " + temp.directoryName);
        System.out.println(" -k<float> average degree, default " + temp.averageDegree);
        System.out.println(" -n<int> number of vertices, default " + temp.numberVertices);
        System.out.println(" -o<int> output modes (see timgraph), default " + temp.outputcontrol);
        System.out.println(" -r<int> number of times to repeat, default " + temp.repeat);
        System.out.println(" -t<int> type of network, default " + temp.type + " = " + temp.typeString());
        System.out.println(" -xi<int> information level, -2 very quiet, 0 normal, >0 debugging, default " + temp.infoLevel + " = " + temp.typeString());
        System.out.println(" -?      this help screen");
        System.out.println("Network Types:-");
        for (int t = 0; t < 6; ++t) {
            temp.type = t;
            System.out.println("       " + t + " = " + temp.typeString());
        }
    }

    void printParameters() {
        this.printParameters(System.out);
    }

    void printParameters(PrintStream PS) {
        PS.println("NetworkGenerator version NG070202");
        PS.println("   Type of Network " + this.SEP + this.type + this.SEP + this.typeString());
        PS.println("Number of Vertices " + this.SEP + this.numberVertices);
        PS.println("    Average Degree " + this.SEP + this.averageDegree);
        PS.println("      Output Modes " + this.SEP + this.outputcontrol);
        PS.println("         File Name " + this.SEP + this.fileName);
        PS.println("    Directory Name " + this.SEP + this.directoryName);
        PS.println("    No. of repeats " + this.SEP + this.repeat);
    }
}

