/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

public class ModelNumber {
    double number;
    int major;
    int minor;
    String majorString;
    String minorString;
    boolean bit0;
    boolean bit1;
    boolean bit2;

    public ModelNumber() {
        this.set(5.2);
    }

    public ModelNumber(double newNumber) {
        this.set(newNumber);
    }

    public ModelNumber(ModelNumber old) {
        this.set(old.number);
    }

    public void set(double newNumber) {
        this.number = newNumber;
        this.major = (int)newNumber;
        this.minor = (int)((newNumber - (double)this.major) * 10.0 + 0.5);
        this.bit0 = (this.minor & 1) > 0;
        this.bit1 = (this.minor & 2) > 0;
        this.bit2 = (this.minor & 4) > 0;
        this.setMajorString();
        this.setMinorString();
    }

    public void set(double j, double n) {
        this.set(j + n / 10.0);
    }

    public void set(String newNumber) {
        this.set(Double.parseDouble(newNumber));
    }

    public void setMajorString() {
        String s = "unknown";
        switch (this.major) {
            case 1: {
                s = "Standard Hamiltonian";
                break;
            }
            case 5: {
                s = "Standard Hamiltonian with power site term and separate land/sea populations";
                break;
            }
            default: {
                s = "*** Major Model number" + this.major + "NOT OPERATIONAL";
            }
        }
        this.majorString = s;
    }

    public void setMinorString() {
        String s = "unknown";
        switch (this.minor & 3) {
            case 0: {
                s = "no site terms in trade term";
                break;
            }
            case 1: {
                s = "Supply Side (source site in trade term)";
                break;
            }
            case 2: {
                s = "Demand Side (target site in trade term)";
                break;
            }
            case 3: {
                s = "Gravity (source and target site in trade term)";
            }
        }
        if (this.major == 3) {
            switch (this.minor & 4) {
                case 0: {
                    s = s + "physical distance used in potential";
                    break;
                }
                case 4: {
                    s = s + "edge potential used in potential";
                }
            }
        }
        this.minorString = s;
    }
}

