/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Coordinate;
import TimGraph.Generators.SimpleERCommunityGraph;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.Random;

public class TriangleGridCommunityGraph
extends SimpleERCommunityGraph {
    static final String nameTGCG = "Triangle Grid Community Graph";
    static final String shortNameTGCG = "TGCG";
    int dimX = -135798642;
    int dimY = -135798642;
    int dimN = -135798642;
    protected int edgeTestType;
    double avTriangleSourceNumber;
    protected int nTrianglesMax;
    protected int nTrianglesCurrent;
    int typeX = 0;
    int typeY = 0;
    int typeN = 0;
    private int[] distN;
    private int[] distX;
    private int[] distY;
    boolean firstSystematic = true;
    boolean systematic = false;

    public TriangleGridCommunityGraph() {
    }

    public TriangleGridCommunityGraph(int nX, int nY, int nC, int tX, int tY, int tN, int etestType, double averageValue, double prob, boolean firstSyst, boolean syst, double scale, String[] args) {
        this.graphName = nameTGCG;
        this.shortGraphName = shortNameTGCG;
        this.tg = new timgraph(args);
        this.tg.setVertexEdgeList(true);
        this.setName();
        this.dimX = nX;
        this.dimY = nY;
        this.dimN = nC;
        this.typeX = tX;
        this.typeY = tY;
        this.typeN = tN;
        this.setRandomDistribution(this.typeN, this.dimN, this.distN);
        this.setRandomDistribution(this.typeX, this.dimX, this.distX);
        this.setRandomDistribution(this.typeY, this.dimY, this.distY);
        this.nVertices = this.dimX * this.dimY * this.dimN;
        this.edgeTestType = etestType;
        switch (this.edgeTestType) {
            case 1: {
                this.nStubsMax = (int)Math.round(averageValue * (double)this.nVertices) + 6;
                this.nTrianglesMax = this.nStubsMax / 6;
                this.avTriangleSourceNumber = this.nTrianglesMax / this.nVertices;
                break;
            }
            default: {
                this.avTriangleSourceNumber = averageValue;
                this.nTrianglesMax = (int)Math.round((double)this.nVertices * this.avTriangleSourceNumber);
                this.nStubsMax = this.nTrianglesMax * 6;
            }
        }
        this.nTrianglesCurrent = 0;
        this.avDegree = this.nStubsMax / this.nVertices;
        this.probability = prob;
        this.nCommunities = this.dimX + this.dimY;
        System.out.println("Maximum vertices, triangles, stubs " + this.nVertices + ", " + this.nTrianglesMax + ", " + this.nStubsMax);
        this.tg.setNetwork(this.nVertices, this.nStubsMax);
        this.rnd = new Random();
        this.create(firstSyst, syst, scale);
    }

    public static void main(String[] args) {
        int ano = 0;
        int dimX = 2;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            dimX = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int dimY = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            dimY = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int dimC = 32;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            dimC = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int edgeTestType = 1;
        int edgeTestTypeChar = 107;
        double averageValue = 16.0;
        if (args.length > ++ano) {
            edgeTestTypeChar = args[ano].charAt(1);
            if (timgraph.isOtherArgument(args[ano])) {
                averageValue = Double.parseDouble(args[ano].substring(2, args[ano].length()));
            }
        }
        switch (edgeTestTypeChar) {
            case 107: {
                edgeTestType = 1;
                System.out.println("Limit on average degree is " + averageValue);
                break;
            }
            default: {
                edgeTestType = 0;
                System.out.println("Limit on average number triangles is " + averageValue);
            }
        }
        double prob = 0.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            prob = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        boolean firstSystematic = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            firstSystematic = StringFilter.trueString((String)args[ano].substring(1, args[ano].length()));
        }
        boolean systematic = false;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            firstSystematic = StringFilter.trueString((String)args[ano].substring(1, args[ano].length()));
        }
        int typeIndex = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            typeIndex = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int tX = typeIndex & true ? 1 : 0;
        int tY = (typeIndex & 2) == 2 ? 1 : 0;
        int tN = (typeIndex & 4) == 4 ? 1 : 0;
        double scale = 200.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            scale = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        String[] arguments = new String[]{"-o255"};
        if (args.length > 0) {
            arguments = args;
        }
        TriangleGridCommunityGraph tgcg = new TriangleGridCommunityGraph(dimX, dimY, dimC, tX, tY, tN, edgeTestType, averageValue, prob, firstSystematic, systematic, scale, arguments);
        System.out.println("--- Created " + tgcg.desciption("\n"));
        tgcg.setName();
        tgcg.information();
    }

    public void create(boolean firstSyst, boolean syst, double scale) {
        this.createVertices(scale);
        this.createTriangles(firstSyst, syst);
    }

    public void createVertices(double scale) {
        double bigScaleFactor = 3.5;
        this.tg.initialiseVertexLabels();
        VertexGridCoordinates t = new VertexGridCoordinates();
        double radius = this.dimN < 2 ? scale : scale * (double)this.dimN / (Math.PI * 2);
        for (int v1 = 0; v1 < this.nVertices; ++v1) {
            t.set(v1);
            Coordinate ccc = t.getCoordinate(radius, 3.5);
            VertexLabel vl = new VertexLabel(v1, t.vectorString(), t.getCoordinate(radius, 3.5));
            vl.setNumber(v1 / this.dimN);
            this.tg.addVertex(vl);
        }
    }

    public void createTriangles(boolean firstSyst, boolean syst) {
        this.firstSystematic = firstSyst;
        this.systematic = syst;
        this.nTrianglesCurrent = 0;
        double p = 1.0 - this.probability;
        double phalf = p / 2.0;
        int v1 = 0;
        int res = 0;
        for (v1 = 0; v1 < this.tg.getNumberVertices(); ++v1) {
            if (this.firstSystematic) {
                this.addTriangleFirstCommunityOnly(v1);
                res = this.addTriangleSecondCommunityOnly(v1);
            } else {
                this.addTriangle(v1, phalf, p);
                res = this.addTriangle(v1, phalf, p);
            }
            if (res < 0) break;
        }
        while (this.moreEdgesNeeded()) {
            if (this.systematic) {
                if (++v1 >= this.tg.getNumberVertices()) {
                    v1 = 0;
                }
            } else {
                v1 = this.rnd.nextInt(this.tg.getNumberVertices());
            }
            this.addTriangle(v1, phalf, p);
        }
    }

    private boolean moreEdgesNeeded() {
        switch (this.edgeTestType) {
            case 1: {
                return this.tg.getMaximumStubs() - this.tg.getNumberStubs() > 8;
            }
        }
        return this.nTrianglesCurrent < this.nTrianglesMax;
    }

    private int addTriangleFirstCommunityOnly(int v1) {
        return this.addTriangle(v1, 2.0, 3.0);
    }

    private int addTriangleSecondCommunityOnly(int v1) {
        return this.addTriangle(v1, -1.0, 3.0);
    }

    private int addTriangle(int v1, double phalf, double p) {
        if (this.edgeTestType == 0 && this.nTrianglesCurrent >= this.nTrianglesMax) {
            System.err.println("*** In addTriangle, current number of triangles is too large, nothing added. current, max= " + this.nTrianglesCurrent + ", " + this.nTrianglesMax);
            return -1;
        }
        if (this.edgeTestType == 1 && this.tg.getMaximumStubs() - this.tg.getNumberStubs() < 6) {
            System.err.println("*** In addTriangle, current number of stubs is within 6 of maximum, nothing added. current, max= " + this.tg.getNumberStubs() + ", " + this.tg.getMaximumStubs());
            return -2;
        }
        VertexGridCoordinates s = new VertexGridCoordinates(v1);
        double r = this.rnd.nextDouble();
        int v2 = v1;
        int v3 = v1;
        if (r < phalf) {
            while (v2 == v1) {
                v2 = this.getIndex(this.rnd.nextInt(this.dimN), this.rnd.nextInt(this.dimX), s.y);
            }
            while (v3 == v1 || v3 == v2) {
                v3 = this.getIndex(this.rnd.nextInt(this.dimN), this.rnd.nextInt(this.dimX), s.y);
            }
        } else if (r < p) {
            while (v2 == v1) {
                v2 = this.getIndex(this.rnd.nextInt(this.dimN), s.x, this.rnd.nextInt(this.dimY));
            }
            while (v3 == v1 || v3 == v2) {
                v3 = this.getIndex(this.rnd.nextInt(this.dimN), s.x, this.rnd.nextInt(this.dimY));
            }
        } else {
            while (v2 == v1) {
                v2 = this.rnd.nextInt(this.tg.getNumberVertices());
            }
            while (v3 == v1 || v3 == v2) {
                v3 = this.rnd.nextInt(this.tg.getNumberVertices());
            }
        }
        this.tg.increaseEdgeWeight(v1, v2, 1.0);
        this.tg.increaseEdgeWeight(v2, v3, 1.0);
        this.tg.increaseEdgeWeight(v3, v1, 1.0);
        System.out.println("T" + this.nTrianglesCurrent + "=(" + v1 + "," + v2 + "," + v3 + ")");
        return ++this.nTrianglesCurrent;
    }

    private int findTarget(VertexGridCoordinates s, double phalf, double p) {
        double r = this.rnd.nextDouble();
        int v = -1;
        v = r < phalf ? this.getIndex(this.rnd.nextInt(this.dimN), this.rnd.nextInt(this.dimX), s.y) : (r < p ? this.getIndex(this.rnd.nextInt(this.dimN), s.x, this.rnd.nextInt(this.dimY)) : this.rnd.nextInt(this.tg.getNumberVertices()));
        return v;
    }

    private void setRandomDistribution(int type, int dim, int[] dist) {
        switch (type) {
            case 1: {
                int d = (dim + 1) * dim / 2;
                dist = new int[d];
                int j = 0;
                for (int n = 0; n < dim; ++n) {
                    for (int i = 0; i < n + 1; ++i) {
                        dist[j++] = n;
                    }
                }
                return;
            }
        }
        dist = new int[dim];
        for (int n = 0; n < dim; ++n) {
            dist[n] = n;
        }
    }

    private int getRandomN() {
        if (this.distN.length > 0) {
            return this.distN[this.rnd.nextInt(this.distN.length)];
        }
        return this.rnd.nextInt(this.dimN);
    }

    private int getRandomX() {
        if (this.distX.length > 0) {
            return this.distX[this.rnd.nextInt(this.distX.length)];
        }
        return this.rnd.nextInt(this.dimX);
    }

    private int getRandomY() {
        if (this.distY.length > 0) {
            return this.distY[this.rnd.nextInt(this.distY.length)];
        }
        return this.rnd.nextInt(this.dimY);
    }

    @Override
    public String desciption(String sep) {
        return this.basicDescription(sep) + ", " + sep + " grid " + this.dimX + " by " + this.dimY + sep + " number vertices per grid point " + this.dimN + sep + " limit average degree " + String.format("%6.3f", this.avDegree) + sep + " actual average degree " + String.format("%6.3f", this.tg.getAverageDegree()) + sep + " number stubs " + this.tg.getNumberStubs() + sep + " average number time vertices are source vertex for triangles " + String.format("%6.3f", this.avTriangleSourceNumber) + sep + " actual value " + this.nTrianglesCurrent / this.tg.getNumberVertices() + sep + " actual number triangles added " + this.nTrianglesCurrent + sep + " actual number of triangles in graph " + this.tg.getNumberTriangles() + sep + " limit on " + (this.edgeTestType == 1 ? "degree" : "triangles");
    }

    @Override
    public String shortName() {
        String mstring = "m";
        mstring = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? mstring + (int)(this.avDegree + 1.0E-6) : mstring + this.avDegree;
        return this.shortGraphName + "n" + this.typeChar(this.typeN) + this.dimN + "x" + this.typeChar(this.typeX) + this.dimX + "y" + this.typeChar(this.typeY) + this.dimY + (this.firstSystematic ? "s" : "r") + (this.systematic ? "s" : "r") + (this.edgeTestType == 0 ? "t" + this.nTrianglesMax : "s" + this.nStubsMax) + "p" + (int)(1000.0 * this.probability);
    }

    private char typeChar(int type) {
        switch (type) {
            case 1: {
                return 'p';
            }
        }
        return 'u';
    }

    @Override
    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }

    int getIndex(int n, int x, int y) {
        return n + this.dimN * (x + this.dimX * y);
    }

    class VertexGridCoordinates {
        public int n = -1;
        public int x = -1;
        public int y = -1;

        VertexGridCoordinates() {
        }

        VertexGridCoordinates(int v) {
            this.set(v);
        }

        void set(int v) {
            this.n = v % TriangleGridCommunityGraph.this.dimN;
            int xy = v / TriangleGridCommunityGraph.this.dimN;
            this.x = xy % TriangleGridCommunityGraph.this.dimX;
            this.y = xy / TriangleGridCommunityGraph.this.dimX;
        }

        Coordinate getCoordinate(double radius, double bigScaleFactor) {
            if (TriangleGridCommunityGraph.this.dimN < 2) {
                return new Coordinate((double)this.x * radius, (double)this.y * radius);
            }
            return new Coordinate((Math.cos((double)this.n * Math.PI * 2.0 / (double)TriangleGridCommunityGraph.this.dimN) + (double)this.x * bigScaleFactor) * radius, (Math.sin((double)this.n * Math.PI * 2.0 / (double)TriangleGridCommunityGraph.this.dimN) + (double)this.y * bigScaleFactor) * radius);
        }

        String vectorString() {
            return "(" + (TriangleGridCommunityGraph.this.dimN > 1 ? this.n + "," : "") + this.x + "," + this.y + ")";
        }
    }
}

