/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Generators.TriangleGridCommunityGraph;
import TimGraph.timgraph;
import java.util.Random;

public class SimpleTriangleGridCommunityGraph
extends TriangleGridCommunityGraph {
    static final String nameSTGCG = "Simple Triangle Grid Community Graph";
    static final String shortNameSTGCG = "STGCG";

    public SimpleTriangleGridCommunityGraph(int nX, int nY, double scale, String[] args) {
        this.graphName = nameSTGCG;
        this.shortGraphName = shortNameSTGCG;
        this.tg = new timgraph(args);
        this.tg.setVertexEdgeList(true);
        this.setName();
        this.dimX = nX;
        this.dimY = nY;
        this.dimN = 1;
        this.typeX = -1;
        this.typeY = -1;
        this.typeN = -1;
        this.nVertices = this.dimX * this.dimY * this.dimN;
        this.avTriangleSourceNumber = 2.0;
        this.nTrianglesMax = (int)Math.round((double)this.nVertices * this.avTriangleSourceNumber);
        this.nTrianglesCurrent = 0;
        this.nStubsMax = this.nTrianglesMax * 6;
        this.avDegree = this.nStubsMax / this.nVertices;
        this.probability = -1.0;
        this.nCommunities = this.dimX + this.dimY;
        System.out.println("nVertices, nTriangles, nStubs " + this.nVertices + ", " + this.nTrianglesMax + ", " + this.nStubsMax);
        this.tg.setNetwork(this.nVertices, this.nStubsMax);
        this.rnd = new Random();
        this.createSimple(scale);
    }

    public static void main(String[] args) {
        int ano = 0;
        int dimX = 6;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            dimX = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int dimY = 6;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            dimY = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        String[] arguments = new String[]{"-o255"};
        if (args.length > 0) {
            arguments = args;
        }
        double scale = 200.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            scale = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        SimpleTriangleGridCommunityGraph tgcg = new SimpleTriangleGridCommunityGraph(dimX, dimY, scale, arguments);
        System.out.println("--- Created " + tgcg.desciption("\n"));
        tgcg.setName();
        tgcg.information();
    }

    public void createSimple(double scale) {
        this.createVertices(scale);
        this.createTrianglesSimply();
    }

    public void createTrianglesSimply() {
        int v3;
        int v2;
        int v1;
        int y1;
        int x1;
        this.nTrianglesCurrent = 0;
        for (x1 = 0; x1 < this.dimX; ++x1) {
            y1 = 0;
            for (int y2 = 2; y2 < this.dimY; ++y2) {
                int y3 = y2 == 2 ? 1 : this.rnd.nextInt(y2 - 1) + 1;
                v1 = this.getIndex(0, x1, y1);
                v2 = this.getIndex(0, x1, y2);
                v3 = this.getIndex(0, x1, y3);
                this.tg.increaseEdgeWeight(v1, v2, 1.0);
                this.tg.increaseEdgeWeight(v2, v3, 1.0);
                this.tg.increaseEdgeWeight(v3, v1, 1.0);
            }
        }
        for (y1 = 0; y1 < this.dimY; ++y1) {
            x1 = 0;
            for (int x2 = 2; x2 < this.dimX; ++x2) {
                int x3 = x2 == 2 ? 1 : this.rnd.nextInt(x2 - 1) + 1;
                v1 = this.getIndex(0, x1, y1);
                v2 = this.getIndex(0, x2, y1);
                v3 = this.getIndex(0, x3, y1);
                this.tg.increaseEdgeWeight(v1, v2, 1.0);
                this.tg.increaseEdgeWeight(v2, v3, 1.0);
                this.tg.increaseEdgeWeight(v3, v1, 1.0);
            }
        }
    }

    @Override
    public String desciption(String sep) {
        return this.basicDescription(sep) + ", " + sep + " grid " + this.dimX + " by " + this.dimY + sep + " average number time vertices are source vertex for triangles " + this.avTriangleSourceNumber;
    }

    @Override
    public String shortName() {
        String mstring = "m";
        mstring = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? mstring + (int)(this.avDegree + 1.0E-6) : mstring + this.avDegree;
        return this.shortGraphName + "x" + this.dimX + "y" + this.dimY;
    }

    @Override
    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }
}

