/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Generators.SimpleERCommunityGraph;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;

public class SimpleTriangleCommunityGraph
extends SimpleERCommunityGraph {
    static final String nameSTCG = "Simple Triangle Community Graph";
    static final String shortNameSTCG = "STCG";
    double avTriangleSourceNumber;
    int nTriangles;

    public SimpleTriangleCommunityGraph(int numberCommunities, int sizeCommunities, double averageTriangleSourceNumber, double prob, String[] args) {
        this.graphName = nameSTCG;
        this.shortGraphName = shortNameSTCG;
        this.tg = new timgraph(args);
        this.tg.setVertexEdgeList(true);
        this.nCommunities = numberCommunities;
        this.nVertices = this.nCommunities * sizeCommunities;
        this.avTriangleSourceNumber = averageTriangleSourceNumber;
        this.nTriangles = (int)Math.round((double)this.nVertices * this.avTriangleSourceNumber);
        this.nStubsMax = this.nTriangles * 6;
        this.avDegree = this.nStubsMax / this.nVertices;
        this.probability = prob;
        System.out.println("nVertices, nTriangles, nStubs " + this.nVertices + ", " + this.nTriangles + ", " + this.nStubsMax);
        this.tg.setNetworkWithVertices(this.nVertices, this.nStubsMax);
    }

    public static void main(String[] args) {
        int ano = 0;
        int numberCommunities = 4;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            numberCommunities = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int sizeCommunities = 32;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            sizeCommunities = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        double averageTriangleSourceNumber = 1.5;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            averageTriangleSourceNumber = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double prob = 0.085786438;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            prob = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        boolean firstSystematic = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            firstSystematic = StringFilter.trueString((String)args[ano].substring(1, args[ano].length()));
        }
        String[] arguments = new String[]{"-o255"};
        if (args.length > 0) {
            arguments = args;
        }
        SimpleTriangleCommunityGraph rg = new SimpleTriangleCommunityGraph(numberCommunities, sizeCommunities, averageTriangleSourceNumber, prob, arguments);
        System.out.println("--- Created " + rg.desciption("\n"));
        rg.initialise();
        rg.setName();
        rg.create(firstSystematic);
        rg.labelVertices();
        rg.information();
    }

    public void create(boolean firstSystematic) {
        int sizeCommunities = this.nVertices / this.nCommunities;
        this.createCommunityStructure(sizeCommunities);
        this.createTriangleCommunities(firstSystematic);
    }

    public void createTriangleCommunities(boolean firstSystematic) {
        int s = -1;
        int t = -1;
        int u = -1;
        int ncs = -1;
        for (int cs = 0; cs < this.nCommunities; ++cs) {
            ncs = this.firstVinC[cs + 1] - this.firstVinC[cs];
            int m = (int)(this.avTriangleSourceNumber * (double)ncs);
            for (int i = 0; i < m; ++i) {
                s = this.firstVinC[cs] + (firstSystematic ? i : this.rnd.nextInt(ncs));
                t = this.findTarget(this.probability, s, cs, ncs);
                u = s;
                while (u == s || u == t) {
                    u = this.findTarget(this.probability, s, cs, ncs);
                }
                this.tg.increaseEdgeWeight(s, t, 1.0);
                this.tg.increaseEdgeWeight(t, u, 1.0);
                this.tg.increaseEdgeWeight(u, s, 1.0);
            }
        }
    }

    @Override
    public String desciption(String sep) {
        return this.basicDescription(sep) + ", " + sep + this.nTriangles + " triangles, " + sep + this.avTriangleSourceNumber * 3.0 + " average triangles per vertex";
    }
}

