/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import cern.colt.list.IntArrayList;
import java.util.Random;

public class SimpleERCommunityGraph {
    static final String nameSERCG = "Simple ER Community Graph";
    static final String shortNameSERCG = "SERCG";
    String graphName = "Simple ER Community Graph";
    String shortGraphName = "SERCG";
    timgraph tg;
    int[] v2c;
    int[] firstVinC;
    IntArrayList[] c2v;
    int nVertices;
    int nStubsMax;
    double avDegree;
    int nCommunities;
    double probability;
    Random rnd;

    public SimpleERCommunityGraph() {
    }

    public SimpleERCommunityGraph(int numberCommunities, int sizeCommunities, double averageDegree, double prob, String[] args) {
        this.graphName = nameSERCG;
        this.shortGraphName = shortNameSERCG;
        this.tg = new timgraph(args);
        this.tg.setVertexEdgeList(true);
        this.nCommunities = numberCommunities;
        this.nVertices = this.nCommunities * sizeCommunities;
        this.avDegree = averageDegree;
        this.nStubsMax = (int)Math.round((double)this.nVertices * averageDegree);
        this.probability = prob;
        System.out.println("nVertices, nStubs " + this.nVertices + ", " + this.nStubsMax);
        this.tg.setNetworkWithVertices(this.nVertices, this.nStubsMax);
    }

    public static void main(String[] args) {
        int ano = 0;
        int numberCommunities = 4;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            numberCommunities = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int sizeCommunities = 32;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            sizeCommunities = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int averageDegree = 9;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            averageDegree = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        double prob = 1.0 / (double)averageDegree;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            prob = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        String[] arguments = new String[]{"-o255"};
        if (args.length > 0) {
            arguments = args;
        }
        SimpleERCommunityGraph rg = new SimpleERCommunityGraph(numberCommunities, sizeCommunities, averageDegree, prob, arguments);
        System.out.println("--- Created " + rg.desciption(""));
        rg.initialise();
        rg.setName();
        rg.create();
        rg.labelVertices();
        rg.information();
    }

    public void information() {
        this.tg.printParametersBasic();
        FileOutput fotg = new FileOutput(this.tg);
        fotg.informationGeneral("", "\t");
        boolean asNames = true;
        boolean infoOn = true;
        boolean headerOn = true;
        boolean edgeIndexOn = true;
        boolean edgeLabelOn = false;
        fotg.printEdges(asNames, infoOn, headerOn, edgeIndexOn, edgeLabelOn);
        fotg.informationNetworkBasic("#", "\t ");
        fotg.edgeListSimple(true);
    }

    public void initialise() {
        this.rnd = new Random();
        this.v2c = new int[this.nVertices];
        this.firstVinC = new int[this.nCommunities + 1];
        this.c2v = new IntArrayList[this.nCommunities];
        for (int c = 0; c < this.nCommunities; ++c) {
            this.c2v[c] = new IntArrayList();
        }
    }

    public void create() {
        int sizeCommunities = this.nVertices / this.nCommunities;
        this.createCommunityStructure(sizeCommunities);
        this.createERCommunities();
    }

    public void createCommunityStructure(int sizeCommunities) {
        int c = -1;
        for (int v = 0; v < this.nVertices; ++v) {
            this.v2c[v] = c = v / sizeCommunities;
            this.c2v[c].add(v);
        }
        for (c = 0; c <= this.nCommunities; ++c) {
            this.firstVinC[c] = c * sizeCommunities;
        }
    }

    public void labelVertices() {
        if (!this.tg.isVertexLabelled()) {
            this.tg.initialiseVertexLabels();
        }
        for (int v = 0; v < this.tg.getNumberVertices(); ++v) {
            this.tg.setVertexNumber(v, this.v2c[v]);
        }
    }

    public VertexPartition createVertexPartition() {
        double q = -9.7531E86;
        return new VertexPartition(q, this.nVertices, this.nStubsMax / 2, this.v2c);
    }

    public void createERCommunities() {
        int s = -1;
        int t = -1;
        int ncs = -1;
        for (int cs = 0; cs < this.nCommunities; ++cs) {
            ncs = this.firstVinC[cs + 1] - this.firstVinC[cs];
            int m = (int)(this.avDegree * (double)ncs) / 2;
            for (int i = 0; i < m; ++i) {
                s = this.firstVinC[cs] + this.rnd.nextInt(ncs);
                t = this.findTarget(this.probability, s, cs, ncs);
                this.tg.increaseEdgeWeight(s, t, 1.0);
            }
        }
    }

    public void createSimpleCommunities1() {
        int m = (int)this.avDegree / 2;
        int t = -1;
        int cs = -1;
        int ncs = -1;
        for (int s = 0; s < this.tg.getNumberVertices(); ++s) {
            cs = this.v2c[s];
            ncs = this.firstVinC[cs + 1] - this.firstVinC[cs];
            for (int i = 0; i < m; ++i) {
                t = this.findTarget(this.probability, s, cs, ncs);
                this.tg.addEdge(s, t);
            }
        }
    }

    public int findTarget(double p, int s, int cs, int ncs) {
        int t = -1;
        if (this.rnd.nextDouble() < p) {
            t = this.firstVinC[cs + 1] + this.rnd.nextInt(this.nVertices - ncs);
            if (t >= this.nVertices) {
                t -= this.nVertices;
            }
        } else {
            t = this.firstVinC[cs] + this.rnd.nextInt(ncs);
            while (t == s) {
                t = this.firstVinC[cs] + this.rnd.nextInt(ncs);
            }
        }
        return t;
    }

    public String basicDescription(String sep) {
        return this.graphName + sep + " with " + this.nCommunities + " communities, " + sep + this.nVertices / this.nCommunities + " average vertices each, " + sep + this.nVertices + " vertices in total, " + sep + this.avDegree + " average degree, " + sep + this.probability + " probability ";
    }

    public String desciption(String sep) {
        return this.basicDescription(sep);
    }

    public String shortName() {
        String mstring = "m";
        mstring = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? mstring + (int)(this.avDegree + 1.0E-6) : mstring + this.avDegree;
        return this.shortGraphName + "v" + this.nVertices + mstring + "c" + this.nCommunities + "p" + (int)(1000.0 * this.probability);
    }

    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }
}

