/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Coordinate;
import TimGraph.Generators.SimpleERCommunityGraph;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.Random;

public class GridCommunityGraph
extends SimpleERCommunityGraph {
    static final String nameGCG = "Grid Community Graph";
    static final String shortNameGCG = "GCG";
    int dimX = -135798642;
    int dimY = -135798642;
    int dimN = -135798642;
    int typeX = 0;
    int typeY = 0;
    int typeN = 0;
    private int[] distN;
    private int[] distX;
    private int[] distY;
    boolean firstSystematic = true;
    boolean systematic = false;

    public GridCommunityGraph() {
    }

    public GridCommunityGraph(int nX, int nY, int nC, int tX, int tY, int tN, double averageDegree, double prob, boolean firstSyst, boolean syst, double scale, String[] args) {
        this.graphName = nameGCG;
        this.shortGraphName = shortNameGCG;
        this.tg = new timgraph(args);
        this.tg.setVertexEdgeList(true);
        this.setName();
        this.dimX = nX;
        this.dimY = nY;
        this.dimN = nC;
        this.typeX = tX;
        this.typeY = tY;
        this.typeN = tN;
        this.setRandomDistribution(this.typeN, this.dimN, this.distN);
        this.setRandomDistribution(this.typeX, this.dimX, this.distX);
        this.setRandomDistribution(this.typeY, this.dimY, this.distY);
        this.nVertices = this.dimX * this.dimY * this.dimN;
        this.avDegree = averageDegree;
        this.nStubsMax = (int)Math.round((double)this.nVertices * averageDegree);
        this.probability = prob;
        this.nCommunities = this.dimX + this.dimY;
        System.out.println("nVertices, avDegree, nStubs " + this.nVertices + ", " + this.avDegree + ", " + this.nStubsMax);
        this.tg.setNetwork(this.nVertices, this.nStubsMax);
        this.rnd = new Random();
        this.create(firstSyst, syst, scale);
    }

    public static void main(String[] args) {
        int ano = 0;
        int dimX = 11;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            dimX = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int dimY = 11;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            dimY = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int dimC = 1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            dimC = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        double averageDegree = 8.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            averageDegree = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double prob = 0.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            prob = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        boolean firstSystematic = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            firstSystematic = StringFilter.trueString((String)args[ano].substring(1, args[ano].length()));
        }
        boolean systematic = false;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            firstSystematic = StringFilter.trueString((String)args[ano].substring(1, args[ano].length()));
        }
        int typeIndex = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            typeIndex = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int tX = typeIndex & true ? 1 : 0;
        int tY = (typeIndex & 2) == 2 ? 1 : 0;
        int tN = (typeIndex & 4) == 4 ? 1 : 0;
        double scale = 200.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            scale = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        String[] arguments = new String[]{"-o255"};
        if (args.length > 0) {
            arguments = args;
        }
        GridCommunityGraph tgcg = new GridCommunityGraph(dimX, dimY, dimC, tX, tY, tN, averageDegree, prob, firstSystematic, systematic, scale, arguments);
        System.out.println("--- Created " + tgcg.desciption("\n"));
        tgcg.setName();
        tgcg.information();
    }

    public void create(boolean firstSyst, boolean syst, double scale) {
        this.createVertices(scale);
        this.createEdges(firstSyst, syst);
    }

    public void createVertices(double scale) {
        double bigScaleFactor = 3.5;
        this.tg.initialiseVertexLabels();
        VertexGridCoordinates t = new VertexGridCoordinates();
        double radius = this.dimN < 2 ? scale : scale * (double)this.dimN / (Math.PI * 2);
        for (int v1 = 0; v1 < this.nVertices; ++v1) {
            t.set(v1);
            VertexLabel vl = new VertexLabel(v1, t.vectorString(), t.getCoordinate(radius, 3.5));
            vl.setNumber(v1 / this.dimN);
            this.tg.addVertex(vl);
        }
    }

    public void createEdges(boolean firstSyst, boolean syst) {
        this.firstSystematic = firstSyst;
        this.systematic = syst;
        double p = 1.0 - this.probability;
        double phalf = p / 2.0;
        int v1 = 0;
        for (v1 = 0; v1 < this.tg.getNumberVertices(); ++v1) {
            if (this.firstSystematic) {
                this.addEdgeFirstCommunityOnly(v1);
                this.addEdgeSecondCommunityOnly(v1);
                continue;
            }
            this.addEdge(v1, phalf, p);
            this.addEdge(v1, phalf, p);
        }
        while (this.tg.getNumberStubs() < this.nStubsMax) {
            if (this.systematic) {
                if (++v1 >= this.tg.getNumberVertices()) {
                    v1 = 0;
                }
            } else {
                v1 = this.rnd.nextInt(this.tg.getNumberVertices());
            }
            this.addEdge(v1, phalf, p);
        }
    }

    private int addEdgeFirstCommunityOnly(int v1) {
        return this.addEdge(v1, 2.0, 3.0);
    }

    private int addEdgeSecondCommunityOnly(int v1) {
        return this.addEdge(v1, -1.0, 3.0);
    }

    private int addEdge(int v1, double phalf, double p) {
        if (this.tg.getNumberStubs() >= this.nStubsMax) {
            System.err.println("*** In addEdge, current number of stubs is too large, nothing added. current, max= " + this.tg.getNumberStubs() + ", " + this.nStubsMax);
            return -1;
        }
        VertexGridCoordinates s = new VertexGridCoordinates(v1);
        double r = this.rnd.nextDouble();
        int v2 = v1;
        if (r < phalf) {
            while (v2 == v1) {
                v2 = this.getIndex(this.rnd.nextInt(this.dimN), this.rnd.nextInt(this.dimX), s.y);
            }
        } else if (r < p) {
            while (v2 == v1) {
                v2 = this.getIndex(this.rnd.nextInt(this.dimN), s.x, this.rnd.nextInt(this.dimY));
            }
        } else {
            while (v2 == v1) {
                v2 = this.rnd.nextInt(this.tg.getNumberVertices());
            }
        }
        this.tg.increaseEdgeWeight(v1, v2, 1.0);
        System.out.println("S" + this.tg.getNumberStubs() + "=(" + v1 + "," + v2 + ")");
        return this.tg.getNumberStubs();
    }

    private int findTarget(VertexGridCoordinates s, double phalf, double p) {
        double r = this.rnd.nextDouble();
        int v = -1;
        v = r < phalf ? this.getIndex(this.dimN < 2 ? 0 : this.rnd.nextInt(this.dimN), this.dimX < 2 ? 0 : this.rnd.nextInt(this.dimX), s.y) : (r < p ? this.getIndex(this.dimN < 2 ? 0 : this.rnd.nextInt(this.dimN), s.x, this.dimY < 2 ? 0 : this.rnd.nextInt(this.dimY)) : this.rnd.nextInt(this.tg.getNumberVertices()));
        return v;
    }

    private void setRandomDistribution(int type, int dim, int[] dist) {
        switch (type) {
            case 1: {
                int d = (dim + 1) * dim / 2;
                dist = new int[d];
                int j = 0;
                for (int n = 0; n < dim; ++n) {
                    for (int i = 0; i < n + 1; ++i) {
                        dist[j++] = n;
                    }
                }
                return;
            }
        }
        dist = new int[dim];
        for (int n = 0; n < dim; ++n) {
            dist[n] = n;
        }
    }

    private int getRandomN() {
        if (this.distN.length > 0) {
            return this.distN[this.rnd.nextInt(this.distN.length)];
        }
        return this.rnd.nextInt(this.dimN);
    }

    private int getRandomX() {
        if (this.distX.length > 0) {
            return this.distX[this.rnd.nextInt(this.distX.length)];
        }
        return this.rnd.nextInt(this.dimX);
    }

    private int getRandomY() {
        if (this.distY.length > 0) {
            return this.distY[this.rnd.nextInt(this.distY.length)];
        }
        return this.rnd.nextInt(this.dimY);
    }

    @Override
    public String desciption(String sep) {
        return this.basicDescription(sep) + ", " + sep + " grid " + this.dimX + " by " + this.dimY + sep + " number vertices per grid point " + this.dimN + sep + " number stubs added " + this.nStubsMax;
    }

    @Override
    public String shortName() {
        String mstring = "m";
        mstring = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? mstring + (int)(this.avDegree + 1.0E-6) : mstring + this.avDegree;
        return this.shortGraphName + "n" + this.typeChar(this.typeN) + this.dimN + "x" + this.typeChar(this.typeX) + this.dimX + "y" + this.typeChar(this.typeY) + this.dimY + (this.firstSystematic ? "s" : "r") + (this.systematic ? "s" : "r") + "s" + this.nStubsMax + "p" + (int)(1000.0 * this.probability);
    }

    private char typeChar(int type) {
        switch (type) {
            case 1: {
                return 'p';
            }
        }
        return 'u';
    }

    @Override
    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }

    int getIndex(int n, int x, int y) {
        return n + this.dimN * (x + this.dimX * y);
    }

    class VertexGridCoordinates {
        public int n = -1;
        public int x = -1;
        public int y = -1;

        VertexGridCoordinates() {
        }

        VertexGridCoordinates(int v) {
            this.set(v);
        }

        void set(int v) {
            this.n = v % GridCommunityGraph.this.dimN;
            int xy = v / GridCommunityGraph.this.dimN;
            this.x = xy % GridCommunityGraph.this.dimX;
            this.y = xy / GridCommunityGraph.this.dimX;
        }

        Coordinate getCoordinate(double radius, double bigScaleFactor) {
            if (GridCommunityGraph.this.dimN < 2) {
                return new Coordinate((double)this.x * radius, (double)this.y * radius);
            }
            return new Coordinate((Math.cos((double)this.n * Math.PI * 2.0 / (double)GridCommunityGraph.this.dimN) + (double)this.x * bigScaleFactor) * radius, (Math.sin((double)this.n * Math.PI * 2.0 / (double)GridCommunityGraph.this.dimN) + (double)this.y * bigScaleFactor) * radius);
        }

        String vectorString() {
            return "(" + (GridCommunityGraph.this.dimN > 1 ? this.n + "," : "") + this.x + "," + this.y + ")";
        }
    }
}

