/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Coordinate;
import TimGraph.Generators.SimpleERCommunityGraph;
import TimGraph.OutputMode;
import TimGraph.VertexLabel;
import TimGraph.algorithms.BipartiteTransformations;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.Random;

public class BipartiteGridCommunityGraph
extends SimpleERCommunityGraph {
    static final String nameBGCG = "Bipartite Grid Community Graph";
    static final String shortNameBGCG = "BGCG";
    int dimX = -135798642;
    int dimY = -135798642;
    int dimN = -135798642;
    int nPerC2 = -135798642;

    public BipartiteGridCommunityGraph(int nX, int nY, int nC, int nPerC2input, int numberStubs, double prob, boolean firstSystematic, boolean systematic, double scale, String[] args) {
        this.graphName = nameBGCG;
        this.shortGraphName = shortNameBGCG;
        this.tg = new timgraph(args);
        this.setName();
        this.dimX = nX;
        this.dimY = nY;
        this.dimN = nC;
        this.nPerC2 = nPerC2input;
        this.probability = prob;
        this.nCommunities = this.dimX + this.dimY;
        this.tg.setBipartite(this.dimX * this.dimY * this.dimN, this.nPerC2 * this.nCommunities, "Grid", "RowColumn");
        this.nStubsMax = numberStubs;
        this.nVertices = this.tg.getNumberVerticesType1() + this.tg.getNumberVerticesType2();
        this.tg.setVertexEdgeList(true);
        this.tg.setNetwork(this.nVertices, this.nStubsMax);
        System.out.println("BipartiteGridCommunityGraph grid " + this.dimX + " by " + this.dimY);
        this.rnd = new Random();
        this.create(firstSystematic, systematic, scale);
        this.project();
    }

    public static void main(String[] args) {
        int ano = 0;
        int dimX = 2;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            dimX = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int dimY = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            dimY = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int dimC = 32;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            dimC = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int nPerC2 = (dimX + dimY) / 3;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            nPerC2 = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        int numberStubs = dimX * dimY * dimC * (2 + nPerC2 * 2);
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            nPerC2 = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        double prob = 0.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            prob = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        boolean firstSystematic = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            firstSystematic = StringFilter.trueString((String)args[ano].substring(1, args[ano].length()));
        }
        boolean systematic = false;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            firstSystematic = StringFilter.trueString((String)args[ano].substring(1, args[ano].length()));
        }
        String[] arguments = new String[]{"-o255"};
        if (args.length > 0) {
            arguments = args;
        }
        double scale = 200.0;
        BipartiteGridCommunityGraph bg = new BipartiteGridCommunityGraph(dimX, dimY, dimC, nPerC2, numberStubs, prob, firstSystematic, systematic, scale, arguments);
        System.out.println("--- Created " + bg.desciption("\n"));
        bg.setName();
        bg.information();
    }

    public void create(boolean firstSystematic, boolean systematic, double scale) {
        this.createVertices(scale);
        this.createEdges(firstSystematic, systematic);
    }

    public void createVertices(double scale) {
        VertexLabel vl;
        double bigScaleFactor = 3.5;
        this.tg.initialiseVertexLabels();
        VertexGridCoordinates t = new VertexGridCoordinates();
        double radius = this.dimN < 2 ? scale : scale * (double)this.dimN / (Math.PI * 2);
        for (int v1 = 0; v1 < this.tg.getNumberVerticesType1(); ++v1) {
            t.set(v1);
            vl = new VertexLabel(v1, t.vectorString(), t.getCoordinate(radius, 3.5));
            vl.setNumber(v1 / this.dimN);
            this.tg.addVertex(vl);
        }
        int n = -1;
        int delta = -1;
        for (int v2 = 0; v2 < this.tg.getNumberVerticesType2(); ++v2) {
            n = v2 / this.nPerC2;
            delta = v2 % this.nPerC2;
            vl = n < this.dimY ? new VertexLabel(v2 + this.tg.getNumberVerticesType1(), "y" + n + "." + delta, new Coordinate((double)(this.dimX + delta) * 3.5 * radius, (double)n * 3.5 * radius)) : new VertexLabel(v2 + this.tg.getNumberVerticesType1(), "x" + (n - this.dimY) + "." + delta, new Coordinate((double)(n - this.dimY) * 3.5 * radius, (double)(this.dimY + delta) * 3.5 * radius));
            this.tg.addVertex(vl);
        }
    }

    @Override
    public String desciption(String sep) {
        return this.basicDescription(sep) + ", " + sep + " grid " + this.dimX + " by " + this.dimY + " with " + this.dimN + " vertices per grid point" + sep + " number type 2 vertices per community " + this.nPerC2;
    }

    public void createEdges(boolean firstSystematic, boolean systematic) {
        double p = 1.0 - this.probability;
        double phalf = p / 2.0;
        int v1 = 0;
        for (v1 = 0; v1 < this.tg.getNumberVerticesType1(); ++v1) {
            if (firstSystematic) {
                this.addEdge(v1, 2.0, 3.0);
                this.addEdge(v1, -1.0, 3.0);
                continue;
            }
            this.addEdge(v1, phalf, p);
            this.addEdge(v1, phalf, p);
        }
        while (this.tg.getNumberStubs() < this.nStubsMax) {
            if (systematic) {
                if (++v1 >= this.tg.getNumberVerticesType1()) {
                    v1 = 0;
                }
            } else {
                v1 = this.rnd.nextInt(this.tg.getNumberVerticesType1());
            }
            this.addEdge(v1, phalf, p);
        }
    }

    private int addEdge(int v1, double phalf, double p) {
        VertexGridCoordinates s = new VertexGridCoordinates(v1);
        double r = this.rnd.nextDouble();
        int v2 = -1;
        v2 = r < phalf ? this.tg.getNumberVerticesType1() + s.y * this.nPerC2 + this.rnd.nextInt(this.nPerC2) : (r < p ? this.tg.getNumberVerticesType1() + (this.dimY + s.x) * this.nPerC2 + this.rnd.nextInt(this.nPerC2) : this.tg.getNumberVerticesType1() + this.rnd.nextInt(this.tg.getNumberVerticesType2()));
        return this.tg.addEdgeUnique(v1, v2);
    }

    public void project() {
        boolean ontoTypeOne = true;
        boolean makeLabelled = true;
        boolean makeWeighted = true;
        boolean makeVertexEdgeList = true;
        boolean noSelfLoops = true;
        timgraph pg = BipartiteTransformations.project(this.tg, ontoTypeOne, makeLabelled, makeWeighted, makeVertexEdgeList, noSelfLoops);
        for (int v = 0; v < this.tg.getNumberVerticesType1(); ++v) {
            VertexLabel vl = new VertexLabel(this.tg.getVertexLabel(v));
            pg.setVertexLabelQuick(v, vl);
        }
        pg.setNameRoot(this.shortName() + "proj");
        FileOutput fopg = new FileOutput(pg);
        String cc = "#";
        String sep = "\t ";
        boolean printTriangles = true;
        boolean printSquares = true;
        boolean vertexListOn = true;
        boolean edgeListOn = true;
        boolean graphMLOn = true;
        OutputMode outputControl = null;
        fopg.informationGeneral(cc, sep, printTriangles, printSquares, vertexListOn, edgeListOn, graphMLOn, outputControl);
    }

    @Override
    public String shortName() {
        String mstring = "m";
        mstring = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? mstring + (int)(this.avDegree + 1.0E-6) : mstring + this.avDegree;
        return this.shortGraphName + "x" + this.dimX + "y" + this.dimY + "c" + this.nPerC2 + "s" + this.nStubsMax + "p" + (int)(1000.0 * this.probability);
    }

    @Override
    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }

    int getIndex(int n, int x, int y) {
        return n + this.dimN * (x + this.dimX * y);
    }

    class VertexGridCoordinates {
        public int n = -1;
        public int x = -1;
        public int y = -1;

        VertexGridCoordinates() {
        }

        VertexGridCoordinates(int v) {
            this.set(v);
        }

        void set(int v) {
            this.n = v % BipartiteGridCommunityGraph.this.dimN;
            int xy = v / BipartiteGridCommunityGraph.this.dimN;
            this.x = xy % BipartiteGridCommunityGraph.this.dimX;
            this.y = xy / BipartiteGridCommunityGraph.this.dimX;
        }

        Coordinate getCoordinate(double radius, double bigScaleFactor) {
            if (BipartiteGridCommunityGraph.this.dimN < 2) {
                return new Coordinate((double)this.x * radius, (double)this.y * radius);
            }
            return new Coordinate((Math.cos((double)this.n * Math.PI * 2.0 / (double)BipartiteGridCommunityGraph.this.dimN) + (double)this.x * bigScaleFactor) * radius, (Math.sin((double)this.n * Math.PI * 2.0 / (double)BipartiteGridCommunityGraph.this.dimN) + (double)this.y * bigScaleFactor) * radius);
        }

        String vectorString() {
            return "(" + (BipartiteGridCommunityGraph.this.dimN > 1 ? this.n + "," : "") + this.x + "," + this.y + ")";
        }
    }
}

