/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

public class EdgeValue
implements Comparable<EdgeValue> {
    public static final int NOLABEL = -98542182;
    public static final double NOWEIGHT = -9854218.2;
    int label;
    double weight;

    public EdgeValue() {
        this.label = -98542182;
        this.weight = 1.0;
    }

    public EdgeValue(int setlabel) {
        this.label = setlabel;
        this.weight = 1.0;
    }

    public EdgeValue(double setweight) {
        this.label = -98542182;
        this.weight = setweight;
    }

    public EdgeValue(int setlabel, double setweight) {
        this.label = setlabel;
        this.weight = setweight;
    }

    public EdgeValue(EdgeValue oldedgeweight) {
        this.label = oldedgeweight.label;
        this.weight = oldedgeweight.weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double w) {
        this.weight = w;
    }

    public void increaseWeight(double dw) {
        this.weight += dw;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int l) {
        this.label = l;
    }

    public boolean hasWeight() {
        return this.weight != -9854218.2;
    }

    public boolean hasLabel() {
        return this.label != -98542182;
    }

    public void setMinimum(EdgeValue minew) {
        if (minew == null) {
            minew = new EdgeValue(this);
            return;
        }
        if (this.hasLabel() && this.label < minew.getLabel()) {
            minew.setLabel(this.label);
        }
        if (this.hasWeight() && this.weight < minew.getWeight()) {
            minew.setWeight(this.weight);
        }
    }

    public void setMaximum(EdgeValue maxew) {
        if (maxew == null) {
            maxew = new EdgeValue(this);
            return;
        }
        if (this.hasLabel() && this.label > maxew.getLabel()) {
            maxew.setLabel(this.label);
        }
        if (this.hasWeight() && this.weight > maxew.getWeight()) {
            maxew.setWeight(this.weight);
        }
    }

    public String toString(String sep) {
        return (this.hasWeight() ? Double.valueOf(this.weight) : "UNSET") + sep + (this.hasLabel() ? Integer.valueOf(this.label) : "UNSET");
    }

    public static String headerString(String sep) {
        return "Weight" + sep + "Label";
    }

    public static String headerString(String sep, EdgeValue testEW) {
        if (testEW.hasWeight()) {
            if (testEW.hasLabel()) {
                return "Weight" + sep + "Label";
            }
            return "Label";
        }
        return "Weight";
    }

    public boolean equals(Object obj) {
        try {
            EdgeValue other = (EdgeValue)obj;
            return other.label == this.label && other.weight == this.weight;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.label;
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.weight) ^ Double.doubleToLongBits(this.weight) >>> 32);
        return hash;
    }

    @Override
    public int compareTo(EdgeValue o) {
        EdgeValue other = o;
        int diff = this.label - other.label;
        if (diff == 0) {
            double d = this.weight - other.weight;
            if (d == 0.0) {
                return 0;
            }
            if (d > 0.0) {
                return -1;
            }
            return 1;
        }
        return diff;
    }
}

