/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import DataAnalysis.LogBin;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class DegreeDistribution {
    String name = "unspecified";
    IntArrayList ddarr;
    int minimum = 9999999;
    int maximum;
    int continuous = this.maximum = -1;
    int totalvertices = 0;
    int totaledges = 0;
    double average = 0.0;
    double secondmoment = 0.0;
    public int infoLevel = 0;

    public DegreeDistribution(String inputName) {
        this.ddarr = new IntArrayList();
        this.name = inputName;
    }

    public DegreeDistribution(String inputName, int initialSize) {
        this.ddarr = new IntArrayList(initialSize);
        this.name = inputName;
    }

    void calcDegreeDistribution(IntArrayList[] vlist, int TNV) {
        this.maximum = -1;
        this.ddarr.add(0);
        for (int v = 0; v < TNV; ++v) {
            if (vlist[v] == null) {
                this.ddarr.set(0, this.ddarr.get(0) + 1);
                break;
            }
            int k = vlist[v].size();
            if (k < this.ddarr.size()) {
                this.ddarr.setQuick(k, this.ddarr.get(k) + 1);
                continue;
            }
            while (this.ddarr.size() < k) {
                this.ddarr.add(0);
            }
            this.ddarr.add(1);
        }
        this.calcValues();
    }

    void calcDegreeDistribution(IntArrayList[] vlist, int firstVertex, int lastVertexPlusOne) {
        this.maximum = -1;
        this.ddarr.add(0);
        firstVertex = 0;
        int fv = 0;
        if (firstVertex < 0) {
            fv = 0;
            System.err.println("*** ERROR in calcDegreeDistribution firstVertex=" + firstVertex + " less than one");
        }
        int lvp1 = lastVertexPlusOne;
        if (lastVertexPlusOne > vlist.length) {
            lastVertexPlusOne = vlist.length;
            System.err.println("*** ERROR in calcDegreeDistribution lastVertexPlusOne=" + lastVertexPlusOne + " larger than length of vertex array = " + vlist.length);
        }
        for (int v = firstVertex; v < lastVertexPlusOne; ++v) {
            if (vlist[v] == null) {
                this.ddarr.set(0, this.ddarr.get(0) + 1);
                break;
            }
            int k = vlist[v].size();
            if (k < this.ddarr.size()) {
                this.ddarr.setQuick(k, this.ddarr.get(k) + 1);
                continue;
            }
            while (this.ddarr.size() < k) {
                this.ddarr.add(0);
            }
            this.ddarr.add(1);
        }
        this.calcValues();
    }

    void calcDegreeDistribution(IntArrayList[] vlist, IntArrayList[] vsourcelist, int TNV) {
        this.calcDegreeDistribution(vlist, 0, TNV);
    }

    void calcValues() {
        this.totalvertices = 0;
        this.totaledges = 0;
        int nk = 0;
        double nk2 = 0.0;
        this.continuous = this.maximum + 1;
        this.minimum = 0;
        while (this.ddarr.get(this.minimum) == 0) {
            ++this.minimum;
        }
        for (int k = this.minimum; k < this.ddarr.size(); ++k) {
            nk = this.ddarr.get(k);
            this.totalvertices += nk;
            this.totaledges += nk * k;
            nk2 += (double)(nk * k * k);
            if (nk == 0 && k < this.continuous) {
                this.continuous = k;
            }
            if (nk <= 0) continue;
            this.maximum = k;
        }
        this.average = (double)this.totaledges / (double)this.totalvertices;
        this.secondmoment = nk2 / (double)this.totalvertices;
    }

    void FileOutputDegreeDistribution(String filenamecomplete, String cc, String sep, boolean normalise, boolean headersOn) {
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.print(PS, cc, sep, normalise, headersOn);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing " + this.name + " degree distribution to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("File Error with " + filenamecomplete);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    void FileOutputLogBinnedDegreeDistribution(String filenamecomplete, String cc, String sep, double lbratio, boolean infoOn, boolean headersOn) {
        if (this.maximum < 0) {
            this.calcValues();
        }
        LogBin lb = new LogBin();
        lb.calcLogBinAny(this.ddarr, this.minimum, this.maximum, 1, lbratio);
        lb.FileOutputLogBinnedFreqData(filenamecomplete, cc, sep, infoOn, headersOn);
    }

    void print(String cc, String sep, boolean normalise) {
        this.print(System.out, cc, sep, normalise, true);
    }

    void print(PrintStream PS, String cc, String sep, boolean normalise, boolean headersOn) {
        double p = 0.0;
        int n = 0;
        if (this.totalvertices < 1) {
            return;
        }
        if (headersOn) {
            PS.print(cc + " k " + sep + (normalise ? "p(k)" + sep + "Normalised " : "n(k)" + sep + "Unnormalised ") + this.name + " Degree Distribution  (not reduced = strength)");
            PS.println(sep + this.infoString(sep));
        }
        for (int k = 0; k < this.ddarr.size(); ++k) {
            if (normalise) {
                p = (double)this.ddarr.get(k) / (double)this.totalvertices;
                if (!(p > 0.0)) continue;
                PS.println(k + sep + p);
                continue;
            }
            n = (int)((double)this.ddarr.get(k) + 0.5);
            if (n <= 0) continue;
            PS.println(k + sep + n);
        }
    }

    public String infoString(String sep) {
        String s = "Min k" + sep + this.minimum;
        s = s + sep + "Continuum k1" + sep + this.continuous;
        s = s + sep + "Max k" + sep + this.maximum;
        s = s + sep + "<k>" + sep + this.average;
        s = s + sep + "<k^2>" + sep + this.secondmoment;
        s = s + sep + "N vertices" + sep + this.totalvertices;
        s = s + sep + "S Stubs" + sep + this.totaledges;
        return s;
    }

    public void outputInformation(PrintStream PS, String cc, String sep, int dec) {
        String fs = "%12." + dec + "6g";
        PS.println(cc + "Degree" + sep + "distribution" + sep + this.name);
        PS.println(cc + sep + "Total Vertices" + sep + this.totalvertices + sep + "Total Edges" + sep + this.totaledges);
        PS.println(cc + sep + "k_min" + sep + "k_cont" + sep + "k_max" + sep + "<k>" + sep + "<k^2>");
        PS.println(cc + sep + this.minimum + sep + this.continuous + sep + this.maximum + sep + String.format(fs, this.average) + sep + String.format(fs, this.secondmoment));
    }
}

