/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

public class Coordinate {
    double x;
    double y;
    double z;

    public Coordinate() {
        this.set(0.0, 0.0, 0.0);
    }

    public Coordinate(int xinit, int yinit) {
        this.set(xinit, yinit, 0.0);
    }

    public Coordinate(double xinit, double yinit) {
        this.set(xinit, yinit, 0.0);
    }

    public Coordinate(double xinit, double yinit, double zinit) {
        this.set(xinit, yinit, zinit);
    }

    public Coordinate(Coordinate oldc) {
        this.set(oldc);
    }

    public void set(Coordinate c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public void set(double xxx, double yyy) {
        this.x = xxx;
        this.y = yyy;
        this.z = 0.0;
    }

    public void set(double xxx, double yyy, double zzz) {
        this.x = xxx;
        this.y = yyy;
        this.z = zzz;
    }

    public void setToMinimum(Coordinate c) {
        this.x = Math.min(this.x, c.x);
        this.y = Math.min(this.y, c.y);
        this.z = Math.min(this.z, c.z);
    }

    public void setToMaximum(Coordinate c) {
        this.x = Math.max(this.x, c.x);
        this.y = Math.max(this.y, c.y);
        this.z = Math.max(this.z, c.z);
    }

    public void min(Coordinate c, Coordinate c2) {
        this.x = Math.min(c2.x, c.x);
        this.y = Math.min(c2.y, c.y);
        this.z = Math.min(c2.z, c.z);
    }

    public void max(Coordinate c, Coordinate c2) {
        this.x = Math.max(c2.x, c.x);
        this.y = Math.max(c2.y, c.y);
        this.z = Math.max(c2.z, c.z);
    }

    public boolean equals(Coordinate c) {
        return this.x == c.x && this.y == c.y && this.z == c.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double distance(Coordinate c) {
        return Math.sqrt((this.x - c.x) * (this.x - c.x) + (this.y - c.y) * (this.y - c.y) + (this.z - c.z) * (this.z - c.z));
    }

    public double distance2D(Coordinate c) {
        return Math.sqrt((this.x - c.x) * (this.x - c.x) + (this.y - c.y) * (this.y - c.y));
    }

    public String toString2D(String sep) {
        return this.x + sep + this.y;
    }

    public String toString(String sep) {
        return this.x + sep + this.y + sep + this.z;
    }

    public static String toString(Coordinate c, String sep) {
        if (c == null) {
            return "." + sep + "." + sep + ".";
        }
        return c.toString(sep);
    }

    public String print2DString(String separator) {
        String s = this.x + separator + this.y;
        return s;
    }

    public String printString(String separator) {
        String s = this.x + separator + this.y + separator + this.z;
        return s;
    }

    public static String labelString2D(String sep) {
        return "x" + sep + "y";
    }

    public static String labelString(String sep) {
        return "x" + sep + "y" + sep + "z";
    }

    public static Coordinate calcArc2DCoordinate(Coordinate s, Coordinate t, double factor) {
        double f = factor / Coordinate.calcLength(s, t);
        return new Coordinate((s.x + t.x) / 2.0 + (t.y - s.y) * f, (s.y + t.y) / 2.0 + (s.x - t.x) * f, (s.z + t.z) / 2.0);
    }

    public static Coordinate calcMidPoint(Coordinate s, Coordinate t) {
        return new Coordinate((s.x + t.x) / 2.0, (s.y + t.y) / 2.0, (s.z + t.z) / 2.0);
    }

    public static double calcLength(Coordinate s, Coordinate t) {
        return Math.sqrt((s.x - t.x) * (s.x - t.x) + (s.y - t.y) * (s.y - t.y) + (s.z - t.z) * (s.z + t.z));
    }
}

