/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.EdgePartition;
import TimGraph.Community.LouvainVertexPartition;
import TimGraph.Community.Partition;
import TimGraph.Community.SimulatedAnnealingvertexPartition;
import TimGraph.VertexLabel;
import TimGraph.algorithms.Projections;
import TimGraph.timgraph;
import TimUtilities.Permutation;
import TimUtilities.TimMemory;
import TimUtilities.TimTiming;
import TimUtilities.UpdateRecord;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;

public class VertexPartition
extends Partition {
    private Random Rnd = new Random();
    protected int numberEdges = -987123456;
    int edgesInVP = -1;
    private Permutation perm;
    protected UpdateRecord greedyUpdateRecord;
    int[] degreeArray;
    int[] degreeInCArray;
    double[] strengthArray;
    double[] strengthInCArray;
    double[] qualityArray;

    public VertexPartition() {
        this.setDefaultNames();
    }

    public VertexPartition(timgraph tg) {
        this.name = "generalVP";
        this.initialise(tg);
    }

    public VertexPartition(int nv) {
        this.name = "generalVP";
        this.setNumberElements(nv);
    }

    public VertexPartition(String newname, int nv) {
        this.setDefaultNames();
        this.setNumberElements(nv);
    }

    public VertexPartition(double q, int nv, int ne, int[] cov) {
        this.setDefaultNames();
        this.name = this.name + this.quality.QdefinitionShortString();
        this.Q = q;
        this.setNumberElements(nv);
        this.numberEdges = ne;
        this.setCommunity(cov);
    }

    public VertexPartition(timgraph tg, VertexPartition lgvp) {
        this.setDefaultNames();
        this.name = lgvp.getName() + "ep2vp";
        this.initialiseFromLineGraphVertexPartition(tg, lgvp);
    }

    private void setDefaultNames() {
        this.name = "generalVP";
        this.nameOfElements = "vertices";
    }

    public void initialise(timgraph tg) {
        this.initialise(tg, 0, 1, true);
    }

    public void initialise(timgraph tg, int qualityDefinition, int qualityType, boolean individualCommunities) {
        this.initialise(tg, qualityDefinition, qualityType, 1.0, individualCommunities ? 0 : -1);
    }

    public void initialise(timgraph tg, int qualityDefinition, int qualityType, int maxNumberCommunities) {
        this.initialise(tg, qualityDefinition, qualityType, 1.0, maxNumberCommunities);
    }

    public void initialise(timgraph tg, int qualityDefinition, int qualityType, double lambda, int maxNumberCommunities) {
        this.initialiseGraph(tg, qualityDefinition, qualityType, lambda);
        this.numberElements = this.graph.getNumberVertices();
        this.numberEdges = this.graph.getNumberStubs();
        if (this.infoLevel > 1 && this.numberElements < 21) {
            this.quality.printMatrix(System.out, " ", true);
        }
        this.setCommunity(maxNumberCommunities);
        this.Q = -9.87123456E8;
    }

    private void initialiseFromLineGraphVertexPartition(timgraph tg, VertexPartition lgvp) {
        this.initialiseFromLineGraphVertexPartition(tg, lgvp, -9.7531E86, false);
    }

    private void initialiseFromLineGraphVertexPartition(timgraph tg, VertexPartition lgvp, double minimumValue, boolean normaliseOn) {
        double MINNORM = 1.0E-6;
        this.initialise(tg, 0, 2, false);
        int nc = lgvp.getNumberOfCommunities();
        double[] score = new double[nc];
        for (int v = 0; v < this.numberElements; ++v) {
            for (int c = 0; c < nc; ++c) {
                score[c] = 0.0;
            }
            double norm = 0.0;
            for (int ei = 0; ei < tg.getVertexOutDegree(v); ++ei) {
                int e = tg.getEdge(v, ei);
                int ce = lgvp.getCommunity(e / 2);
                double value = tg.isWeighted() ? tg.getEdgeWeight(e) : 1.0;
                norm += value;
                int n = ce;
                score[n] = score[n] + value;
            }
            double maxValue = minimumValue;
            int cbest = -789456123;
            if (norm < 1.0E-6) {
                this.communityOfElement[v] = -789456123;
                continue;
            }
            if (!normaliseOn) {
                norm = 1.0;
            }
            double vmaxValue = maxValue * norm;
            for (int c = 0; c < nc; ++c) {
                if (vmaxValue > score[c] || vmaxValue == score[c] && this.Rnd.nextDouble() < 0.5) continue;
                vmaxValue = score[c];
                cbest = c;
            }
            this.communityOfElement[v] = cbest;
        }
        this.recalculateCommunityLabels();
    }

    public int getNumberVertices() {
        return this.numberElements;
    }

    public int getNumberVerticesInCommunityFast(int c) {
        return this.getNumberElementsInCommunity(c);
    }

    public int getNumberVerticesInCommunity(int c) {
        if (this.numberElementsArray == null) {
            this.analyse();
        }
        return this.numberElementsArray[c];
    }

    public int getDegreeOfCommunity(int c) {
        return this.degreeArray[c];
    }

    public int getDegreeInCommunity(int c) {
        return this.degreeInCArray[c];
    }

    public double getStrengthOfCommunity(int c) {
        return this.strengthArray[c];
    }

    public double getStrengthInCommunity(int c) {
        return this.strengthInCArray[c];
    }

    public double getQualityOfCommunity(int c) {
        return this.qualityArray[c];
    }

    public timgraph getVertexPartitionGraph() {
        return Projections.ontoVertexPartition(this.graph.inputName.getNameRoot() + "proj" + this.name, this.graph, this.communityOfElement, this.numberCommunities, false, false);
    }

    public int compareEPtoVP(EdgePartition ep) {
        this.edgesInVP = 0;
        int edgesInVPEP = 0;
        int s = -1;
        int t = -1;
        int cs = -1;
        int ct = -1;
        for (int e = 0; e < this.graph.getNumberStubs(); ++e) {
            s = this.graph.getVertexFromEdge(e++);
            t = this.graph.getVertexFromEdge(e);
            ct = this.communityOfElement[t];
            if (ct != (cs = this.communityOfElement[s])) continue;
            ++this.edgesInVP;
            ++edgesInVPEP;
        }
        return edgesInVPEP;
    }

    public int getNumberOfEdgesInVP() {
        return this.edgesInVP;
    }

    public int calculateBestGreedyCommunity(int maxSweeps) {
        return this.calculateBestGreedyCommunity(maxSweeps, 5.0);
    }

    public int calculateBestGreedyCommunity(int maxSweeps, double intervalTimeToPrintMinutes) {
        this.perm = new Permutation(this.numberElements);
        this.greedyUpdateRecord = new UpdateRecord();
        boolean printInfo = this.infoLevel > 0 && intervalTimeToPrintMinutes > 0.0;
        TimTiming tt = new TimTiming();
        TimMemory memory = new TimMemory();
        if (printInfo) {
            System.out.println("\n\nInitial Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities());
            System.out.println("                    initial memory " + memory.StringAllValues());
        }
        tt.setIntervalTimeMinutes(intervalTimeToPrintMinutes);
        for (int n = 0; n < maxSweeps; ++n) {
            double totalQualityChange = this.oneGreedySweep(intervalTimeToPrintMinutes);
            if (tt.testIntervalTime()) {
                this.recalculateCommunityLabels();
                System.out.println("\nGreedy Sweep " + n + ", quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities() + ", Quality change " + totalQualityChange + ", " + this.greedyUpdateRecord.toString() + ".");
                System.out.println("                    time ellapsed " + tt.runTimeString() + ", memory " + memory.StringAllValues());
            }
            if (this.greedyUpdateRecord.getMade() == 0) break;
        }
        if (printInfo) {
            System.out.println("Final Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities());
            System.out.println("                    initial memory " + memory.StringAllValues() + "\n\n");
        }
        return this.greedyUpdateRecord.getMade();
    }

    private double oneGreedySweep(double intervalTimeToPrintMinutes) {
        TimTiming tt = new TimTiming();
        TimMemory memory = new TimMemory();
        tt.setIntervalTimeMinutes(intervalTimeToPrintMinutes);
        double totalQualityChange = 0.0;
        int updateTried = 0;
        int updateMade = 0;
        double deltaQremove = 0.0;
        int oldCommunity = -1;
        this.perm.newPermutation();
        int s = -1;
        double deltaQ = 0.0;
        double deltaQmax = 0.0;
        int cmax = -1;
        double dnv = this.graph.getNumberVertices();
        for (int i = 0; i < this.graph.getNumberVertices(); ++i) {
            if (tt.testIntervalTime()) {
                this.recalculateCommunityLabels();
                double f = (double)i / dnv;
                System.out.println("Completed " + Math.round(f * 100.0) + "%, time ellapsed/left " + tt.runTimeString() + "  " + tt.estimateRemainingTimeString(f));
                System.out.println("                  memory " + memory.StringAllValues());
            }
            if ((deltaQremove = -this.quality.delta(s = this.perm.next(), oldCommunity = this.communityOfElement[s], this.communityOfElement)) > 0.0) {
                cmax = -86421357;
                deltaQmax = deltaQremove;
            } else {
                deltaQmax = 0.0;
                cmax = oldCommunity;
            }
            int kout = this.graph.getVertexOutDegree(s);
            if (kout == 0) continue;
            TreeSet<Integer> nc = new TreeSet<Integer>();
            for (int e = 0; e < kout; ++e) {
                int nn = this.graph.getNeighbour(s, e);
                int cnn = this.communityOfElement[nn];
                nc.add(cnn);
            }
            Iterator citer = nc.iterator();
            int c = -1;
            while (citer.hasNext()) {
                c = (Integer)citer.next();
                if (c == oldCommunity || (deltaQ = this.quality.delta(s, c, this.communityOfElement) + deltaQremove) < deltaQmax) continue;
                cmax = c;
                deltaQmax = deltaQ;
            }
            ++updateTried;
            if (cmax == oldCommunity) continue;
            totalQualityChange += deltaQmax;
            if (cmax == -86421357) {
                cmax = this.getEmptyCommunity();
            }
            this.communityOfElement[s] = cmax;
            ++updateMade;
        }
        this.greedyUpdateRecord.update(updateTried, updateMade);
        return totalQualityChange;
    }

    public void printVertices(PrintStream PS, String cc, String sep, boolean infoOn, boolean headerOn) {
        if (this.graph == null) {
            throw new RuntimeException("vertexPartition.printVertices need graph to be defined");
        }
        if (this.graph.getNumberVertices() != this.numberElements) {
            throw new RuntimeException("vertexPartition.printAnalysis graph has " + this.graph.getNumberVertices() + " while partition has " + this.numberElements + " " + this.nameOfElements);
        }
        int e = -1;
        int sc = -1;
        double q = -1.0;
        int degree = -1;
        double str = -1.0;
        int degreeInC = -1;
        double strInC = -1.0;
        double ew = -1.0;
        int t = -1;
        boolean printNearestNeighbours = false;
        boolean weighted = this.graph.isWeighted();
        boolean printTriangles = false;
        boolean printSquares = false;
        boolean printName = false;
        boolean printNumber = false;
        boolean printPosition = false;
        boolean printStrength = false;
        boolean printRank = false;
        if (this.graph.isVertexLabelled()) {
            VertexLabel l = this.graph.getVertexLabel(0);
            printName = l.hasName();
            printNumber = l.hasNumber();
            printPosition = l.hasPosition();
            printStrength = l.hasStrength();
            printRank = l.hasRank();
        }
        if (infoOn) {
            PS.println(cc + "Number of " + this.nameOfElements + sep + this.numberElements + sep + "Number of Communities" + sep + this.numberCommunities);
        }
        if (headerOn) {
            PS.print(this.graph.getVertexStringLabel(cc, sep, printTriangles, printSquares, true, printName, printNumber, printPosition, printStrength, printRank, printNearestNeighbours));
            PS.print(sep + "k_C" + sep + "k_C/k");
            if (weighted) {
                PS.print(sep + "str_C" + sep + "str_C/str");
            }
            PS.println();
        }
        for (int s = 0; s < this.graph.getNumberVertices(); ++s) {
            sc = this.communityOfElement[s];
            PS.print(this.graph.getVertexString(cc, sep, s, sc, printTriangles, printSquares, printName, printNumber, printPosition, printStrength, printRank, printNearestNeighbours));
            q = 0.0;
            if (weighted) {
                strInC = 0.0;
            }
            degree = this.graph.getVertexOutDegree(s);
            if (weighted) {
                str = this.graph.getVertexOutStrength(s);
            }
            degreeInC = 0;
            for (int el = 0; el < degree; ++el) {
                t = this.graph.getNeighbourQuick(s, el);
                q += this.quality.get(s, t);
                e = this.graph.getEdge(s, el);
                ew = this.graph.getEdgeWeight(e);
                if (this.communityOfElement[t] != sc) continue;
                ++degreeInC;
                if (!weighted) continue;
                strInC += ew;
            }
            PS.print(sep + degreeInC + sep + (double)degreeInC / (double)degree);
            if (weighted) {
                PS.print(sep + strInC + sep + strInC / str);
            }
            PS.println();
        }
    }

    public void printSimpleVertexCommunityList(PrintStream PS, String cc, String sep, boolean infoOn, boolean headerOn) {
        if (this.graph == null) {
            throw new RuntimeException("vertexPartition.printVertices need graph to be defined");
        }
        if (this.graph.getNumberVertices() != this.numberElements) {
            throw new RuntimeException("vertexPartition.printAnalysis graph has " + this.graph.getNumberVertices() + " while partition has " + this.numberElements + " " + this.nameOfElements);
        }
        if (infoOn) {
            PS.println(cc + "Number of " + this.nameOfElements + sep + this.numberElements + sep + "Number of Communities" + sep + this.numberCommunities);
        }
        if (headerOn) {
            PS.println(cc + "Vertex" + sep + "Community");
        }
        for (int s = 0; s < this.graph.getNumberVertices(); ++s) {
            PS.println(this.graph.getVertexName(s) + sep + this.communityOfElement[s]);
        }
    }

    @Override
    public void printStatistics(PrintStream PS, String cc, String sep, boolean infoOn, boolean headerOn) {
        if (this.graph == null) {
            throw new RuntimeException("vertexPartition.printCommunities need graph to be defined");
        }
        if (this.graph.getNumberVertices() != this.numberElements) {
            throw new RuntimeException("vertexPartition.printAnalysis graph has " + this.graph.getNumberVertices() + " while partition has " + this.numberElements + " " + this.nameOfElements);
        }
        boolean weighted = this.graph.isWeighted();
        if (infoOn) {
            PS.println(cc + "Number of " + this.nameOfElements + sep + this.numberElements + sep + "Number of Communities" + sep + this.numberCommunities);
            if (this.communityStatistics == null) {
                this.calculateCommunityStatistics();
            }
            PS.println(this.communityStatistics.labelString(sep));
            PS.println(this.communityStatistics.toString(sep));
        }
        if (headerOn) {
            PS.print(cc + "Community" + sep + "N_C" + sep + "k_C" + sep + "k_C" + sep + "k_C/k");
            if (weighted) {
                PS.print(sep + "str" + sep + "str_C" + sep + "str_C/str");
            }
            PS.println(sep + "quality");
        }
        this.analyse();
        for (int c = 0; c < this.numberCommunities; ++c) {
            PS.print(c + sep + this.numberElementsArray[c] + sep + this.degreeArray[c] + sep + this.degreeInCArray[c]);
            if (this.degreeArray[c] > 0) {
                PS.print(sep + (double)this.degreeInCArray[c] / (double)this.degreeArray[c]);
            } else {
                PS.print(sep + "0");
            }
            if (weighted) {
                PS.print(sep + this.strengthArray[c] + sep + this.strengthInCArray[c]);
                if (this.strengthArray[c] > 0.0) {
                    PS.print(sep + this.strengthInCArray[c] / this.strengthArray[c]);
                } else {
                    PS.print(sep + "0");
                }
            }
            PS.println(sep + this.qualityArray[c]);
        }
    }

    public void analyse(int[] numberElementsArray, int[] degreeArray, int[] degreeInCArray, double[] strengthArray, double[] strengthInCArray, double[] qualityArray) {
    }

    @Override
    public void analyse() {
        int e = -1;
        int sc = -1;
        int degree = -1;
        double ew = 1.0;
        int t = -1;
        boolean printNearestNeighbours = false;
        boolean weighted = this.graph.isWeighted();
        this.numberElementsArray = new int[this.numberCommunities];
        this.degreeArray = new int[this.numberCommunities];
        this.degreeInCArray = new int[this.numberCommunities];
        if (weighted) {
            this.strengthArray = new double[this.numberCommunities];
            this.strengthInCArray = new double[this.numberCommunities];
        } else {
            this.strengthArray = null;
        }
        this.qualityArray = new double[this.numberCommunities];
        for (int s = 0; s < this.graph.getNumberVertices(); ++s) {
            int n = sc = this.communityOfElement[s];
            this.numberElementsArray[n] = this.numberElementsArray[n] + 1;
            degree = this.graph.getVertexOutDegree(s);
            int n2 = sc;
            this.degreeArray[n2] = this.degreeArray[n2] + degree;
            for (int el = 0; el < degree; ++el) {
                t = this.graph.getNeighbourQuick(s, el);
                int n3 = sc;
                this.qualityArray[n3] = this.qualityArray[n3] + this.quality.get(s, t);
                e = this.graph.getEdge(s, el);
                if (weighted) {
                    ew = this.graph.getEdgeWeight(e);
                    int n4 = sc;
                    this.strengthArray[n4] = this.strengthArray[n4] + ew;
                }
                if (this.communityOfElement[t] != sc) continue;
                int n5 = sc;
                this.degreeInCArray[n5] = this.degreeInCArray[n5] + 1;
                if (!weighted) continue;
                int n6 = sc;
                this.strengthInCArray[n6] = this.strengthInCArray[n6] + ew;
            }
        }
        ew = 0.0;
        e = 1;
    }

    public static VertexPartition calculate(timgraph g, int qualityDefinition, int method, int infoLevel) {
        return VertexPartition.calculate(g, qualityDefinition, 1, 1.0, method, infoLevel);
    }

    public static VertexPartition calculate(timgraph g, int qualityDefinition, int qualityType, double lambda, int method, int infoLevel) {
        VertexPartition c;
        switch (method) {
            default: {
                LouvainVertexPartition lc = new LouvainVertexPartition(g, qualityDefinition, qualityType, lambda, infoLevel, -1);
                lc.calculate();
                c = lc;
                break;
            }
            case 1: {
                SimulatedAnnealingvertexPartition sac = new SimulatedAnnealingvertexPartition(g, qualityDefinition, qualityType, lambda, infoLevel, -1);
                sac.calculateRecursively(1000, 0.5, false);
                c = sac;
            }
        }
        c.recalculateCommunityLabels();
        if (infoLevel > 0) {
            System.out.println("*** Best community:-");
            c.printInformation(System.out, "", " ");
        }
        return c;
    }
}

