/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.Community;
import TimGraph.Community.Partition;
import TimGraph.io.FileInput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class VertexCommunity
extends Community {
    public VertexCommunity() {
        this.setDefaultNames();
    }

    public VertexCommunity(String inputname) {
        this.name = inputname;
        this.nameOfElements = "vertices";
    }

    public VertexCommunity(timgraph tg) {
        this.nameOfElements = "vertices";
        this.initialiseFromGraph(tg);
    }

    public VertexCommunity(timgraph tg, ArrayList<ArrayList<Integer>> vertexToCommunity) {
        this.nameOfElements = "vertices";
        this.initialiseFromGraph(tg);
        this.setUp(vertexToCommunity);
    }

    public void initialiseFromGraph(timgraph tg) {
        this.name = tg.inputName.getNameRoot();
        this.nameOfElements = "vertices";
        this.graph = tg;
    }

    public VertexCommunity(timgraph tg, Partition p, int qdef, int qualityType, double newlambda) {
        this.setDefaultNames();
        this.initialiseGraph(tg, qdef, qualityType, newlambda);
        if (tg.getNumberVertices() == p.getNumberElements()) {
            this.initialiseFromVertexPartition(p);
        } else if (tg.getNumberStubs() / 2 == p.getNumberElements()) {
            this.initialiseFromEdgePartition(tg, p);
        } else {
            throw new RuntimeException("*** Community constructor: Neither number of vertices " + tg.getNumberVertices() + " nor the number of edges " + tg.getNumberStubs() / 2 + " matches number of elements in partition " + p.getNumberElements());
        }
    }

    private void setDefaultNames() {
        this.name = "generalVP";
        this.nameOfElements = "vertices";
    }

    private void initialiseFromVertexPartition(Partition vp) {
        this.name = vp.getName() + "vp";
        this.numberCommunities = vp.getNumberOfCommunities();
        this.numberElements = vp.getNumberElements();
        this.communityMatrix = new SparseDoubleMatrix2D(this.numberElements, this.numberCommunities);
        for (int v = 0; v < this.numberElements; ++v) {
            this.communityMatrix.set(v, vp.getCommunity(v), 1.0);
        }
    }

    private void initialiseFromEdgePartition(timgraph tg, Partition ep) {
        this.name = ep.getName() + "ep2vc";
        this.graph = tg;
        this.numberCommunities = ep.getNumberOfCommunities();
        this.numberElements = tg.getNumberVertices();
        this.communityMatrix = new SparseDoubleMatrix2D(this.numberElements, this.numberCommunities);
        double s = -1.0;
        int e = -1;
        int ce = -1;
        double f = -1.0;
        for (int v = 0; v < this.numberElements; ++v) {
            s = tg.isWeighted() ? tg.getVertexOutStrength(v) : (double)tg.getVertexOutDegree(v);
            for (int ei = 0; ei < tg.getVertexOutDegree(v); ++ei) {
                e = tg.getEdge(v, ei);
                ce = ep.getCommunity(e / 2);
                f = this.communityMatrix.get(v, ce) + (tg.isWeighted() ? tg.getEdgeWeight(e) : 1.0) / s;
                this.communityMatrix.set(v, ce, f);
            }
        }
    }

    public int getNumberVertices() {
        return this.numberElements;
    }

    public void readVertexCommunity(String fullFileName, TreeMap<String, Integer> vertexNameToIndex, boolean forceNormalisation, boolean checkNormalisation) {
        boolean forceLowerCase = false;
        boolean checkBipartite = false;
        int sampleFrequency = 1;
        if (fullFileName.endsWith("BVNLS.dat")) {
            this.readStringVertexCommunitiesFile(vertexNameToIndex, fullFileName, forceLowerCase, checkBipartite, sampleFrequency, forceNormalisation, checkNormalisation);
        }
        if (fullFileName.endsWith("vcis")) {
            int columnVertex = 1;
            int columnCommunity = 2;
            int columnWeight = 8;
            boolean headerOn = true;
            this.readVertexCommunityListFile(vertexNameToIndex, fullFileName, columnVertex, columnCommunity, columnWeight, forceNormalisation, checkNormalisation, headerOn);
        }
    }

    public void readStringVertexCommunitiesFile(TreeMap<String, Integer> vertexNameToIndex, String fullFileName, boolean forceLowerCase, boolean checkBipartite, int sampleFrequency, boolean forceNormalisation, boolean checkNormalisation) {
        System.out.println("Starting to read vertex community using a vertex communities list with string vertex labels from " + fullFileName);
        TreeSet<String> vertexLL = new TreeSet<String>();
        TreeSet<String> communityLL = new TreeSet<String>();
        ArrayList<String> edgeLL = new ArrayList<String>();
        DoubleArrayList edgeWeightLL = new DoubleArrayList();
        StringFilter stringFilterSource = null;
        StringFilter stringFilterTarget = null;
        TreeSet<String> filterL = null;
        FileInput.readStringVertexNeighbourFile(fullFileName, vertexLL, communityLL, edgeLL, edgeWeightLL, forceLowerCase, checkBipartite, sampleFrequency, stringFilterSource, stringFilterTarget, filterL, this.infoLevel > 1);
        this.setUp(vertexNameToIndex, vertexLL, communityLL, edgeLL, edgeWeightLL, forceNormalisation, checkNormalisation);
    }

    public void readVertexCommunityListFile(TreeMap<String, Integer> vertexNameToIndex, String fullFileName, int columnVertex, int columnCommunity, int columnWeight, boolean forceNormalisation, boolean checkNormalisation) {
        boolean headerOn = false;
        this.readVertexCommunityListFile(vertexNameToIndex, fullFileName, columnVertex, columnCommunity, columnWeight, forceNormalisation, checkNormalisation, headerOn);
    }

    public void readVertexCommunityListFile(TreeMap<String, Integer> vertexNameToIndex, String fullFileName, int columnVertex, int columnCommunity, int columnWeight, boolean forceNormalisation, boolean checkNormalisation, boolean headerOn) {
        System.out.println("Starting to read vertex community using a vertex-community edge listlist with string vertex labels from " + fullFileName);
        TreeSet<String> vertexLL = new TreeSet<String>();
        TreeSet<String> communityLL = new TreeSet<String>();
        ArrayList<String> edgeLL = new ArrayList<String>();
        DoubleArrayList edgeWeightLL = new DoubleArrayList();
        FileInput fi = new FileInput(this.infoLevel);
        int columnLabel = -1;
        fi.readStringEdgeFile(fullFileName, columnVertex, columnCommunity, columnWeight, columnLabel, vertexLL, communityLL, edgeLL, edgeWeightLL, null, headerOn);
        this.setUp(vertexNameToIndex, vertexLL, communityLL, edgeLL, edgeWeightLL, forceNormalisation, checkNormalisation);
    }

    public void setUp(TreeMap<String, Integer> vertexNameToIndex, Set<String> vertexLL, Set<String> communityLL, ArrayList<String> edgeLL, DoubleArrayList edgeWeightLL, boolean forceNormalisation, boolean checkNormalisation) {
        int v;
        if (vertexNameToIndex == null) {
            vertexNameToIndex = new TreeMap();
            int vnumber = 0;
            for (String vname : vertexLL) {
                vertexNameToIndex.put(vname, vnumber++);
            }
        }
        TreeMap<String, Integer> communityNameToIndex = new TreeMap<String, Integer>();
        int cnumber = 0;
        for (String cname : communityLL) {
            communityNameToIndex.put(cname, cnumber++);
        }
        String vName = "";
        String cname = "";
        this.initialiseEmptyCommunity(vertexLL.size(), communityLL.size());
        int numberVertexStubsIncluded = 0;
        int numberVertexStubsTotal = 0;
        double ew = -1.0;
        double f = -1.0;
        for (int e = 0; e < edgeLL.size(); ++e) {
            vName = edgeLL.get(e++);
            Integer vertex = vertexNameToIndex.get(vName);
            ++numberVertexStubsTotal;
            if (vertex == null) continue;
            ++numberVertexStubsIncluded;
            this.setElementName(vertex, vName);
            cname = edgeLL.get(e);
            cnumber = (Integer)communityNameToIndex.get(cname);
            ew = edgeWeightLL.getQuick(e / 2);
            f = this.communityMatrix.get(vertex.intValue(), cnumber) + ew;
            this.communityMatrix.set(vertex.intValue(), cnumber, f);
            this.setCommunityName(cnumber, cname);
        }
        if (numberVertexStubsIncluded == numberVertexStubsTotal) {
            System.out.println("  Found " + numberVertexStubsTotal + " and all were included");
        } else {
            System.out.println("*** Found " + numberVertexStubsTotal + " vertex stubs, but only included " + numberVertexStubsIncluded);
        }
        if (forceNormalisation && (v = this.normaliseMatrix(1.0E-6)) >= 0) {
            throw new RuntimeException("Forcing community matrix normalisation failure for vertex " + v);
        }
        if (checkNormalisation && (v = this.checkMatrixNormalisation(1.0E-6)) >= 0) {
            throw new RuntimeException("Matrix normalisation failure for vertex " + v);
        }
    }

    public void setUp(int numberVertices, ArrayList<ArrayList<Integer>> motifToVertex, int[] motifToCommunity, boolean forceNormalisation, boolean checkNormalisation) {
        int v;
        ArrayList vertexInCommunity = new ArrayList();
        for (int v2 = 0; v2 < numberVertices; ++v2) {
            vertexInCommunity.add(new ArrayList());
        }
        TreeSet<Integer> vertexInMotifSet = new TreeSet<Integer>();
        TreeSet<Integer> communitySet = new TreeSet<Integer>();
        for (int m = 0; m < motifToCommunity.length; ++m) {
            ArrayList<Integer> motif = motifToVertex.get(m);
            communitySet.add(motifToCommunity[m]);
            for (Integer v3 : motif) {
                vertexInMotifSet.add(v3);
            }
        }
        int unassignedVertices = numberVertices - vertexInMotifSet.size();
        int communityNumber = communitySet.size();
        int totalNumberCommunities = unassignedVertices + communityNumber;
        this.initialiseEmptyCommunity(numberVertices, totalNumberCommunities);
        TreeMap<Integer, Integer> oldToNewCommunity = new TreeMap<Integer, Integer>();
        int newc = 0;
        for (Integer c : communitySet) {
            oldToNewCommunity.put(c, newc++);
        }
        for (int m = 0; m < motifToCommunity.length; ++m) {
            ArrayList<Integer> motif = motifToVertex.get(m);
            newc = (Integer)oldToNewCommunity.get(motifToCommunity[m]);
            for (Integer v4 : motif) {
                this.increaseCommunityMembership(v4, newc, 1.0);
            }
        }
        for (v = 0; v < this.getNumberVertices(); ++v) {
            if (vertexInMotifSet.contains(v)) continue;
            this.setCommunityMembership(v, communityNumber++, 1.0);
        }
        if (forceNormalisation && (v = this.normaliseMatrix(1.0E-6)) >= 0) {
            throw new RuntimeException("Forcing community matrix normalisation failure for vertex " + v);
        }
        if (checkNormalisation && (v = this.checkMatrixNormalisation(1.0E-6)) >= 0) {
            throw new RuntimeException("Matrix normalisation failure for vertex " + v);
        }
    }

    public void setUp(ArrayList<ArrayList<Integer>> vertexToCommunity) {
        ArrayList<Integer> vc;
        TreeSet<Integer> communityList = new TreeSet<Integer>();
        int numberVertices = this.getNumberVertices();
        for (int v = 0; v < numberVertices; ++v) {
            vc = vertexToCommunity.get(v);
            if (vc.size() > 0) {
                for (Integer c : vc) {
                    communityList.add(c);
                }
                continue;
            }
            communityList.add(v + numberVertices);
        }
        int nc = 0;
        TreeMap<Integer, Integer> oldToNew = new TreeMap<Integer, Integer>();
        for (Integer c : communityList) {
            oldToNew.put(c, nc++);
        }
        this.communityMatrix = new SparseDoubleMatrix2D(numberVertices, communityList.size());
        for (int v = 0; v < numberVertices; ++v) {
            vc = vertexToCommunity.get(v);
            double inc = 1.0 / (double)vc.size();
            for (Integer c : vc) {
                int newc = (Integer)oldToNew.get(c);
                double f = this.communityMatrix.get(v, newc) + inc;
                this.communityMatrix.set(v, newc, f);
            }
        }
    }
}

