/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.VertexPartition;
import TimGraph.timgraph;
import TimUtilities.Permutation;
import TimUtilities.UpdateRecord;
import java.util.Random;

public class SimulatedAnnealingvertexPartition
extends VertexPartition {
    private static int MAXSWEEPS = 5;
    public static final String SIMANNAME = "SimAn";
    private Permutation edgePerm;
    private Permutation vertexPerm;
    private UpdateRecord updateRecord;
    private Random Rnd;
    private double bestQuality = -9876543.21;
    private int[] bestcommunityOfElement;
    private int maxCommunities;
    private int level = -987123456;

    public SimulatedAnnealingvertexPartition(timgraph tg) {
        this.name = SIMANNAME;
        this.initialise(tg);
        this.maxCommunities = tg.getNumberVertices();
        this.Rnd = new Random();
    }

    public SimulatedAnnealingvertexPartition(timgraph tg, int numberCommunities) {
        this.initialise(tg, 0, 1, 1.0, numberCommunities);
        this.maxCommunities = numberCommunities < 2 ? this.numberElements : numberCommunities;
        this.Rnd = new Random();
    }

    public SimulatedAnnealingvertexPartition(timgraph tg, int qdef, int qualityType, int newinfolevel, int numberCommunities, int maxNumberCommunities, double lambda) {
        this.initialise(tg, qdef, qualityType, lambda, numberCommunities);
        this.name = SIMANNAME + this.quality.QdefinitionShortString();
        this.maxCommunities = Math.max(maxNumberCommunities, this.getNumberCommunities());
        this.infoLevel = newinfolevel;
        this.Rnd = new Random();
    }

    public SimulatedAnnealingvertexPartition(timgraph tg, int qdef, int qualityType, double lambda, int newinfolevel, int numberCommunities) {
        this.initialise(tg, qdef, qualityType, lambda, numberCommunities);
        this.name = SIMANNAME + this.quality.QdefinitionShortString();
        this.maxCommunities = numberCommunities < 2 ? this.numberElements : numberCommunities;
        this.infoLevel = newinfolevel;
        this.Rnd = new Random();
    }

    public void calculateRecursively(int numberOfSweeps, double betaInitial, boolean greedyAfterOneSweep) {
        this.calcQuality();
        this.calculateRecursively(0, numberOfSweeps, betaInitial, greedyAfterOneSweep);
    }

    private void calculateRecursively(int l, int numberOfSweeps, double betaInitial, boolean greedyAfterOneSweep) {
        this.level = l;
        if (this.infoLevel > 0) {
            System.out.println("--- recursion level " + this.level);
        }
        if (this.infoLevel > 2) {
            this.graph.printVertices(System.out, false, false, true);
        }
        if (this.infoLevel > 1) {
            this.graph.printEdges();
        }
        this.calculateBestGreedyCommunity(MAXSWEEPS);
        boolean ignoreNegativeLabels = true;
        this.relabelCommunities(ignoreNegativeLabels);
        this.calcQuality();
        if (this.infoLevel > 0) {
            System.out.println("Number vertices = " + this.graph.getNumberVertices() + ", number communities = " + this.getNumberOfCommunities() + ", quality = " + this.getQuality());
        }
        if (this.infoLevel > 1) {
            this.printCommunityMatrix(System.out, " ", " , ");
        }
        if (this.graph.getNumberVertices() > this.getNumberOfCommunities()) {
            timgraph projg = new timgraph(this.graph, this.communityOfElement, this.numberCommunities, false, false);
            SimulatedAnnealingvertexPartition projVP = new SimulatedAnnealingvertexPartition(projg, this.quality.Qdefinition, this.quality.getQualityTypeNumber(), this.quality.lambda, this.infoLevel, -1);
            projVP.calculateRecursively(l + 1, numberOfSweeps, betaInitial, greedyAfterOneSweep);
            if (projVP.getQuality() > this.getQuality()) {
                this.setQuality(projVP.getQuality());
                for (int s = 0; s < this.numberElements; ++s) {
                    this.communityOfElement[s] = projVP.getCommunity(this.communityOfElement[s]);
                }
            }
        }
    }

    public void calc(int numberOfSweeps, double betaInitial) {
        this.calc(numberOfSweeps, betaInitial, false);
    }

    public void calc(int numberOfSweeps, double betaInitial, boolean greedyAfterOneSweep) {
        this.bestcommunityOfElement = new int[this.numberElements];
        this.updateBestCommunity();
        this.bestQuality = this.quality.calc(this.bestcommunityOfElement);
        double beta = betaInitial;
        this.edgePerm = new Permutation(this.numberEdges);
        this.vertexPerm = new Permutation(this.numberElements);
        double totalQualityChange = 0.0;
        double invnumberElements = 1.0 / (double)this.numberElements;
        double updateFractionFinal = invnumberElements / 1.8;
        double betaInc1 = 1.0 + 1.0 / (double)this.numberElements;
        int NoChangeSweeps = 10;
        boolean keepGoing = true;
        double lastBestQuality = -9.7531E86;
        int countToStop = 10;
        System.out.println("Initial Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities());
        for (int n = 0; n < numberOfSweeps; ++n) {
            this.updateRecord = new UpdateRecord();
            totalQualityChange = this.oneEdgeSweep(beta, 10);
            double uf = this.updateRecord.getTotalFractionMade();
            if (this.bestQuality != lastBestQuality) {
                lastBestQuality = this.bestQuality;
                countToStop = 10;
            }
            if (this.infoLevel > 0) {
                System.out.println("beta = " + beta + " Sweep " + n + " count to stop " + countToStop + " Best Quality " + this.bestQuality + ", Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities() + ", Quality change " + totalQualityChange + ", % changed = " + uf);
            }
            if (--countToStop < 0) {
                if (!keepGoing) break;
                keepGoing = false;
            } else {
                keepGoing = true;
            }
            beta = uf > 0.5 ? (beta *= 2.0) : (beta *= betaInc1);
            if (!greedyAfterOneSweep) continue;
            this.selectBestCommunity();
            this.calculateBestGreedyCommunity(5);
        }
        if (!greedyAfterOneSweep) {
            this.selectBestCommunity();
            this.calculateBestGreedyCommunity(5);
        }
        boolean ignoreNegativeLabels = true;
        this.relabelCommunities(ignoreNegativeLabels);
        System.out.println("Final Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities() + ", greedy improvements " + this.greedyUpdateRecord.toString());
    }

    private double oneEdgeSweep(double beta, int iterations) {
        double totalQualityChange = 0.0;
        double bestQualityChange = 0.0;
        int oldCommunity = -1;
        int updateTried = 0;
        int updateMade = 0;
        int s = -1;
        int t = -1;
        double deltaQ = 0.0;
        int cnew = -1;
        int e = -1;
        for (int i = 0; i < iterations; ++i) {
            updateTried = 0;
            updateMade = 0;
            this.edgePerm.newPermutation();
            while (this.edgePerm.hasMore()) {
                ++updateTried;
                e = this.edgePerm.next();
                s = this.graph.getVertexFromEdge(e);
                oldCommunity = this.communityOfElement[s];
                while ((cnew = this.Rnd.nextInt(this.maxCommunities)) == oldCommunity) {
                }
                deltaQ = this.quality.delta(s, cnew, this.communityOfElement) - this.quality.delta(s, oldCommunity, this.communityOfElement);
                if (!(deltaQ > 0.0) && !(Math.exp(beta * deltaQ) > this.Rnd.nextDouble())) continue;
                totalQualityChange += deltaQ;
                this.communityOfElement[s] = cnew;
                if (totalQualityChange > bestQualityChange) {
                    this.updateBestCommunity();
                    bestQualityChange = totalQualityChange;
                }
                ++updateMade;
            }
            if (updateTried >= updateMade * 2) continue;
        }
        this.updateRecord.update(updateTried, updateMade);
        this.selectBestCurrentCommunity();
        return totalQualityChange;
    }

    private double oneVertexSweep(double beta) {
        double totalQualityChange = 0.0;
        double bestQualityChange = 0.0;
        int updateTried = 0;
        int updateMade = 0;
        int oldCommunity = -1;
        this.vertexPerm.newPermutation();
        int s = -1;
        double deltaQ = 0.0;
        while (this.vertexPerm.hasMore()) {
            ++updateTried;
            s = this.vertexPerm.next();
            deltaQ = -this.quality.delta(s, oldCommunity = this.communityOfElement[s], this.communityOfElement);
            if (!(deltaQ > 0.0) && !(Math.exp(beta * deltaQ) > this.Rnd.nextDouble())) continue;
            totalQualityChange += deltaQ;
            this.communityOfElement[s] = this.getEmptyCommunity();
            if (totalQualityChange > bestQualityChange) {
                this.updateBestCommunity();
                bestQualityChange = totalQualityChange;
            }
            ++updateMade;
        }
        this.updateRecord.update(updateTried, updateMade);
        this.selectBestCurrentCommunity();
        return totalQualityChange;
    }

    private void selectBestCurrentCommunity() {
        this.recalculateCommunityLabels();
        double currentQuality = this.quality.calc(this.communityOfElement);
        if (this.bestQuality > currentQuality) {
            currentQuality = this.bestQuality;
            for (int s = 0; s < this.numberElements; ++s) {
                this.communityOfElement[s] = this.bestcommunityOfElement[s];
            }
        } else {
            this.bestQuality = currentQuality;
            this.updateBestCommunity();
        }
    }

    private void selectBestCommunity() {
        this.recalculateCommunityLabels();
        double currentQuality = this.quality.calc(this.communityOfElement);
        if (this.bestQuality > currentQuality) {
            for (int s = 0; s < this.numberElements; ++s) {
                this.bestcommunityOfElement[s] = this.communityOfElement[s];
            }
        }
    }

    private void updateBestCommunity() {
        for (int s = 0; s < this.numberElements; ++s) {
            this.bestcommunityOfElement[s] = this.communityOfElement[s];
        }
    }
}

