/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.Quality;
import TimGraph.Community.QualityMinimalMemory;
import TimGraph.Community.QualitySparse;
import TimGraph.timgraph;
import TimUtilities.GeneralMode;

public class QualityType
extends GeneralMode {
    public static final String[] qualityName = new String[]{"DM", "SM", "MM"};
    public static final String[] qualityLongName = new String[]{"Basic Dense Matrix", "Sparse Matrix", "Minimal Memory"};

    public QualityType(String name) {
        this.setUniqueNameLength(2);
        this.setUp(qualityName, qualityLongName, name);
    }

    static Quality makeQuality(timgraph tg, int qdef, int qualityType, double newlambda, int infoLevel) {
        switch (qualityType) {
            case 1: {
                return new QualitySparse(tg, qdef, newlambda, infoLevel);
            }
            case 2: {
                return new QualityMinimalMemory(tg, qdef, newlambda, infoLevel);
            }
        }
        return new Quality(tg, qdef, newlambda, infoLevel);
    }
}

