/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.AdjacencyMatrix;
import TimGraph.Community.Quality;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;

public class QualitySparse
extends Quality {
    static final QualityType sparseType = new QualityType("SM");
    AdjacencyMatrix AMatrix;

    public QualitySparse(timgraph graph, int qdef, double newlambda, int infoLevelNew) {
        this.initialisePreAdjacencyMatrix(graph, qdef, newlambda, infoLevelNew);
        this.initialiseAdjacencyMatrix(graph);
        if (this.infoLevel > 0) {
            this.AMatrix.check();
        }
        if (this.infoLevel > 0) {
            this.AMatrix.printMatrix(" ", true);
        }
        if (this.infoLevel > 0) {
            System.out.println("Check Quality Matrix = " + this.check());
        }
    }

    @Override
    public void initialiseAdjacencyMatrix(timgraph graph) {
        this.AMatrix = new AdjacencyMatrix(graph, this.Qdefinition);
        this.numberVertices = this.AMatrix.dimension();
        this.AMatrix.calculateInOutVectors();
        if (this.nullModelSwitch == 4) {
            this.AMatrix.calculatePiVector();
        }
        if (this.infoLevel > 0) {
            System.out.println("Total Weight = " + this.AMatrix.totalWeight());
        }
    }

    @Override
    public double get(int s, int t) {
        double nullModelValue = -1.0;
        double nullModelNorm = this.nullModelSwitch == 4 ? 1.0 : this.AMatrix.totalWeight() * this.AMatrix.totalWeight();
        switch (this.nullModelSwitch) {
            case 4: {
                nullModelValue = this.AMatrix.getNormalisedPi(s) * this.AMatrix.getNormalisedPi(t);
                break;
            }
            case 3: {
                nullModelValue = this.AMatrix.getInStrength(s) * this.AMatrix.getInStrength(t) / nullModelNorm;
                break;
            }
            case 2: {
                nullModelValue = this.AMatrix.getOutStrength(s) * this.AMatrix.getInStrength(t) / nullModelNorm;
                break;
            }
            case 1: {
                nullModelValue = this.AMatrix.getInStrength(s) * this.AMatrix.getOutStrength(t) / nullModelNorm;
                break;
            }
            default: {
                nullModelValue = this.AMatrix.getOutStrength(s) * this.AMatrix.getOutStrength(t) / nullModelNorm;
            }
        }
        return (this.AMatrix.get(s, t) / this.AMatrix.totalWeight() - this.lambda * nullModelValue) / this.AMatrix.totalWeight();
    }

    @Override
    protected void setQualityType() {
        this.qualityType = sparseType;
    }
}

