/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.Quality;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;

public class QualityMinimalMemory
extends Quality {
    static final QualityType minimalMemoryType = new QualityType("MM");
    timgraph graph;

    public QualityMinimalMemory(timgraph graph, int qdef, double newlambda, int infoLevelNew) {
        this.graph = graph;
        this.initialisePreAdjacencyMatrix(graph, qdef, newlambda, infoLevelNew);
        this.numberVertices = graph.getNumberVertices();
    }

    @Override
    public void initialiseAdjacencyMatrix(timgraph graph) {
    }

    @Override
    public double get(int s, int t) {
        if (this.Qdefinition == 0) {
            double nullModelNorm = this.nullModelSwitch == 4 ? 1.0 : this.graph.getTotalWeight() * this.graph.getTotalWeight();
            double nullModelValue = -1.0;
            switch (this.nullModelSwitch) {
                case 4: {
                    throw new RuntimeException("No Pi vector calculation available in QualityMinimalMemory");
                }
                case 3: {
                    nullModelValue = this.graph.getVertexInStrength(s) * this.graph.getVertexInStrength(t) / nullModelNorm;
                    break;
                }
                case 2: {
                    nullModelValue = this.graph.getVertexInStrength(s) * this.graph.getVertexInStrength(t) / nullModelNorm;
                    break;
                }
                case 1: {
                    nullModelValue = this.graph.getVertexOutStrength(s) * this.graph.getVertexOutStrength(t) / nullModelNorm;
                    break;
                }
                default: {
                    nullModelValue = this.graph.getVertexOutStrength(s) * this.graph.getVertexOutStrength(t) / nullModelNorm;
                }
            }
            return this.graph.getAdjacencyMatrixEntry(s, t) / this.graph.getTotalWeight() - this.lambda * nullModelValue;
        }
        throw new RuntimeException("*** ERROR QualityMinimalMemory not defined for " + Quality.QdefinitionString[this.Qdefinition]);
    }

    @Override
    protected void setQualityType() {
        this.qualityType = minimalMemoryType;
    }
}

