/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.AdjacencyMatrix;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;
import java.io.PrintStream;

public class QualityLineGraph {
    static final QualityType basicType = new QualityType("DM");
    protected double[][] QMatrix;
    protected int numberVertices;
    protected int Qdefinition = -124578;
    protected QualityType qualityType;
    protected double lambda = -985421.0;
    public static final String[] QdefinitionString = new String[]{"Basic Newman", "(A^2-A)"};
    public static final String[] QdefinitionShortString = new String[]{"QS", "QA2mA"};
    public static final int QSindex = 0;
    public static final int QA2mAindex = 1;
    public int infoLevel = 0;

    public QualityLineGraph() {
        this.setQualityType();
    }

    public QualityLineGraph(timgraph graph, int qdef, double newlambda, int infoLevelNew) {
        this.infoLevel = infoLevelNew;
        this.setQualityType();
        this.Qdefinition = qdef;
        this.setNullModelScaling(newlambda);
        this.initialiseAdjacencyMatrix(graph);
    }

    public void initialiseAdjacencyMatrix(timgraph graph) {
        AdjacencyMatrix AMatrix = new AdjacencyMatrix(graph, this.Qdefinition);
        this.numberVertices = AMatrix.dimension();
        AMatrix.calculateInOutVectors();
        this.QMatrix = new double[this.numberVertices][this.numberVertices];
        if (this.infoLevel > 0) {
            System.out.println("Total Weight = " + AMatrix.totalWeight());
        }
        for (int s = 0; s < this.numberVertices; ++s) {
            for (int t = 0; t < this.numberVertices; ++t) {
                this.QMatrix[s][t] = (AMatrix.get(s, t) - this.lambda * AMatrix.getInStrength(s) * AMatrix.getOutStrength(t) / AMatrix.totalWeight()) / AMatrix.totalWeight();
            }
        }
    }

    public double check() {
        double total = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            for (int t = 0; t < this.numberVertices; ++t) {
                total += this.get(s, t);
            }
        }
        return total;
    }

    public double get(int s, int t) {
        return this.QMatrix[s][t];
    }

    public double delta(int s, int c, int[] communityOfVertex) {
        double deltaQ = 0.0;
        for (int t = 0; t < this.numberVertices; ++t) {
            if (communityOfVertex[t] != c || s == t) continue;
            deltaQ += this.get(s, t) + this.get(t, s);
        }
        return deltaQ;
    }

    public double calc(double[][] communityMatrix, int numberCommunities) {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            for (int t = 0; t < this.numberVertices; ++t) {
                for (int c = 0; c < numberCommunities; ++c) {
                    Q += this.get(s, t) * communityMatrix[s][c] * communityMatrix[t][c];
                }
            }
        }
        return Q;
    }

    public double calc(int[] communityOfVertex) {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            int c = communityOfVertex[s];
            for (int t = 0; t < this.numberVertices; ++t) {
                if (communityOfVertex[t] != c) continue;
                Q += this.get(s, t);
            }
        }
        return Q;
    }

    public double calcNoTadpoles(int[] communityOfVertex) {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            int c = communityOfVertex[s];
            for (int t = 0; t < this.numberVertices; ++t) {
                if (communityOfVertex[t] != c || s == t) continue;
                Q += this.get(s, t);
            }
        }
        return Q;
    }

    public double calcTrace() {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            Q += this.get(s, s);
        }
        return Q;
    }

    public double getNullModelScaling() {
        return this.lambda;
    }

    public void setNullModelScaling(double newLambda) {
        this.lambda = newLambda;
    }

    protected void setQualityType() {
        this.qualityType = basicType;
    }

    public String getQualityTypeDescription() {
        return this.qualityType.toLongString();
    }

    public int getQualityTypeNumber() {
        return this.qualityType.getNumber();
    }

    public String Qdefinition(String sep) {
        if (this.lambda == 1.0) {
            return QualitySparse.QdefinitionString[this.Qdefinition];
        }
        return QualitySparse.QdefinitionString[this.Qdefinition] + sep + "lambda=" + this.lambda;
    }

    public String Qdefinition() {
        return this.Qdefinition("_");
    }

    public String QdefinitionShortString() {
        if (this.lambda == 1.0) {
            return QualitySparse.QdefinitionShortString[this.Qdefinition];
        }
        int l = (int)(this.lambda * 1000.0);
        return QualitySparse.QdefinitionShortString[this.Qdefinition] + l;
    }

    public void printMatrix(PrintStream PS, String sep, boolean labelsOn) {
        int s;
        if (labelsOn) {
            PS.print("[s]/[t]");
            for (s = 0; s < this.numberVertices; ++s) {
                PS.print(sep + s);
            }
            PS.println();
        }
        for (s = 0; s < this.numberVertices; ++s) {
            if (labelsOn) {
                PS.print(s);
            }
            for (int t = 0; t < this.numberVertices; ++t) {
                PS.print(sep + this.get(s, t));
            }
            PS.println();
        }
    }
}

