/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.AdjacencyMatrix;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import java.io.PrintStream;

public class Quality {
    static final QualityType basicType = new QualityType("DM");
    protected DoubleMatrix2D QMatrix;
    protected int numberVertices;
    protected int Qdefinition = -124578;
    protected QualityType qualityType;
    protected boolean equilibrium = true;
    protected int nullModelSwitch = 0;
    public static final String[] nullModelString = new String[]{"in-in", "in-out", "out-in", "out-out", "Pi-Pi"};
    protected double lambda = -985421.0;
    public static final String[] QdefinitionString = new String[]{"Basic Newman", "(A^2-A)"};
    public static final String[] QdefinitionShortString = new String[]{"QS", "QA2mA"};
    public static final int QSindex = 0;
    public static final int QA2mAindex = 1;
    public int infoLevel = 0;

    public Quality() {
        this.setQualityType();
    }

    public Quality(timgraph graph, int qdef, double newlambda, int infoLevelNew) {
        this.initialisePreAdjacencyMatrix(graph, qdef, newlambda, infoLevelNew);
        this.initialiseAdjacencyMatrix(graph);
        if (this.infoLevel > 0) {
            System.out.println("Check Quality Matrix = " + this.check());
        }
    }

    public void initialisePreAdjacencyMatrix(timgraph graph, int qdef, double newlambda, int infoLevelNew) {
        this.infoLevel = infoLevelNew;
        this.setQualityType();
        this.Qdefinition = qdef;
        this.setNullModelScaling(newlambda);
        this.nullModelSwitch = graph.isDirected() ? 4 : 0;
    }

    public void initialiseAdjacencyMatrix(timgraph graph) {
        AdjacencyMatrix AMatrix = new AdjacencyMatrix(graph, this.Qdefinition);
        this.numberVertices = AMatrix.dimension();
        AMatrix.calculateInOutVectors();
        if (this.nullModelSwitch == 4) {
            AMatrix.calculatePiVector();
        }
        this.QMatrix = new SparseDoubleMatrix2D(this.numberVertices, this.numberVertices);
        if (this.infoLevel > 0) {
            System.out.println("Total Weight = " + AMatrix.totalWeight());
        }
        double nullValue = -1.0;
        double v = -1.0;
        double nullModelNorm = this.nullModelSwitch == 4 ? 1.0 : AMatrix.totalWeight() * AMatrix.totalWeight();
        for (int s = 0; s < this.numberVertices; ++s) {
            for (int t = 0; t < this.numberVertices; ++t) {
                switch (this.nullModelSwitch) {
                    case 4: {
                        nullValue = AMatrix.getNormalisedPi(s) * AMatrix.getNormalisedPi(t);
                        break;
                    }
                    case 3: {
                        nullValue = AMatrix.getInStrength(s) * AMatrix.getInStrength(t) / nullModelNorm;
                        break;
                    }
                    case 2: {
                        nullValue = AMatrix.getOutStrength(s) * AMatrix.getInStrength(t) / nullModelNorm;
                        break;
                    }
                    case 1: {
                        nullValue = AMatrix.getInStrength(s) * AMatrix.getOutStrength(t) / nullModelNorm;
                        break;
                    }
                    default: {
                        nullValue = AMatrix.getOutStrength(s) * AMatrix.getOutStrength(t) / nullModelNorm;
                    }
                }
                v = AMatrix.get(s, t) / AMatrix.totalWeight() - this.lambda * nullValue;
                this.QMatrix.set(s, t, v);
            }
        }
    }

    public double check() {
        double total = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            for (int t = 0; t < this.numberVertices; ++t) {
                total += this.get(s, t);
            }
        }
        return total;
    }

    public double get(int s, int t) {
        return this.QMatrix.get(s, t);
    }

    public double getLambda() {
        return this.lambda;
    }

    public double delta(int s, int c, int[] communityOfVertex) {
        double deltaQ = 0.0;
        for (int t = 0; t < this.numberVertices; ++t) {
            if (communityOfVertex[t] != c || s == t) continue;
            deltaQ += this.get(s, t) + this.get(t, s);
        }
        return deltaQ;
    }

    public double calc(double[][] communityMatrix, int numberCommunities) {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            for (int t = 0; t < this.numberVertices; ++t) {
                for (int c = 0; c < numberCommunities; ++c) {
                    Q += this.get(s, t) * communityMatrix[s][c] * communityMatrix[t][c];
                }
            }
        }
        return Q;
    }

    public double calc(DoubleMatrix2D communityMatrix, int numberCommunities) {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            for (int t = 0; t < this.numberVertices; ++t) {
                for (int c = 0; c < numberCommunities; ++c) {
                    Q += this.get(s, t) * communityMatrix.get(s, c) * communityMatrix.get(t, c);
                }
            }
        }
        return Q;
    }

    public double calc(int[] communityOfVertex) {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            int c = communityOfVertex[s];
            for (int t = 0; t < this.numberVertices; ++t) {
                if (communityOfVertex[t] != c) continue;
                Q += this.get(s, t);
            }
        }
        return Q;
    }

    public double calcNoTadpoles(int[] communityOfVertex) {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            int c = communityOfVertex[s];
            for (int t = 0; t < this.numberVertices; ++t) {
                if (communityOfVertex[t] != c || s == t) continue;
                Q += this.get(s, t);
            }
        }
        return Q;
    }

    public double calcTrace() {
        double Q = 0.0;
        for (int s = 0; s < this.numberVertices; ++s) {
            Q += this.get(s, s);
        }
        return Q;
    }

    public double getNullModelScaling() {
        return this.lambda;
    }

    public void setNullModelScaling(double newLambda) {
        this.lambda = newLambda;
    }

    public void setNullModelSwitch(int newNullModelSwitch) {
        if (newNullModelSwitch < 0 || newNullModelSwitch >= nullModelString.length) {
            System.err.println("!!! null model unchanged, model number " + newNullModelSwitch + " invalid, must be between 0 and " + nullModelString.length);
        }
        this.nullModelSwitch = newNullModelSwitch;
    }

    public int getNullModelSwitch() {
        return this.nullModelSwitch;
    }

    public String getNullModelDescription() {
        return nullModelString[this.nullModelSwitch];
    }

    protected void setQualityType() {
        this.qualityType = basicType;
    }

    public String getQualityTypeDescription() {
        return this.qualityType.toLongString();
    }

    public int getQualityTypeNumber() {
        return this.qualityType.getNumber();
    }

    public String Qdefinition(String sep) {
        if (this.lambda == 1.0) {
            return QualitySparse.QdefinitionString[this.Qdefinition];
        }
        return QualitySparse.QdefinitionString[this.Qdefinition] + sep + this.getNullModelDescription() + sep + "lambda=" + this.lambda;
    }

    public String Qdefinition() {
        return this.Qdefinition("_");
    }

    public String QdefinitionShortString() {
        long l = Math.round(this.lambda * 1000.0);
        return QualitySparse.QdefinitionShortString[this.Qdefinition] + this.getNullModelDescription() + l;
    }

    public void printMatrixOLD(PrintStream PS, String sep, boolean labelsOn) {
        int s;
        if (labelsOn) {
            PS.print("[s]/[t]");
            for (s = 0; s < this.numberVertices; ++s) {
                PS.print(sep + s);
            }
            PS.println();
        }
        for (s = 0; s < this.numberVertices; ++s) {
            if (labelsOn) {
                PS.print(s);
            }
            for (int t = 0; t < this.numberVertices; ++t) {
                PS.print(sep + this.get(s, t));
            }
            PS.println();
        }
    }

    public void printMatrix(PrintStream PS, String sep, boolean headersOn) {
        String doubleFormat = "%6.3f";
        String intFormat = "%6d";
        if (headersOn) {
            PS.print("      " + sep);
            for (int j = 0; j < this.numberVertices; ++j) {
                PS.print(String.format(intFormat, j) + sep);
            }
            PS.println();
        }
        for (int i = 0; i < this.numberVertices; ++i) {
            if (headersOn) {
                PS.print(String.format(intFormat, i) + sep);
            }
            for (int j = 0; j < this.numberVertices; ++j) {
                PS.print(String.format(doubleFormat, this.get(i, j)) + sep);
            }
            PS.println();
        }
    }
}

