/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import DataAnalysis.IntegerSequence;
import TimGraph.Community.Community;
import TimGraph.io.FileInput;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;

public class Partition
extends Community {
    private Random Rnd = new Random();
    protected int[] communityOfElement;
    protected int nextCommunityLabel = -987123456;
    protected TreeSet<Integer> communityLabels;
    int[] localLabel;
    boolean statisticsCalculated = false;
    protected int[] numberElementsArray;
    protected IntegerSequence communityStatistics;

    public Partition() {
        this.name = "generalP";
    }

    public Partition(int nv) {
        this.name = "generalP";
        this.numberElements = nv;
        this.communityOfElement = new int[this.numberElements];
    }

    public Partition(String newname, int nv) {
        this.name = newname;
        this.numberElements = nv;
        this.communityOfElement = new int[this.numberElements];
    }

    public Partition(double q, int n, int[] cov) {
        this.name = "generalP" + this.quality.QdefinitionShortString();
        this.Q = q;
        this.numberElements = n;
        this.communityOfElement = new int[this.numberElements];
        this.setCommunity(cov);
    }

    protected void setNumberElements(int n) {
        this.numberElements = n;
        this.communityOfElement = new int[this.numberElements];
    }

    public void individualCommunity() {
        this.communityLabels = new TreeSet();
        this.communityOfElement = new int[this.numberElements];
        for (int s = 0; s < this.numberElements; ++s) {
            this.communityOfElement[s] = s;
            this.communityLabels.add(s);
        }
        this.nextCommunityLabel = this.numberElements;
        this.statisticsCalculated = false;
        this.numberCommunities = this.numberElements;
    }

    public void setCommunity(int n) {
        boolean unique = false;
        boolean random = false;
        if (n < 0) {
            unique = true;
        } else if (n > 1) {
            random = true;
        }
        this.communityLabels = new TreeSet();
        this.communityOfElement = new int[this.numberElements];
        int c = 0;
        for (int s = 0; s < this.numberElements; ++s) {
            if (random) {
                c = this.Rnd.nextInt(n);
            }
            if (unique) {
                c = s;
            }
            this.communityOfElement[s] = c;
            this.communityLabels.add(c);
        }
        this.nextCommunityLabel = this.communityLabels.last() + 1;
        this.statisticsCalculated = false;
        this.numberCommunities = this.communityLabels.size();
    }

    public void oneCommunity() {
        this.communityLabels = new TreeSet();
        this.communityOfElement = new int[this.numberElements];
        this.communityLabels.add(0);
        for (int s = 0; s < this.numberElements; ++s) {
            this.communityOfElement[s] = 0;
        }
        this.nextCommunityLabel = this.numberElements;
        this.statisticsCalculated = false;
        this.numberCommunities = 0;
    }

    public int hasNegativeCommunityLabels() {
        for (int s = 0; s < this.numberElements; ++s) {
            if (this.communityOfElement[s] >= 0) continue;
            return s;
        }
        return -1;
    }

    public void relabelCommunities(boolean ignoreNegativeLabels) {
        TreeMap<Integer, Integer> cl2pg = new TreeMap<Integer, Integer>();
        this.communityLabels = new TreeSet();
        int cs = -1;
        Integer nl = cs;
        int newCommunityLabel = 0;
        for (int s = 0; s < this.numberElements; ++s) {
            cs = this.communityOfElement[s];
            if (ignoreNegativeLabels && cs < 0) continue;
            nl = (Integer)cl2pg.get(cs);
            if (nl == null) {
                nl = newCommunityLabel++;
                cl2pg.put(cs, nl);
                this.communityLabels.add(nl);
            }
            this.communityOfElement[s] = nl;
        }
        this.numberCommunities = newCommunityLabel;
    }

    public int recalculateCommunityLabels() {
        this.communityLabels = new TreeSet();
        for (int s = 0; s < this.numberElements; ++s) {
            int c = this.communityOfElement[s];
            if (c < 0) continue;
            this.communityLabels.add(c);
        }
        this.numberCommunities = this.communityLabels.size();
        return this.numberCommunities;
    }

    @Override
    public double calcQuality() {
        this.Q = this.quality.calc(this.communityOfElement);
        return this.Q;
    }

    public double delta(int s, int c) {
        return this.quality.delta(s, c, this.communityOfElement);
    }

    public int getNumberElementsInCommunityFast(int c) {
        return this.numberElementsArray[c];
    }

    public int getNumberElementsInCommunity(int c) {
        if (this.numberElementsArray == null) {
            this.analyse();
        }
        return this.numberElementsArray[c];
    }

    public int getNumberOfCommunities() {
        if (this.numberCommunities < 1) {
            this.recalculateCommunityLabels();
        }
        return this.numberCommunities;
    }

    public int getEmptyCommunity() {
        return this.nextCommunityLabel++;
    }

    public int[] getCommunity() {
        return this.communityOfElement;
    }

    public int getCommunity(int v) {
        return this.communityOfElement[v];
    }

    public int getCommunitySize(int v) {
        return this.getNumberElementsInCommunity(this.communityOfElement[v]);
    }

    @Override
    public double getCommunityMembership(int e, int c) {
        return this.communityOfElement[e] == c ? 1 : 0;
    }

    public void setCommunity(int[] cov) {
        for (int s = 0; s < this.numberElements; ++s) {
            this.communityOfElement[s] = cov[s];
        }
    }

    public void setCommunity(int s, int c) {
        this.communityOfElement[s] = c;
    }

    public void setCommunityLocalLabel() {
        int[] nextLocalLabel = new int[this.numberCommunities];
        this.localLabel = new int[this.numberElements];
        for (int e = 0; e < this.numberElements; ++e) {
            int c;
            int n = c = this.communityOfElement[e];
            nextLocalLabel[n] = nextLocalLabel[n] + 1;
        }
    }

    public int getCommunityLocalLabel(int e) {
        return this.localLabel[e];
    }

    public IntegerSequence calculateCommunityStatistics() {
        int maxmu = 3;
        int maxF = 3;
        int cm = 7;
        if (this.numberElementsArray == null) {
            this.analyse();
        }
        this.communityStatistics = new IntegerSequence(maxmu, maxF, cm);
        this.communityStatistics.calcStats(this.numberElementsArray);
        return this.communityStatistics;
    }

    public IntegerSequence getCommunityStatistics() {
        return this.communityStatistics;
    }

    public double getEntropy() {
        if (this.communityStatistics == null) {
            this.calculateCommunityStatistics();
        }
        return this.communityStatistics.getEntropy();
    }

    public double getF2() {
        if (this.communityStatistics == null) {
            this.calculateCommunityStatistics();
        }
        return this.communityStatistics.getF(2);
    }

    public boolean setNumberCommunities() {
        this.numberCommunities = -1;
        int sc = -1;
        boolean fail = false;
        for (int s = 0; s < this.numberElements; ++s) {
            sc = this.communityOfElement[s];
            if (this.numberCommunities < sc) {
                this.numberCommunities = sc;
            }
            if (sc >= 0) continue;
            fail = true;
        }
        ++this.numberCommunities;
        return fail;
    }

    public void analyse() {
        int sc = -1;
        this.numberElementsArray = new int[this.numberCommunities];
        for (int s = 0; s < this.numberElements; ++s) {
            int n = sc = this.communityOfElement[s];
            this.numberElementsArray[n] = this.numberElementsArray[n] + 1;
        }
    }

    public void printStatistics(PrintStream PS, String cc, String sep, boolean infoOn, boolean headerOn) {
        this.analyse();
        if (infoOn) {
            PS.println(cc + "Number of " + this.nameOfElements + sep + this.numberElements + sep + "Number of Communities" + sep + this.numberCommunities);
            if (this.communityStatistics == null) {
                this.calculateCommunityStatistics();
            }
            PS.println(this.communityStatistics.labelString(sep));
            PS.println(this.communityStatistics.toString(sep));
        }
        if (headerOn) {
            PS.print(cc + "Community" + sep + "N_C");
        }
        for (int c = 0; c < this.numberCommunities; ++c) {
            PS.println(c + sep + this.numberElementsArray[c]);
        }
    }

    public int readPajekPartition(String filename, boolean relabelOn) {
        String commentLine = "*";
        int columnIndex = -1;
        int columnLabel = 1;
        boolean headerOn = true;
        return this.readIntPartition(filename, columnIndex, columnLabel, headerOn, commentLine, relabelOn);
    }

    public int readIntPartition(String filename, int columnIndex, int columnLabel, boolean headerOn, boolean relabelOn) {
        String commentLine = "";
        return this.readIntPartition(filename, columnIndex, columnLabel, headerOn, commentLine, relabelOn);
    }

    public int readIntPartition(String filename, int columnIndex, int columnLabel, boolean headerOn, String commentLine, boolean relabelOn) {
        ArrayList<Integer> indexL = new ArrayList<Integer>();
        ArrayList<Integer> labelL = new ArrayList<Integer>();
        FileInput.readIntIndexLabelList(filename, columnIndex, columnLabel, indexL, labelL, headerOn, commentLine, this.infoLevel);
        if (indexL.size() != labelL.size()) {
            System.err.println("Two lists have different sizes");
            return -1;
        }
        if (this.communityOfElement == null || this.communityOfElement.length != indexL.size()) {
            System.out.println("!!! Number of elements is being reset to number found " + indexL.size());
            this.numberElements = indexL.size();
            this.communityOfElement = new int[this.numberElements];
        }
        Iterator<Integer> ii = indexL.iterator();
        Iterator<Integer> il = labelL.iterator();
        int index = -1;
        int label = -1;
        int maxLabel = -1;
        while (ii.hasNext()) {
            index = ii.next();
            if (index < 0 || index >= this.communityOfElement.length) {
                throw new RuntimeException("In index of element incorrect, value was " + index);
            }
            label = il.next();
            this.setCommunity(index, label);
            if (label <= maxLabel) continue;
            maxLabel = label;
        }
        this.numberCommunities = maxLabel + 1;
        boolean ignoreNegativeLabels = false;
        if (relabelOn) {
            this.relabelCommunities(ignoreNegativeLabels);
        }
        return indexL.size();
    }

    public int readStringPartition(String filename, int columnIndex, int columnLabel, boolean headerOn) {
        FileInput fi = new FileInput(this.infoLevel);
        ArrayList<String> indexL = new ArrayList<String>();
        ArrayList<String> labelL = new ArrayList<String>();
        fi.readStringIndexLabelList(filename, columnIndex, columnLabel, indexL, labelL, true);
        if (indexL.size() != labelL.size()) {
            System.err.println("Two lists have different sizes");
            return -1;
        }
        Iterator<String> ii = indexL.iterator();
        Iterator<String> il = labelL.iterator();
        TreeMap<String, Integer> cl2pg = new TreeMap<String, Integer>();
        this.communityLabels = new TreeSet();
        int index = -1;
        String label = "";
        Integer nl = -1;
        int newCommunityLabel = 0;
        while (ii.hasNext()) {
            index = Integer.parseInt(ii.next());
            if (index < 0 || index >= this.communityOfElement.length) {
                throw new RuntimeException("In index of element incorrect, value was " + index);
            }
            label = il.next();
            nl = (Integer)cl2pg.get(label);
            if (nl == null) {
                nl = newCommunityLabel++;
                cl2pg.put(label, nl);
                this.communityLabels.add(nl);
            }
            this.communityOfElement[index] = nl;
        }
        this.numberCommunities = newCommunityLabel;
        return indexL.size();
    }

    @Override
    public void printCommunityBipartiteGraph(PrintStream PS, String cc, String sep, boolean headerOn, boolean ElementLabelsOn) {
        if (headerOn) {
            PS.println(cc + "Number of " + this.nameOfElements + sep + this.numberElements + sep + "Number of Communities" + sep + this.numberCommunities);
            PS.print(cc);
            if (ElementLabelsOn) {
                PS.print(this.nameOfElements + sep);
            }
            PS.println("Label");
        }
        for (int s = 0; s < this.numberElements; ++s) {
            PS.print(cc);
            if (ElementLabelsOn) {
                PS.print(s + sep);
            }
            PS.println(this.communityOfElement[s]);
        }
    }
}

