/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.VertexPartition;
import TimGraph.algorithms.Projections;
import TimGraph.timgraph;

public class LouvainVertexPartition
extends VertexPartition {
    private static int MAXSWEEPS = 100;
    private int level = -987123456;

    public LouvainVertexPartition(timgraph tg, int qdef, int qualityType, int infolevel) {
        this.initialise(tg, qdef, qualityType, true);
        this.infoLevel = infolevel;
        this.name = "Louvain" + this.quality.QdefinitionShortString();
    }

    public LouvainVertexPartition(timgraph tg, int qdef, int qualityType, double lambda, int infolevel, int maxNumberCommunities) {
        this.infoLevel = infolevel;
        this.initialise(tg, qdef, qualityType, lambda, maxNumberCommunities);
        this.name = "Louvain" + this.quality.QdefinitionShortString();
    }

    public void calculate() {
        this.calcQuality();
        this.calculate(0);
    }

    private void calculate(int l) {
        this.level = l;
        if (this.infoLevel > 0) {
            System.out.println("--- recursion level " + this.level);
        }
        if (this.infoLevel > 2) {
            this.graph.printVertices(System.out, true, true, true);
        }
        if (this.infoLevel > 1) {
            this.graph.printEdges();
        }
        this.calculateBestGreedyCommunity(MAXSWEEPS);
        boolean ignoreNegativeLabels = false;
        this.relabelCommunities(ignoreNegativeLabels);
        this.calcQuality();
        if (this.infoLevel > 0) {
            System.out.println("Number vertices = " + this.graph.getNumberVertices() + ", number communities = " + this.getNumberOfCommunities() + ", quality = " + this.getQuality());
        }
        if (this.infoLevel > 1) {
            this.printCommunityMatrix(System.out, " ", " , ");
        }
        if (this.graph.getNumberVertices() > this.getNumberOfCommunities()) {
            timgraph projg = Projections.ontoVertexPartition(this.graph.inputName.getNameRoot() + "!", this.graph, this.communityOfElement, this.numberCommunities, false, false);
            LouvainVertexPartition projLC = new LouvainVertexPartition(projg, this.quality.Qdefinition, this.quality.getQualityTypeNumber(), this.quality.lambda, this.infoLevel, -1);
            projLC.calculate(l + 1);
            if (projLC.getQuality() > this.getQuality()) {
                this.setQuality(projLC.getQuality());
                for (int s = 0; s < this.numberElements; ++s) {
                    this.communityOfElement[s] = projLC.getCommunity(this.communityOfElement[s]);
                }
            }
        }
    }
}

