/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.Partition;
import TimGraph.timgraph;
import TimUtilities.Permutation;
import TimUtilities.UpdateRecord;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;

public class EdgePartition
extends Partition {
    private Random Rnd = new Random();
    int verticessInEP = -1;
    private Permutation perm;
    protected UpdateRecord greedyUpdateRecord;

    public EdgePartition() {
        this.name = "generalEP";
    }

    public EdgePartition(timgraph tg) {
        this.name = "general";
        this.initialise(tg);
    }

    public EdgePartition(int n) {
        this.setDefaultNames();
        this.setNumberElements(n);
    }

    public EdgePartition(String newname, int n) {
        this.setDefaultNames();
        this.setNumberElements(n);
    }

    public EdgePartition(double q, int nv, int ne, int[] cov) {
        this.setDefaultNames();
        this.name = this.name + this.quality.QdefinitionShortString();
        this.Q = q;
        this.setNumberElements(ne);
        this.setCommunity(cov);
    }

    private void setDefaultNames() {
        this.name = "generalEP";
        this.nameOfElements = "edges";
    }

    public void initialise(timgraph tg) {
        this.initialise(tg, 0, 1, true);
    }

    public void initialise(timgraph tg, int qualityDefinition, int qualityType, boolean individualCommunities) {
        this.initialise(tg, qualityDefinition, qualityType, 1.0, individualCommunities ? 0 : -1);
    }

    public void initialise(timgraph tg, int qualityDefinition, int qualityType, int maxNumberCommunities) {
        this.initialise(tg, qualityDefinition, qualityType, 1.0, maxNumberCommunities);
    }

    public void initialise(timgraph tg, int qualityDefinition, int qualityType, double lambda, int maxNumberCommunities) {
        this.initialiseGraph(tg, qualityDefinition, qualityType, lambda);
        this.numberElements = this.graph.getNumberDistinctEdges();
        if (this.infoLevel > 1 && this.numberElements < 21) {
            this.quality.printMatrix(System.out, " ", true);
        }
        this.setCommunity(maxNumberCommunities);
        this.Q = -9.87123456E8;
    }

    public int calculateBestGreedyCommunity(int maxSweeps) {
        this.perm = new Permutation(this.numberElements);
        if (!this.graph.isVertexEdgeListOn()) {
            this.graph.createVertexGlobalEdgeList();
        }
        this.greedyUpdateRecord = new UpdateRecord();
        boolean printlevel = true;
        if (this.infoLevel > 1) {
            System.out.println("Initial Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities());
        }
        for (int n = 0; n < maxSweeps; ++n) {
            double totalQualityChange = this.oneGreedySweep();
            if (this.infoLevel > 1) {
                this.recalculateCommunityLabels();
                System.out.println("Greedy Sweep " + n + ", quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities() + ", Quality change " + totalQualityChange + ", " + this.greedyUpdateRecord.toString());
            }
            if (this.greedyUpdateRecord.getMade() == 0) break;
        }
        return this.greedyUpdateRecord.getMade();
    }

    private double oneGreedySweep() {
        double totalQualityChange = 0.0;
        int updateTried = 0;
        int updateMade = 0;
        double deltaQremove = 0.0;
        int oldCommunity = -1;
        this.perm.newPermutation();
        int e = -1;
        double deltaQ = 0.0;
        double deltaQmax = 0.0;
        int cmax = -1;
        for (int i = 0; i < this.graph.getNumberStubs(); ++i) {
            e = this.perm.next();
            int eglobal = this.graph.isDirected() ? e : e << 1;
            oldCommunity = this.communityOfElement[e];
            deltaQremove = -this.quality.delta(e, oldCommunity, this.communityOfElement);
            if (deltaQremove > 0.0) {
                cmax = -86421357;
                deltaQmax = deltaQremove;
            } else {
                deltaQmax = 0.0;
                cmax = oldCommunity;
            }
            TreeSet<Integer> nc = new TreeSet<Integer>();
            int elast = this.graph.isDirected() ? eglobal + 1 : eglobal + 2;
            for (int eg = eglobal; eg < elast; ++eg) {
                int v = this.graph.getVertexFromEdge(eg);
                int kout = this.graph.getVertexOutDegree(v);
                for (int e2 = 0; e2 < kout; ++e2) {
                    int enn = this.graph.getEdge(v, e2);
                    if (enn == e2) continue;
                    int cnn = this.communityOfElement[enn];
                    nc.add(cnn);
                }
            }
            if (nc.size() == 0) continue;
            Iterator citer = nc.iterator();
            int c = -1;
            while (citer.hasNext()) {
                c = (Integer)citer.next();
                if (c == oldCommunity) continue;
                System.out.println("*** THIS NEEDS TO BE CHANGED ***");
                throw new RuntimeException("*** THIS NEEDS TO BE CHANGED ***");
            }
            ++updateTried;
            if (cmax == oldCommunity) continue;
            totalQualityChange += deltaQmax;
            if (cmax == -86421357) {
                cmax = this.getEmptyCommunity();
            }
            this.communityOfElement[e] = cmax;
            ++updateMade;
        }
        this.greedyUpdateRecord.update(updateTried, updateMade);
        return totalQualityChange;
    }
}

