/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import DataAnalysis.MutualInformation;
import TimGraph.Community.Partition;
import TimGraph.Community.Quality;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import java.io.PrintStream;

public class Community {
    public static final int UNSET = -987123456;
    public static final double DUNSET = -9.7531E86;
    public static final int NEWCOMMUNITYLABEL = -86421357;
    public static final int NOCOMMUNITYLABEL = -789456123;
    public static final double TOLERANCE = 1.0E-6;
    protected String name = "general";
    protected int numberElements = -987123456;
    protected String nameOfElements = "elements";
    protected String[] elementName;
    public static final String verticesName = "vertices";
    public static final String edgesName = "edges";
    protected int numberCommunities = -987123456;
    protected String[] communityName;
    protected SparseDoubleMatrix2D communityMatrix;
    protected Quality quality;
    protected double Q = -9.87123456E8;
    protected timgraph graph;
    public int infoLevel = -2;

    public Community() {
    }

    public Community(timgraph tg, int qdef, double newlambda, int qualityType, int newInfoLevel) {
        this.infoLevel = newInfoLevel;
        this.initialiseGraph(tg, qdef, qualityType, newlambda);
    }

    public Community(String inputname) {
        this.name = inputname;
    }

    public Community(int nv) {
        this.numberElements = nv;
    }

    public Community(double q, int nv, int ne, int[] cov) {
        this.Q = q;
        this.numberElements = nv;
    }

    public Community(Partition p) {
        this.initialiseFromPartition(p);
    }

    public Community(timgraph tg, Partition p, int qdef, int qualityType, double newlambda) {
        this.initialiseGraph(tg, qdef, qualityType, newlambda);
    }

    public void initialiseGraph(timgraph tg, int qdef, int qualityType, double newlambda) {
        this.graph = tg;
        this.quality = QualityType.makeQuality(tg, qdef, qualityType, newlambda, this.infoLevel);
        this.Q = -9.87123456E8;
    }

    public String qualityType() {
        return this.quality.getQualityTypeDescription();
    }

    private void initialiseFromPartition(Partition p) {
        this.name = p.getName() + "partition";
        this.initialiseEmptyCommunity(p.getNumberElements(), p.getNumberOfCommunities());
        for (int v = 0; v < this.numberElements; ++v) {
            this.communityMatrix.set(v, p.getCommunity(v), 1.0);
        }
    }

    public void initialiseEmptyCommunity(int ne, int nc) {
        this.numberElements = ne;
        this.numberCommunities = nc;
        this.communityMatrix = new SparseDoubleMatrix2D(this.numberElements, this.numberCommunities);
    }

    public void initialiseElementNameList() {
        this.elementName = new String[this.numberElements];
    }

    public void initialiseCommunityNameList() {
        this.communityName = new String[this.numberCommunities];
    }

    public double calcQuality() {
        this.Q = this.quality.calc((DoubleMatrix2D)this.communityMatrix, this.numberCommunities);
        return this.Q;
    }

    public int getNumberCommunities() {
        return this.numberCommunities;
    }

    public int getNumberElements() {
        return this.numberElements;
    }

    public double getCommunityMembership(int e, int c) {
        return this.communityMatrix.get(e, c);
    }

    public void setCommunityMembership(int e, int c, double v) {
        this.communityMatrix.set(e, c, v);
    }

    public void increaseCommunityMembership(int e, int c, double v) {
        this.communityMatrix.set(e, c, v + this.communityMatrix.get(e, c));
    }

    public String getElementName(int e) {
        return this.elementName == null ? "e" + e : this.elementName[e];
    }

    public boolean hasElementName() {
        return this.elementName != null;
    }

    public void setElementName(int e, String name) {
        if (this.elementName == null) {
            this.initialiseElementNameList();
        }
        this.elementName[e] = name;
    }

    public String getCommunityName(int c) {
        return this.communityName == null ? "c" + c : this.communityName[c];
    }

    public boolean hasCommunityName() {
        return this.communityName != null;
    }

    public void setCommunityName(int c, String name) {
        if (this.communityName == null) {
            this.initialiseCommunityNameList();
        }
        this.communityName[c] = name;
    }

    public double getQuality() {
        if (this.Q == -9.87123456E8) {
            this.calcQuality();
        }
        return this.Q;
    }

    public void setQuality(double Qnew) {
        this.Q = Qnew;
    }

    public int checkMatrixNormalisation(double tolerance) {
        for (int v = 0; v < this.numberElements; ++v) {
            double sum = 0.0;
            for (int c = 0; c < this.numberCommunities; ++c) {
                sum += this.communityMatrix.get(v, c);
            }
            if (!(Math.abs(sum - 1.0) > tolerance)) continue;
            return v;
        }
        return -1;
    }

    public int normaliseMatrix(double tolerance) {
        double f = -1.0;
        for (int v = 0; v < this.numberElements; ++v) {
            int c;
            double sum = 0.0;
            for (c = 0; c < this.numberCommunities; ++c) {
                sum += this.communityMatrix.get(v, c);
            }
            if (sum < -tolerance) {
                return v;
            }
            for (c = 0; c < this.numberCommunities; ++c) {
                f = this.communityMatrix.get(v, c);
                if (f == 0.0) continue;
                this.communityMatrix.set(v, c, f / sum);
            }
        }
        return -1;
    }

    public void printInformation(PrintStream PS, String cc, String sep) {
        PS.println(cc + "Number of " + this.nameOfElements + sep + this.valueString(this.numberElements) + sep + "Quality (" + sep + (this.quality == null ? "???" : this.quality.Qdefinition(sep)) + ") " + sep + this.valueString(this.Q) + sep + "Number of Communities" + sep + this.valueString(this.numberCommunities));
    }

    public void printStats(PrintStream PS, String cc, String sep) {
        if (this.graph == null) {
            return;
        }
        System.out.println("VARIOUS STATISTICS");
        int maxCutoff = 5;
        double[] coverage = new double[maxCutoff];
        int[] elementCommunityNumber = new int[this.numberElements];
        int[] communityElementNumber = new int[this.numberCommunities];
        double[] communityElementFraction = new double[this.numberCommunities];
        double[] communityEntropy = new double[this.numberCommunities];
        double[] elementEntropy = new double[this.numberElements];
        double totalCommunityEntropy = 0.0;
        double totalVertexEntropy = 0.0;
        int totalCommunityNumber = 0;
        int totalVertexNumber = 0;
        double ds = 0.0;
        for (int e = 0; e < this.numberElements; ++e) {
            for (int c = 0; c < this.numberCommunities; ++c) {
                double f = this.getCommunityMembership(e, c);
                int n = c;
                communityElementFraction[n] = communityElementFraction[n] + f;
                if (f < 1.0E-20) continue;
                int n2 = c;
                communityElementNumber[n2] = communityElementNumber[n2] + 1;
                int n3 = e;
                elementCommunityNumber[n3] = elementCommunityNumber[n3] + 1;
                ++totalCommunityNumber;
                ++totalVertexNumber;
                ds = f * Math.log(f);
                int n4 = c;
                communityEntropy[n4] = communityEntropy[n4] + ds;
                int n5 = e;
                elementEntropy[n5] = elementEntropy[n5] + ds;
                totalCommunityEntropy += ds;
                totalVertexEntropy += ds;
            }
        }
        PS.println(cc + "c" + sep + "No.Elements" + sep + "Frac.Elements" + sep + "Entropy");
        for (int c = 0; c < this.numberCommunities; ++c) {
            PS.println(c + sep + communityElementNumber[c] + sep + communityElementFraction[c] + sep + communityEntropy[c]);
        }
        int[] smallCommunityCount = new int[coverage.length];
        for (int e = 0; e < this.numberElements; ++e) {
            int n = elementCommunityNumber[e];
            if (n >= smallCommunityCount.length) continue;
            int n6 = n;
            smallCommunityCount[n6] = smallCommunityCount[n6] + 1;
        }
        PS.println(cc + "n" + sep + "coverage[n]");
        int n = 0;
        coverage[n] = this.numberElements - smallCommunityCount[n];
        PS.println(n + sep + coverage[n]);
        for (n = 1; n < coverage.length; ++n) {
            coverage[n] = coverage[n - 1] - (double)smallCommunityCount[n];
            PS.println(n + sep + coverage[n]);
        }
    }

    public String informationNumbers(String cc, String sep) {
        return cc + this.valueString(this.numberElements) + sep + this.valueString(this.Q) + sep + (this.quality == null ? "not set" : this.valueString(this.quality.getLambda())) + sep + this.valueString(this.numberCommunities);
    }

    public String informationNumbersLabel(String cc, String sep) {
        return cc + "Number of " + this.nameOfElements + sep + "Quality (" + sep + this.quality.Qdefinition(sep) + ") " + sep + "gamma" + sep + "Number of Communities";
    }

    public void printCommunityMatrix(PrintStream PS, String cc, String sep) {
        this.printCommunityMatrix(PS, cc, sep, true, true);
    }

    public void printCommunities(PrintStream PS, String cc, String sep, boolean headerOn, boolean ElementLabelsOn) {
        this.printCommunityMatrix(PS, cc, sep, headerOn, ElementLabelsOn);
    }

    public void printCommunityMatrixSparse(PrintStream PS, String cc, String sep, boolean headerOn, boolean ElementLabelsOn) {
        if (headerOn) {
            PS.println(cc + "Number of " + this.nameOfElements + sep + this.numberElements + sep + "Number of Communities" + sep + this.numberCommunities);
            if (ElementLabelsOn) {
                PS.print(this.nameOfElements + sep);
                for (int c = 0; c < this.numberCommunities; ++c) {
                    PS.print(this.getCommunityName(c) + sep);
                }
                PS.println();
            }
        }
        if (this.communityMatrix != null) {
            for (int s = 0; s < this.numberElements; ++s) {
                PS.print(cc);
                if (ElementLabelsOn) {
                    PS.print(this.getElementName(s) + sep);
                }
                for (int c = 0; c < this.numberCommunities; ++c) {
                    PS.print(this.communityMatrix.get(s, c) + sep);
                }
                PS.println();
            }
        }
    }

    public void printCommunityMatrix(PrintStream PS, String cc, String sep, boolean headerOn, boolean ElementLabelsOn) {
        if (headerOn) {
            PS.println(cc + "Number of " + this.nameOfElements + sep + this.numberElements + sep + "Number of Communities" + sep + this.numberCommunities);
            if (ElementLabelsOn) {
                PS.print(this.nameOfElements + sep);
                for (int c = 0; c < this.numberCommunities; ++c) {
                    PS.print(this.getCommunityName(c) + sep);
                }
                PS.println();
            }
        }
        if (this.communityMatrix != null) {
            for (int s = 0; s < this.numberElements; ++s) {
                PS.print(cc);
                if (ElementLabelsOn) {
                    PS.print(this.getElementName(s) + sep);
                }
                for (int c = 0; c < this.numberCommunities; ++c) {
                    PS.print(this.communityMatrix.get(s, c) + sep);
                }
                PS.println();
            }
        }
    }

    public void printCommunityBipartiteGraph(PrintStream PS, String cc, String sep, boolean headerOn, boolean ElementLabelsOn) {
        if (headerOn) {
            PS.println(cc + "Number of " + this.nameOfElements + sep + this.numberElements + sep + "Number of Communities" + sep + this.numberCommunities);
            if (ElementLabelsOn) {
                PS.println(this.nameOfElements + sep + "community" + sep + "weight");
            }
        }
        double f = -1.0;
        for (int s = 0; s < this.numberElements; ++s) {
            PS.print(cc);
            for (int c = 0; c < this.numberCommunities; ++c) {
                f = this.communityMatrix.get(s, c);
                if (!(f > 0.0)) continue;
                PS.println(this.getElementName(s) + sep + c + sep + f);
            }
        }
    }

    public static MutualInformation calcMutualInformation(Community c1, Community c2, timgraph tg) {
        boolean inputWeightVertices = false;
        if (c1.getNumberElements() != c2.getNumberElements()) {
            System.err.println("*** In calcMutualInformation communities have different numbers of elements: " + c1.getNumberElements() + "   " + c2.getNumberElements());
            return null;
        }
        if (!c1.elementsAreVertices()) {
            System.err.println("*** In calcMutualInformation first community must have vertices as community , but it has " + c1.getNameOfElements());
            return null;
        }
        if (!c2.elementsAreVertices()) {
            System.err.println("*** In calcMutualInformation second community must have vertices as community , but it has " + c2.getNameOfElements());
            return null;
        }
        if (tg != null && c1.getNumberElements() != tg.getNumberVertices()) {
            System.err.println("*** In calcMutualInformation communities have different numbers of vertices from graph: " + c1.getNumberElements() + "   " + tg.getNumberVertices());
            return null;
        }
        int n = c1.getNumberElements();
        double fstr = 1.0 / (double)n;
        boolean weightVertices = false;
        if (inputWeightVertices && tg != null && tg.isWeighted()) {
            weightVertices = true;
        }
        MutualInformation mi = new MutualInformation(c1.getNumberCommunities(), c2.getNumberCommunities(), c1.getName(), c2.getName());
        if (c1.communityName != null) {
            mi.setElementNames1(c1.communityName);
        }
        if (c2.communityName != null) {
            mi.setElementNames2(c2.communityName);
        }
        double c1mf = -1.0;
        double c2mf = -1.0;
        double totalStrength = n;
        if (weightVertices) {
            totalStrength = tg.getTotalWeight();
        }
        for (int v = 0; v < n; ++v) {
            double c1norm = 0.0;
            for (int ci1 = 0; ci1 < c1.getNumberCommunities(); ++ci1) {
                c1norm += c1.getCommunityMembership(v, ci1);
            }
            if (c1norm < 1.0E-6) {
                throw new RuntimeException("*** Normalisation of vertex " + v + " in community 1 found to be zero or negative = " + c1norm);
            }
            double c2norm = 0.0;
            for (int ci2 = 0; ci2 < c2.getNumberCommunities(); ++ci2) {
                c2norm += c2.getCommunityMembership(v, ci2);
            }
            if (c2norm < 1.0E-6) {
                throw new RuntimeException("*** Normalisation of vertex " + v + " in community 2 found to be zero or negative = " + c1norm);
            }
            if (weightVertices) {
                fstr = tg.getVertexOutStrength(v) / totalStrength;
            }
            for (int ci1 = 0; ci1 < c1.getNumberCommunities(); ++ci1) {
                c1mf = c1.getCommunityMembership(v, ci1) / c1norm;
                if (c1mf > 0.0) {
                    mi.increaseMarginalProbabilityOneQuick(ci1, c1mf * fstr);
                } else if (ci1 > 0) continue;
                for (int ci2 = 0; ci2 < c2.getNumberCommunities(); ++ci2) {
                    c2mf = c2.getCommunityMembership(v, ci2) / c2norm;
                    if (c2mf == 0.0) continue;
                    if (c1mf > 0.0) {
                        mi.increaseJointProbabilityQuick(ci1, ci2, c1mf * c2mf * fstr);
                    }
                    if (ci1 != 0) continue;
                    mi.increaseMarginalProbabilityTwoQuick(ci2, c2mf * fstr);
                }
            }
        }
        if (mi.checkConsistentcy() < 0) {
            throw new RuntimeException("Consistency Problem with Mutual Information");
        }
        return mi;
    }

    static int calcMutualInformationGeneralTypes(Community c1, Community c2, timgraph tg) {
        if (c1.getNumberElements() != c2.getNumberElements()) {
            System.err.println("*** In calcMutualInformation communities have different numbers of elements: " + c1.getNumberElements() + "   " + c2.getNumberElements());
            return -1;
        }
        if (!c1.elementsAreVerticesOrEdges()) {
            System.err.println("*** In calcMutualInformation first community must have vertices or edges as community , but it has " + c1.getNameOfElements());
            return -2;
        }
        boolean c1ElementsAreVertices = c1.elementsAreVertices();
        if (!c2.elementsAreVerticesOrEdges()) {
            System.err.println("*** In calcMutualInformation second community must have vertices or edges as community , but it has " + c2.getNameOfElements());
            return -3;
        }
        boolean c2ElementsAreVertices = c2.elementsAreVertices();
        if (c1.getNumberElements() != tg.getMaximumVertices()) {
            System.err.println("*** In calcMutualInformation communities have different numbers of elements from graph: " + c1.getNumberElements() + "   " + c2.getNumberElements());
            return -1;
        }
        return 0;
    }

    public boolean elementsAreVertices() {
        return this.getNameOfElements().equals(verticesName);
    }

    public boolean elementsAreEdges() {
        return this.getNameOfElements().equals(edgesName);
    }

    public boolean elementsAreVerticesOrEdges() {
        return this.elementsAreVertices() || this.elementsAreEdges();
    }

    public String getName() {
        return this.name;
    }

    public String getNameOfElements() {
        return this.nameOfElements;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setElementNameVertices() {
        this.nameOfElements = verticesName;
    }

    public void setElementNameEdges() {
        this.nameOfElements = edgesName;
    }

    protected String valueString(int i) {
        return i == -987123456 ? "not set" : Integer.toString(i);
    }

    protected String valueString(double d) {
        return Math.abs(d / -9.7531E86 - 1.0) < 1.0E-6 ? "not set" : Double.toString(d);
    }
}

