/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.AdjacencyMatrix;
import TimGraph.timgraph;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;

public class AdjacencyMatrixSparse
extends AdjacencyMatrix {
    Algebra alg = new Algebra();

    public AdjacencyMatrixSparse(timgraph tg) {
        this.make(tg);
    }

    public AdjacencyMatrixSparse(double[][] m, int def) {
        if (def == 1) {
            this.makeA2mA(m);
        } else {
            this.make(m);
        }
    }

    public AdjacencyMatrixSparse(timgraph tg, int def) {
        if (def == 1) {
            AdjacencyMatrixSparse am = new AdjacencyMatrixSparse(tg);
            this.makeA2mA(am.matrix());
        } else {
            this.make(tg);
        }
    }

    public AdjacencyMatrixSparse(int totalNumberVertices, int totalNumberStubs, int[] edgeSourceList, boolean directedGraph) {
        this.dimension = totalNumberVertices;
        this.initialiseMatrix();
        this.makeUnweighted(totalNumberVertices, totalNumberStubs, edgeSourceList, directedGraph);
    }

    private void initialiseMatrix() {
        this.matrix = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        this.totalWeight = 0.0;
    }

    @Override
    public void make(double[][] m) {
        this.dimension = m[0].length;
        this.matrix = new SparseDoubleMatrix2D(m);
        this.totalWeight = 0.0;
    }

    @Override
    public void makeA2mA(double[][] m) {
        this.dimension = m[0].length;
        this.matrix = new SparseDoubleMatrix2D(m);
        this.totalWeight = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double value = -m[i][j];
                for (int k = 0; k < this.dimension; ++k) {
                    value += m[i][k] * m[k][j];
                }
                this.totalWeight += value;
                this.matrix.setQuick(i, j, value);
            }
        }
    }

    @Override
    public void make(timgraph graph) {
        this.make(graph, this.transferMatrix);
    }

    public void make(timgraph graph, boolean makeTransferMatrix) {
        if (!graph.isVertexEdgeListOn()) {
            System.err.println("*** in AdjacencyMatrix make, graph " + graph.inputName.getNameRoot() + " needs vertexEdgeList");
        }
        this.transferMatrix = makeTransferMatrix;
        boolean undirected = !graph.isDirected();
        boolean weighted = graph.isWeighted();
        this.dimension = graph.getNumberVertices();
        int numberEdges = graph.getNumberStubs();
        double sstrout = -1.0;
        int s = -1;
        double w = -1.0;
        this.initialiseMatrix();
        for (int e = 0; e < numberEdges; ++e) {
            s = graph.getVertexFromEdge(e++);
            if (this.transferMatrix && (sstrout = graph.getVertexOutStrength(s)) < 1.0E-20) {
                throw new RuntimeException("Out strength is too small for vertex " + s + " of value " + sstrout);
            }
            w = weighted ? graph.getEdgeWeight(e) : 1.0;
            if (this.transferMatrix) {
                w /= sstrout;
            }
            int t = graph.getVertexFromEdge(e);
            this.increaseEdgeWeight(s, t, w, undirected);
        }
    }

    @Override
    protected void increaseEdgeWeight(int s, int t, double w, boolean undirected) {
        double nw = w + this.matrix.getQuick(s, t);
        this.matrix.setQuick(s, t, nw);
        this.totalWeight += w;
        if (undirected) {
            nw = w + this.matrix.getQuick(t, s);
            this.matrix.setQuick(t, s, nw);
            this.totalWeight += w;
        }
    }

    @Override
    public void make(String[] args) {
        String fileName = "AMdefault";
        String directoryName = "";
        int infolevel = -2;
        int outputcontrol = 31;
        timgraph tg = new timgraph(fileName + "tg", directoryName, infolevel, outputcontrol);
        tg.setNumberEvents(this.dimension);
        tg.parseParam(args);
        if (tg.getInitialVertices() > this.dimension) {
            tg.setInitialVertices(this.dimension);
        }
        tg.doOneRun(1);
        this.makeUnweighted(tg.getNumberVertices(), tg.getNumberStubs(), tg.getStubSourceList(), tg.directedGraph);
    }

    private void makeUnweighted(int totalNumberVertices, int totalNumberStubs, int[] edgeSourceList, boolean directedGraph) {
        int source = -1;
        int target = -1;
        double nw = -1.0;
        for (int e = 0; e < totalNumberStubs; ++e) {
            source = edgeSourceList[e++];
            target = edgeSourceList[e];
            nw = this.matrix.get(source, target) + 1.0;
            this.matrix.set(source, target, nw);
            if (directedGraph) continue;
            this.matrix.set(target, source, nw);
        }
    }
}

