/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.AdjacencyMatrix;
import TimGraph.timgraph;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;

public class AdjacencyMatrixDense
extends AdjacencyMatrix {
    public AdjacencyMatrixDense(timgraph tg) {
        this.make(tg);
    }

    public AdjacencyMatrixDense(double[][] m, int def) {
        if (def == 1) {
            this.makeA2mA(m);
        } else {
            this.make(m);
        }
    }

    public AdjacencyMatrixDense(timgraph tg, int def) {
        if (def == 1) {
            AdjacencyMatrix am = new AdjacencyMatrix(tg);
            this.makeA2mA(am.matrix());
        } else {
            this.make(tg);
        }
    }

    public AdjacencyMatrixDense(int totalNumberVertices, int totalNumberStubs, int[] edgeSourceList, boolean directedGraph) {
        this.dimension = totalNumberVertices;
        this.initialiseMatrix();
        this.makeUnweighted(totalNumberVertices, totalNumberStubs, edgeSourceList, directedGraph);
    }

    private void initialiseMatrix() {
        this.matrix = new DenseDoubleMatrix2D(this.dimension, this.dimension);
        this.totalWeight = 0.0;
    }

    @Override
    public void make(double[][] m) {
        this.dimension = m[0].length;
        this.matrix = new DenseDoubleMatrix2D(m);
        this.totalWeight = 0.0;
    }

    @Override
    public void makeA2mA(double[][] m) {
        this.dimension = m[0].length;
        this.matrix = new DenseDoubleMatrix2D(m);
        this.totalWeight = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double value = -m[i][j];
                for (int k = 0; k < this.dimension; ++k) {
                    value += m[i][k] * m[k][j];
                }
                this.totalWeight += value;
                this.matrix.setQuick(i, j, value);
            }
        }
    }

    @Override
    public void make(String[] args) {
        String fileName = "AMdefault";
        String directoryName = "";
        int infolevel = -2;
        int outputcontrol = 31;
        timgraph tg = new timgraph(fileName + "tg", directoryName, infolevel, outputcontrol);
        tg.setNumberEvents(this.dimension);
        tg.parseParam(args);
        if (tg.getInitialVertices() > this.dimension) {
            tg.setInitialVertices(this.dimension);
        }
        tg.doOneRun(1);
        this.makeUnweighted(tg.getNumberVertices(), tg.getNumberStubs(), tg.getStubSourceList(), tg.directedGraph);
    }

    private void makeUnweighted(int totalNumberVertices, int totalNumberStubs, int[] edgeSourceList, boolean directedGraph) {
        int source = -1;
        int target = -1;
        double nw = -1.0;
        for (int e = 0; e < totalNumberStubs; ++e) {
            source = edgeSourceList[e++];
            target = edgeSourceList[e];
            nw = this.matrix.get(source, target) + 1.0;
            this.matrix.set(source, target, nw);
            if (directedGraph) continue;
            this.matrix.set(target, source, nw);
        }
    }
}

