/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.timgraph;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import java.io.PrintStream;

public class AdjacencyMatrix {
    protected int dimension = -1;
    protected DoubleMatrix2D matrix;
    protected double[] inVector;
    protected double[] outVector;
    protected DoubleMatrix1D piVector;
    protected double totalWeight = 0.0;
    boolean transferMatrix = false;
    static final double DUNSET = -97531.0;
    static final int IUNSET = -86420;

    public AdjacencyMatrix() {
    }

    public AdjacencyMatrix(timgraph tg) {
        this.make(tg);
    }

    public AdjacencyMatrix(double[][] m, int def) {
        if (def == 1) {
            this.makeA2mA(m);
        } else {
            this.make(m);
        }
    }

    public AdjacencyMatrix(timgraph tg, int def) {
        if (def == 1) {
            AdjacencyMatrix am = new AdjacencyMatrix(tg);
            this.makeA2mA(am.matrix());
        } else {
            this.make(tg);
        }
    }

    public AdjacencyMatrix(int totalNumberVertices, int totalNumberStubs, int[] edgeSourceList, boolean directedGraph) {
        this.dimension = totalNumberVertices;
        this.initialiseMatrix();
        this.makeUnweighted(totalNumberVertices, totalNumberStubs, edgeSourceList, directedGraph);
    }

    private void initialiseMatrix() {
        this.matrix = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        this.totalWeight = 0.0;
    }

    public double get(int source, int target) {
        return this.matrix.get(source, target);
    }

    public double[][] matrix() {
        return this.matrix.toArray();
    }

    public DoubleMatrix2D doubleMatrix2D() {
        return this.matrix;
    }

    public double getInStrength(int vertex) {
        return this.inVector[vertex];
    }

    public double getOutStrength(int vertex) {
        return this.outVector[vertex];
    }

    public double getNormalisedPi(int vertex) {
        return this.piVector.get(vertex);
    }

    public double totalWeight() {
        return this.totalWeight;
    }

    public int dimension() {
        return this.dimension;
    }

    public void make(double[][] m) {
        this.dimension = m[0].length;
        this.initialiseMatrix();
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double value = m[i][j];
                this.totalWeight += value;
                this.matrix.set(i, j, value);
            }
        }
    }

    public void makeA2mA(double[][] m) {
        this.dimension = m[0].length;
        this.initialiseMatrix();
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double value = -m[i][j];
                for (int k = 0; k < this.dimension; ++k) {
                    value += m[i][k] * m[k][j];
                }
                this.totalWeight += value;
                this.matrix.set(i, j, value);
            }
        }
    }

    public void make(timgraph graph) {
        if (!graph.isVertexEdgeListOn()) {
            graph.createVertexGlobalEdgeList();
            System.err.println("!!! WARNING in AdjacencyMatrix make, graph " + graph.inputName.getNameRoot() + " needs vertexEdgeList, creating an unsynchronised one");
        }
        this.dimension = graph.getNumberVertices();
        this.inVector = new double[this.dimension];
        this.outVector = new double[this.dimension];
        boolean undirected = !graph.isDirected();
        boolean weighted = graph.isWeighted();
        this.dimension = graph.getNumberVertices();
        int numberEdges = graph.getNumberStubs();
        double w = -1.0;
        this.initialiseMatrix();
        for (int e = 0; e < numberEdges; ++e) {
            int s = graph.getVertexFromEdge(e++);
            w = weighted ? graph.getEdgeWeight(e) : 1.0;
            int t = graph.getVertexFromEdge(e);
            this.increaseEdgeWeight(s, t, w, undirected);
            int n = t;
            this.inVector[n] = this.inVector[n] + w;
            int n2 = s;
            this.outVector[n2] = this.outVector[n2] + w;
        }
    }

    protected void increaseEdgeWeight(int s, int t, double dw, boolean undirected) {
        double newValue = dw + this.matrix.get(s, t);
        this.matrix.set(s, t, newValue);
        this.totalWeight += dw;
        if (undirected) {
            this.matrix.set(t, s, newValue);
            this.totalWeight += dw;
        }
    }

    public void make(String[] args) {
        String fileName = "AMdefault";
        String directoryName = "";
        int infolevel = -2;
        int outputcontrol = 31;
        timgraph tg = new timgraph(fileName + "tg", directoryName, infolevel, outputcontrol);
        tg.setNumberEvents(this.dimension);
        tg.parseParam(args);
        if (tg.getInitialVertices() > this.dimension) {
            tg.setInitialVertices(this.dimension);
        }
        tg.doOneRun(1);
        this.makeUnweighted(tg.getNumberVertices(), tg.getNumberStubs(), tg.getStubSourceList(), tg.directedGraph);
    }

    public void calculateInOutVectors() {
        this.inVector = new double[this.dimension];
        this.outVector = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.outVector[i] = 0.0;
            this.inVector[i] = 0.0;
            for (int j = 0; j < this.dimension; ++j) {
                int n = i;
                this.inVector[n] = this.inVector[n] + this.get(j, i);
                int n2 = i;
                this.outVector[n2] = this.outVector[n2] + this.get(i, j);
            }
        }
    }

    public void calculatePageRankVector() {
        int maxIter = 100;
        double relError = 0.001;
        double alpha = 1.0;
        this.calculatePiVector(maxIter, relError, alpha);
    }

    public void calculatePiVector() {
        int maxIter = 10;
        double relError = 0.01;
        double alpha = 1.0;
        this.calculatePiVector(maxIter, relError, alpha);
    }

    public void calculatePiVector(int maxIter, double relError, double alpha) {
        int i;
        this.calculateInOutVectors();
        this.piVector = new DenseDoubleMatrix1D(this.dimension);
        SparseDoubleMatrix2D T = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        DenseDoubleMatrix1D kinNormVector = new DenseDoubleMatrix1D(this.dimension);
        DenseDoubleMatrix1D rankVector2 = new DenseDoubleMatrix1D(this.dimension);
        for (int s = 0; s < this.dimension; ++s) {
            double v = this.inVector[s] / this.totalWeight;
            this.piVector.setQuick(s, v);
            kinNormVector.setQuick(s, v);
            for (int t = 0; t < this.dimension; ++t) {
                v = this.matrix.getQuick(s, t);
                if (v == 0.0) continue;
                T.setQuick(t, s, v / this.outVector[s]);
            }
        }
        Algebra alg = new Algebra();
        double newdiff = 0.0;
        double sumNew = this.piVector.zSum();
        double beta = 1.0 - alpha;
        double absoluteTolerance = relError;
        DenseDoubleMatrix1D tempVector = new DenseDoubleMatrix1D(this.dimension);
        int iter = -1;
        for (iter = 0; iter < maxIter; ++iter) {
            T.zMult(this.piVector, (DoubleMatrix1D)rankVector2, alpha / sumNew, 0.0, false);
            if (beta != 0.0) {
                rankVector2.assign((DoubleMatrix1D)kinNormVector, Functions.plusMult((double)beta));
            }
            sumNew = rankVector2.zSum();
            T.zMult((DoubleMatrix1D)rankVector2, this.piVector, alpha / sumNew, beta, false);
            if (beta != 0.0) {
                this.piVector.assign((DoubleMatrix1D)kinNormVector, Functions.plusMult((double)beta));
            }
            sumNew = this.piVector.zSum();
            newdiff = 0.0;
            for (i = 0; i < this.dimension; ++i) {
                newdiff += Math.abs(this.piVector.getQuick(i) - rankVector2.getQuick(i));
            }
            if (Math.abs(newdiff / sumNew) < relError) break;
        }
        sumNew = this.piVector.zSum();
        for (i = 0; i < this.piVector.size(); ++i) {
            this.piVector.setQuick(i, this.piVector.getQuick(i) / sumNew);
        }
        System.out.println("Convergence in calculatePiVector factor " + String.format("%8.6g", Math.abs(newdiff / sumNew)) + " after " + iter + " iterations");
    }

    public void calcPiVectorAlternate(int maxIterations, double absoluteTolerance) {
        this.piVector = new DenseDoubleMatrix1D(this.inVector);
        SparseDoubleMatrix2D T = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        for (int s = 0; s < this.dimension; ++s) {
            for (int t = 0; t < this.dimension; ++t) {
                double v = this.matrix.getQuick(s, t);
                if (v == 0.0) continue;
                T.setQuick(t, s, v / this.outVector[s]);
            }
        }
        double lambdaOld = 1.0;
        double lambda = Math.abs(this.piVector.zSum());
        double beta = 0.0;
        double alpha = 1.0 - beta;
        while (--maxIterations > 0) {
            this.piVector = this.matrix.zMult(this.piVector, this.piVector, lambda * alpha, beta * lambda, false);
            lambdaOld = lambda;
            lambda = Math.abs(this.piVector.zSum());
            if (!(Math.abs(lambda - lambdaOld) < absoluteTolerance)) continue;
        }
        lambda = Math.abs(this.piVector.zSum());
        for (int s = 0; s < this.dimension; ++s) {
            this.piVector.set(s, this.piVector.get(s) / lambda);
        }
    }

    private void makeUnweighted(int totalNumberVertices, int totalNumberStubs, int[] edgeSourceList, boolean directedGraph) {
        int source = -1;
        int target = -1;
        for (int e = 0; e < totalNumberStubs; ++e) {
            source = edgeSourceList[e++];
            target = edgeSourceList[e];
            double newValue = 1.0 + this.matrix.get(source, target);
            this.matrix.set(source, target, newValue);
            if (directedGraph) continue;
            this.matrix.set(target, source, newValue);
        }
    }

    public void check() {
        double totin = 0.0;
        double totout = 0.0;
        double tot = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            totout += this.outVector[i];
            totin += this.inVector[i];
            for (int j = 0; j < this.dimension; ++j) {
                tot += this.get(i, j);
            }
        }
        System.out.println("!!! Check in Adjacency Matrix, Totals for Matrix, In, Out " + tot + ", " + totin + ", " + totout);
    }

    public void printVector(PrintStream PS, String sep, String name, double[] vector, boolean headersOn) {
        String doubleFormat = "%6.3f";
        String intFormat = "%6d";
        System.out.println(name + " vector");
        if (headersOn) {
            for (int j = 0; j < this.dimension; ++j) {
                PS.print(String.format(intFormat, j) + sep);
            }
            PS.println();
        }
        for (int i = 0; i < this.dimension; ++i) {
            PS.print(String.format(doubleFormat, vector[i]) + sep);
        }
        PS.println();
    }

    public void printVector(PrintStream PS, String sep, String name, DoubleMatrix1D vector, boolean headersOn) {
        this.printVector(PS, sep, name, vector.toArray(), headersOn);
    }

    public void printMatrix(PrintStream PS, String sep, String name, DoubleMatrix2D mat, boolean headersOn) {
        String doubleFormat = "%6.3f";
        String intFormat = "%6d";
        System.out.println(name + " matrix");
        if (headersOn) {
            PS.print("      " + sep);
            for (int j = 0; j < this.dimension; ++j) {
                PS.print(String.format(intFormat, j) + sep);
            }
            PS.println();
        }
        for (int i = 0; i < this.dimension; ++i) {
            if (headersOn) {
                PS.print(String.format(intFormat, i) + sep);
            }
            for (int j = 0; j < this.dimension; ++j) {
                PS.print(String.format(doubleFormat, mat.get(i, j)) + sep);
            }
            PS.println();
        }
    }

    public void printMatrix(PrintStream PS, String sep, String[] nameList, boolean headersOn) {
        boolean headerNamesOn = false;
        if (headersOn) {
            if (nameList != null && nameList.length == this.dimension) {
                headerNamesOn = true;
            }
            PS.print(" " + sep);
            for (int j = 0; j < this.dimension; ++j) {
                PS.print((headerNamesOn ? nameList[j] : Integer.valueOf(j)) + sep);
            }
            PS.println();
        }
        for (int i = 0; i < this.dimension; ++i) {
            if (headersOn) {
                PS.print((headerNamesOn ? nameList[i] : Integer.valueOf(i)) + sep);
            }
            for (int j = 0; j < this.dimension; ++j) {
                PS.print(this.get(i, j) + sep);
            }
            PS.println();
        }
    }

    public void printMatrix(PrintStream PS, String sep, boolean headersOn) {
        this.printMatrix(PS, sep, null, headersOn);
    }

    public void printMatrix(String sep, boolean headersOn) {
        this.printMatrix(System.out, sep, headersOn);
    }
}

