/*
 * Decompiled with CFR 0.152.
 */
package JavaNotes;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class TextReaderTabSeparated
extends FilterReader {
    private int lookAhead = -1;
    protected boolean errorFlag = false;
    private String errorMessage = "";
    protected boolean EOF = false;
    private boolean throwExceptionOnError = true;
    private boolean possibleLineFeedPending = false;

    public TextReaderTabSeparated(BufferedReader s) {
        super(s);
    }

    public TextReaderTabSeparated(Reader s) {
        super(new BufferedReader(s));
    }

    public TextReaderTabSeparated(InputStream s) {
        super(new BufferedReader(new InputStreamReader(s)));
    }

    public void IOCheck(boolean throwExceptions) {
        this.throwExceptionOnError = throwExceptions;
    }

    public boolean error() {
        return this.errorFlag;
    }

    public String getErrorMessage() {
        return this.errorFlag ? this.errorMessage : null;
    }

    public char peek() {
        this.errorFlag = false;
        return this.lookChar();
    }

    public char getAnyChar() {
        this.errorFlag = false;
        return this.readChar();
    }

    public char getChar() {
        this.errorFlag = false;
        this.skipWhiteSpace();
        return this.readChar();
    }

    public byte getByte() {
        this.errorFlag = false;
        return (byte)this.readInteger(-128L, 127L);
    }

    public short getShort() {
        this.errorFlag = false;
        return (short)this.readInteger(-32768L, 32767L);
    }

    public int getInt() {
        this.errorFlag = false;
        return (int)this.readInteger(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public long getLong() {
        this.errorFlag = false;
        return this.readInteger(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public float getFloat() {
        this.errorFlag = false;
        return this.readFloat();
    }

    public double getDouble() {
        this.errorFlag = false;
        return this.readDouble();
    }

    public boolean getBoolean() {
        this.errorFlag = false;
        return this.readBoolean();
    }

    public String getWordWithSpaces() {
        this.errorFlag = false;
        return this.readWordWithSpaces();
    }

    public String getWordIncludingSpaces() {
        this.errorFlag = false;
        return this.readWordIncludingSpaces();
    }

    public String getWord() {
        this.errorFlag = false;
        return this.readWord();
    }

    public String getAlpha() {
        this.errorFlag = false;
        return this.readAlpha();
    }

    public String getln() {
        this.errorFlag = false;
        return this.readLine();
    }

    public char getlnChar() {
        char x = this.getChar();
        this.dropLine();
        return x;
    }

    public byte getlnByte() {
        byte x = this.getByte();
        this.dropLine();
        return x;
    }

    public short getlnShort() {
        short x = this.getShort();
        this.dropLine();
        return x;
    }

    public int getlnInt() {
        int x = this.getInt();
        this.dropLine();
        return x;
    }

    public long getlnLong() {
        long x = this.getLong();
        this.dropLine();
        return x;
    }

    public float getlnFloat() {
        float x = this.getFloat();
        this.dropLine();
        return x;
    }

    public double getlnDouble() {
        double x = this.getDouble();
        this.dropLine();
        return x;
    }

    public boolean getlnBoolean() {
        boolean x = this.getBoolean();
        this.dropLine();
        return x;
    }

    public String getlnWord() {
        String x = this.getWord();
        this.dropLine();
        return x;
    }

    public String getlnAlpha() {
        String x = this.getAlpha();
        this.dropLine();
        return x;
    }

    public boolean eoln() {
        char ch = this.lookChar();
        while (!this.EOF && !this.errorFlag && ch == ' ') {
            this.readChar();
            ch = this.lookChar();
        }
        return ch == '\n' || this.EOF;
    }

    public boolean eof() {
        char ch = this.lookChar();
        while (!this.EOF && !this.errorFlag && ch == '\n') {
            this.readChar();
            ch = this.lookChar();
        }
        return this.EOF;
    }

    public void skipWhiteSpaceNotSpaces() {
        char ch = this.lookChar();
        while (!(this.errorFlag || ch != '\t' && ch != '\n')) {
            this.readChar();
            ch = this.lookChar();
        }
    }

    public void skipWhiteSpaceNotTabs() {
        char ch = this.lookChar();
        while (!(this.errorFlag || ch != ' ' && ch != '\n')) {
            this.readChar();
            ch = this.lookChar();
        }
    }

    public void skipSpaces() {
        char ch = this.lookChar();
        while (!this.errorFlag && ch == ' ') {
            this.readChar();
            ch = this.lookChar();
        }
    }

    public void skipWhiteSpace() {
        char ch = this.lookChar();
        while (!(this.errorFlag || ch != ' ' && ch != '\n' && ch != '\t')) {
            this.readChar();
            ch = this.lookChar();
        }
    }

    public void skipEndOfLine() {
        char ch = this.lookChar();
        while (!this.errorFlag && ch == '\n') {
            this.readChar();
            ch = this.lookChar();
        }
    }

    public void skipNonLetters() {
        char ch = this.lookChar();
        while (!(this.errorFlag || this.EOF || Character.isLetter(ch))) {
            this.readChar();
            ch = this.lookChar();
        }
    }

    @Override
    public void close() {
        this.errorFlag = false;
        try {
            this.in.close();
        }
        catch (IOException e) {
            this.errorFlag = true;
            this.errorMessage = e.toString();
        }
    }

    private void doError(String message) {
        this.errorFlag = true;
        this.errorMessage = message;
        if (this.throwExceptionOnError) {
            throw new Error(message);
        }
    }

    private void doFormatError(String message) {
        this.errorFlag = true;
        this.errorMessage = message;
        if (this.throwExceptionOnError) {
            throw new FormatError(message);
        }
    }

    private void doEOFError(String message) {
        this.errorFlag = true;
        this.errorMessage = message;
        if (this.throwExceptionOnError) {
            throw new FormatError(message);
        }
    }

    protected char readChar() {
        char ch = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data in input stream.");
        }
        this.lookAhead = -1;
        return ch;
    }

    protected char lookChar() {
        if (this.lookAhead != -1) {
            if (this.lookAhead == 13) {
                return '\n';
            }
            return (char)this.lookAhead;
        }
        if (this.EOF) {
            return '\u0000';
        }
        try {
            int n = this.in.read();
            if (n == 10 && this.possibleLineFeedPending) {
                n = this.in.read();
            }
            this.possibleLineFeedPending = n == 13;
            this.lookAhead = n;
            if (this.lookAhead == -1) {
                this.EOF = true;
                return '\u0000';
            }
        }
        catch (IOException e) {
            this.doError(e.getMessage());
        }
        if (this.lookAhead == 13) {
            this.lookAhead = 10;
        }
        return (char)this.lookAhead;
    }

    private void dropLine() {
        while (!this.errorFlag) {
            if (this.lookChar() == '\u0000') {
                return;
            }
            if (this.readChar() != '\n') continue;
            return;
        }
    }

    private String readLine() {
        StringBuffer s = new StringBuffer(100);
        char ch = this.readChar();
        while (!this.errorFlag && ch != '\n') {
            s.append(ch);
            ch = this.lookChar();
            if (ch == '\u0000') break;
            ch = this.readChar();
        }
        return s.toString();
    }

    private String readWord() {
        this.skipWhiteSpace();
        if (this.errorFlag) {
            return null;
        }
        StringBuffer s = new StringBuffer(50);
        char ch = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data");
            return null;
        }
        while (!this.errorFlag && !this.EOF && ch != '\n' && ch != '\t') {
            s.append(this.readChar());
            ch = this.lookChar();
        }
        return s.toString();
    }

    private String readWordWithSpaces() {
        this.skipWhiteSpaceNotSpaces();
        if (this.errorFlag) {
            return null;
        }
        StringBuffer s = new StringBuffer(50);
        char ch = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data");
            return null;
        }
        while (!this.errorFlag && !this.EOF && ch != '\n' && ch != '\t') {
            s.append(this.readChar());
            ch = this.lookChar();
        }
        return s.toString();
    }

    private String readWordIncludingSpaces() {
        if (this.errorFlag) {
            return null;
        }
        StringBuffer s = new StringBuffer(50);
        char ch = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data");
            return null;
        }
        while (!this.errorFlag && !this.EOF && ch != '\n' && ch != '\t') {
            s.append(this.readChar());
            ch = this.lookChar();
        }
        if (ch == '\t' || ch != '\n') {
            this.readChar();
        }
        return s.toString();
    }

    private String readAlpha() {
        this.skipNonLetters();
        if (this.errorFlag) {
            return null;
        }
        StringBuffer s = new StringBuffer(50);
        char ch = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data");
            return null;
        }
        while (!this.errorFlag && Character.isLetter(ch)) {
            s.append(this.readChar());
            ch = this.lookChar();
        }
        return s.toString();
    }

    public float readFloat() {
        double d = this.readDouble();
        if (this.errorFlag) {
            return Float.NaN;
        }
        if (Math.abs(d) > 3.4028234663852886E38) {
            this.doFormatError("Input number outside of legal range for values of type float");
        }
        return (float)d;
    }

    public double readDouble() {
        double x = Double.NaN;
        StringBuffer s = new StringBuffer(50);
        this.skipWhiteSpace();
        char ch = this.lookChar();
        if (ch == '-' || ch == '+') {
            s.append(this.readChar());
            this.skipWhiteSpace();
            ch = this.lookChar();
        }
        if ((ch < '0' || ch > '9') && ch != '.') {
            if (this.EOF) {
                this.doEOFError("Expecting a floating-point number and found end-of-data");
            } else {
                this.doFormatError("Expecting a floating-point number and found \"" + ch + "\"");
            }
            return Double.NaN;
        }
        boolean digits = false;
        while (ch >= '0' && ch <= '9') {
            s.append(this.readChar());
            ch = this.lookChar();
            digits = true;
        }
        if (ch == '.') {
            s.append(this.readChar());
            ch = this.lookChar();
            while (ch >= '0' && ch <= '9') {
                s.append(this.readChar());
                ch = this.lookChar();
                digits = true;
            }
        }
        if (!digits) {
            this.doFormatError("No digits found in floating-point input.");
            return Double.NaN;
        }
        if (ch == 'E' || ch == 'e') {
            s.append(this.readChar());
            ch = this.lookChar();
            if (ch == '-' || ch == '+') {
                s.append(this.readChar());
                ch = this.lookChar();
            }
            if ((ch < '0' || ch > '9') && ch != '.') {
                if (this.EOF) {
                    this.doEOFError("Expecting exponent for a floating-point number and found end-of-data");
                } else {
                    this.doFormatError("Expecting exponent for a floating-point number and found \"" + ch + "\"");
                }
                return Double.NaN;
            }
            while (ch >= '0' && ch <= '9') {
                s.append(this.readChar());
                ch = this.lookChar();
            }
        }
        String str = s.toString();
        try {
            Double d = new Double(str);
            x = d;
        }
        catch (NumberFormatException e) {
            x = Double.NaN;
        }
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            this.doFormatError("Illegal floating point number");
            return Double.NaN;
        }
        return x;
    }

    public boolean readBoolean() {
        boolean ans = false;
        String s = this.getWord();
        if (this.errorFlag) {
            return false;
        }
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y") || s.equals("1")) {
            ans = true;
        } else if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("n") || s.equals("0")) {
            ans = false;
        } else {
            this.doFormatError("Illegal input for value of type boolean: \"" + s + "\"");
        }
        return ans;
    }

    private long readInteger(long min, long max) {
        this.skipWhiteSpace();
        if (this.errorFlag) {
            return 0L;
        }
        int sign = 43;
        if (this.lookChar() == '-' || this.lookChar() == '+') {
            sign = this.getChar();
            this.skipWhiteSpace();
        }
        long n = 0L;
        char ch = this.lookChar();
        if (ch < '0' || ch > '9') {
            if (this.EOF) {
                this.doEOFError("Expecting an integer and found end-of-data");
            } else {
                this.doFormatError("Expecting an integer and found \"" + ch + "\"");
            }
            return 0L;
        }
        while (!this.errorFlag && ch >= '0' && ch <= '9') {
            this.readChar();
            n = 10L * n + (long)ch - 48L;
            if (n < 0L) {
                this.doFormatError("Integer value outside of legal range");
                return 0L;
            }
            ch = this.lookChar();
        }
        if (sign == 45) {
            n = -n;
        }
        if (n < min || n > max) {
            this.doFormatError("Integer value outside of legal range");
            return 0L;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        if (this.lookAhead == -1) {
            return super.read();
        }
        int x = this.lookAhead;
        this.lookAhead = -1;
        return x;
    }

    @Override
    public int read(char[] buffer, int offset, int count) throws IOException {
        if (this.lookAhead == -1 || count <= 0) {
            return super.read(buffer, offset, count);
        }
        if (count == 1) {
            buffer[offset] = (char)this.lookAhead;
            this.lookAhead = -1;
            return 1;
        }
        buffer[offset] = (char)this.lookAhead;
        this.lookAhead = -1;
        int ct = super.read(buffer, offset + 1, count - 1);
        return ct + 1;
    }

    public static class EOFError
    extends Error {
        EOFError(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class FormatError
    extends Error {
        FormatError(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class Error
    extends RuntimeException {
        Error(String errorMessage) {
            super(errorMessage);
        }
    }
}

