/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.impl.BipartiteGraph;
import edu.uci.ics.jung.graph.impl.BipartiteVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.utils.Pair;

public class BipartiteEdge
extends UndirectedSparseEdge {
    public BipartiteEdge(BipartiteVertex a, BipartiteVertex b) {
        super(a, b);
        BipartiteGraph g = (BipartiteGraph)a.getGraph();
        boolean aInA = g.getAllVertices(BipartiteGraph.CLASSA).contains(a);
        boolean bInB = g.getAllVertices(BipartiteGraph.CLASSB).contains(b);
        if (!aInA || !bInB) {
            throw new FatalException("Tried to create edge that isn't bipartite!");
        }
    }

    public ArchetypeEdge copy(ArchetypeGraph newGraph) {
        BipartiteEdge e;
        if (newGraph == this.getGraph()) {
            throw new IllegalArgumentException("Source and destination graphs must be different");
        }
        Pair ends = this.getEndpoints();
        BipartiteVertex eFrom = (BipartiteVertex)ends.getFirst();
        BipartiteVertex eTo = (BipartiteVertex)ends.getSecond();
        BipartiteVertex from = (BipartiteVertex)eFrom.getEqualVertex(newGraph);
        BipartiteVertex to = (BipartiteVertex)eTo.getEqualVertex(newGraph);
        if (from == null || to == null) {
            throw new IllegalArgumentException("Cannot create edge: source edge's incident vertices have no equivalents in target graph");
        }
        if (from.getGraph() != newGraph) {
            throw new FatalException("Unexpected error: 'from' vertex is not in target graph");
        }
        if (to.getGraph() != newGraph) {
            throw new FatalException("Unexpected error: 'to' vertex is not in target graph");
        }
        if (eFrom.getGraph() == from.getGraph()) {
            throw new FatalException("Unexpected error: 'from' and 'to' vertices are not in same graph");
        }
        try {
            e = (BipartiteEdge)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new FatalException("Can't copy edge", cnse);
        }
        e.m_Graph = null;
        e.mFrom = from;
        e.mTo = to;
        ((BipartiteGraph)newGraph).addBipartiteEdge(e);
        e.importUserData(this);
        return e;
    }
}

