/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import edu.uci.ics.jung.algorithms.cluster.KMeansClusterer;
import edu.uci.ics.jung.algorithms.importance.VoltageRanker;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import edu.uci.ics.jung.statistics.DiscreteDistribution;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class VoltageClusterer {
    public static final String VOLTAGE_KEY = "edu.uci.ics.jung.algorithms.cluster.VoltageClusterer.KEY";
    protected int num_candidates;
    protected KMeansClusterer kmc;
    protected UserDatumNumberVertexValue vv;
    protected VoltageRanker vr;
    protected RandomEngine rand;

    public VoltageClusterer(int num_candidates, int rank_iterations, double rank_convergence, int cluster_iterations, double cluster_convergence) {
        if (num_candidates < 1) {
            throw new IllegalArgumentException("must generate >=1 candidates");
        }
        this.num_candidates = num_candidates;
        this.vv = new UserDatumNumberVertexValue(VOLTAGE_KEY);
        this.vr = new VoltageRanker(this.vv, rank_iterations, rank_convergence);
        this.kmc = new KMeansClusterer(cluster_iterations, cluster_convergence);
        this.rand = new DRand();
    }

    protected void setRandomSeed(int random_seed) {
        this.rand = new DRand(random_seed);
    }

    public Collection getCommunity(ArchetypeVertex v) {
        return this.cluster_internal(v.getGraph(), v, 2);
    }

    public Collection cluster(ArchetypeGraph g, int num_clusters) {
        return this.cluster_internal(g, null, num_clusters);
    }

    public void clear(ArchetypeGraph g) {
        this.vv.clear(g);
    }

    protected Collection cluster_internal(ArchetypeGraph g, ArchetypeVertex origin, int num_clusters) {
        Set vertices = g.getVertices();
        int num_vertices = vertices.size();
        ArchetypeVertex[] v = new ArchetypeVertex[num_vertices];
        int i = 0;
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            v[i++] = (ArchetypeVertex)iter.next();
        }
        LinkedList candidates = new LinkedList();
        for (int j = 0; j < this.num_candidates; ++j) {
            ArchetypeVertex source = origin == null ? v[(int)(this.rand.nextDouble() * (double)num_vertices)] : origin;
            ArchetypeVertex target = null;
            while (source == (target = v[(int)(this.rand.nextDouble() * (double)num_vertices)])) {
            }
            this.vr.calculateVoltages((Vertex)source, (Vertex)target);
            HashMap<ArchetypeVertex, double[]> voltage_ranks = new HashMap<ArchetypeVertex, double[]>();
            Iterator iter2 = vertices.iterator();
            while (iter2.hasNext()) {
                ArchetypeVertex w = (ArchetypeVertex)iter2.next();
                double[] voltage = new double[]{this.vv.getNumber(w).doubleValue()};
                voltage_ranks.put(w, voltage);
            }
            try {
                Collection clusters = this.kmc.cluster(voltage_ranks, 2);
                Iterator iter3 = clusters.iterator();
                candidates.add(((Map)iter3.next()).keySet());
                candidates.add(((Map)iter3.next()).keySet());
                continue;
            }
            catch (KMeansClusterer.NotEnoughClustersException e) {
                // empty catch block
            }
        }
        LinkedList<Set<Object>> clusters = new LinkedList<Set<Object>>();
        HashSet remaining = new HashSet(g.getVertices());
        Object[] seed_candidates = this.getSeedCandidates(candidates);
        int seed_index = 0;
        for (int j = 0; j < num_clusters - 1 && !remaining.isEmpty(); ++j) {
            Object seed;
            if (seed_index == 0 && origin != null) {
                seed = origin;
            } else {
                while (!remaining.contains(seed = seed_candidates[seed_index++])) {
                }
            }
            Map occur_counts = this.getObjectCounts(candidates, seed);
            if (occur_counts.size() < 2) break;
            try {
                Collection high_low = this.kmc.cluster(occur_counts, 2);
                Iterator h_iter = high_low.iterator();
                Map cluster1 = (Map)h_iter.next();
                Map cluster2 = (Map)h_iter.next();
                double[] centroid1 = DiscreteDistribution.mean(cluster1.values());
                double[] centroid2 = DiscreteDistribution.mean(cluster2.values());
                Set new_cluster = centroid1[0] >= centroid2[0] ? cluster1.keySet() : cluster2.keySet();
                Iterator iter4 = candidates.iterator();
                while (iter4.hasNext()) {
                    Collection cluster = (Collection)iter4.next();
                    cluster.removeAll(new_cluster);
                }
                clusters.add(new_cluster);
                remaining.removeAll(new_cluster);
                continue;
            }
            catch (KMeansClusterer.NotEnoughClustersException nece) {
                break;
            }
        }
        if (!remaining.isEmpty()) {
            clusters.add(remaining);
        }
        return clusters;
    }

    protected Object getRandomElement(Collection c) {
        return c.toArray()[(int)(this.rand.nextDouble() * (double)c.size())];
    }

    protected Object[] getSeedCandidates(Collection candidates) {
        final Map occur_counts = this.getObjectCounts(candidates, null);
        Object[] occurrences = occur_counts.keySet().toArray();
        Arrays.sort(occurrences, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                double[] count1;
                double[] count0 = (double[])occur_counts.get(arg0);
                if (count0[0] < (count1 = (double[])occur_counts.get(arg1))[0]) {
                    return -1;
                }
                if (count0[0] > count1[0]) {
                    return 1;
                }
                return 0;
            }
        });
        return occurrences;
    }

    protected Map getObjectCounts(Collection candidates, Object seed) {
        HashMap occur_counts = new HashMap();
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            Collection candidate = (Collection)iter.next();
            if (seed != null && !candidate.contains(seed)) continue;
            Iterator c_iter = candidate.iterator();
            while (c_iter.hasNext()) {
                Object element = c_iter.next();
                double[] count = (double[])occur_counts.get(element);
                if (count == null) {
                    count = new double[1];
                    occur_counts.put(element, count);
                    continue;
                }
                count[0] = count[0] + 1.0;
            }
        }
        return occur_counts;
    }
}

