/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

public class TimTiming {
    long initialtime = -1L;
    long currenttime = -1L;
    boolean intervalTimerOn = false;
    double intervalTimeSecs;
    double nextTimeSecs = this.intervalTimeSecs = 300.0;

    public TimTiming() {
        this.initialtime = System.currentTimeMillis();
    }

    public void setInitialTime() {
        this.initialtime = System.currentTimeMillis();
    }

    public void setIntervalTimeMinutes(double intervalTimeMinutes) {
        if (intervalTimeMinutes <= 0.0) {
            this.intervalTimerOn = false;
        }
        this.intervalTimerOn = true;
        this.nextTimeSecs = this.intervalTimeSecs = intervalTimeMinutes * 60.0;
    }

    public boolean testIntervalTime() {
        if (!this.intervalTimerOn || this.elapsedTime() < this.nextTimeSecs) {
            return false;
        }
        this.nextTimeSecs = this.elapsedTime() + this.intervalTimeSecs;
        return true;
    }

    public void test() {
        String s = TimTiming.runTimeString(0.0);
    }

    public void setCurrentTime() {
        this.currenttime = System.currentTimeMillis();
    }

    public double elapsedTime() {
        this.setCurrentTime();
        return (double)(this.currenttime - this.initialtime) / 1000.0;
    }

    public String elapsedTimeString() {
        return TimTiming.runTimeString(this.elapsedTime());
    }

    public String estimateRemainingTimeString(double f) {
        double r = this.estimateRemainingTime(f);
        if (r < 0.0) {
            return "gave zero fraction of process elapsed";
        }
        return TimTiming.runTimeString(r);
    }

    public double estimateRemainingTime(double f) {
        if (f == 0.0) {
            return -1.0;
        }
        return this.elapsedTime() * (1.0 - f) / f;
    }

    public String runTimeString() {
        return TimTiming.runTimeString(this.elapsedTime());
    }

    public static String runTimeString(double dtime) {
        int time = (int)(dtime + 0.5);
        int secs = time % 60;
        int minutes = (time /= 60) % 60;
        int hours = (time /= 60) % 24;
        int days = time / 24;
        String s = "";
        if (hours > 0) {
            s = s + hours + "h";
        }
        if (minutes > 0) {
            s = s + minutes + "m ";
        }
        s = s + secs + "s";
        return s;
    }
}

