/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

public class TimSort {
    int[] orderVector;

    public TimSort(double[] valueVector) {
        this.calcVectorOrderSmallestFirst(valueVector);
    }

    public TimSort(double[] valueVector, boolean smallestFirst) {
        if (smallestFirst) {
            this.calcVectorOrderSmallestFirst(valueVector);
        } else {
            this.calcVectorOrderLargestFirst(valueVector);
        }
    }

    public void calcVectorOrderSmallestFirst(double[] valueVector) {
        int i;
        int n = valueVector.length;
        this.orderVector = new int[n];
        int temp = -99999;
        for (i = 0; i < n; ++i) {
            this.orderVector[i] = i;
        }
        for (i = 0; i < n; ++i) {
            double best = valueVector[this.orderVector[i]];
            for (int j = i + 1; j < n; ++j) {
                double newbest = valueVector[this.orderVector[j]];
                if (!(best > newbest)) continue;
                best = newbest;
                temp = this.orderVector[j];
                this.orderVector[j] = this.orderVector[i];
                this.orderVector[i] = temp;
            }
        }
    }

    public void calcVectorOrderLargestFirst(double[] valueVector) {
        int i;
        int n = valueVector.length;
        this.orderVector = new int[n];
        int temp = -99999;
        for (i = 0; i < n; ++i) {
            this.orderVector[i] = i;
        }
        for (i = 0; i < n; ++i) {
            double best = valueVector[this.orderVector[i]];
            for (int j = i + 1; j < n; ++j) {
                double newbest = valueVector[this.orderVector[j]];
                if (!(best < newbest)) continue;
                best = newbest;
                temp = this.orderVector[j];
                this.orderVector[j] = this.orderVector[i];
                this.orderVector[i] = temp;
            }
        }
    }

    public int getIndex(int rank) {
        return this.orderVector[rank];
    }

    private void QuickSort(int criteria, int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = a[(lo0 + hi0) / 2];
            int midindex = (lo0 + hi0) / 2;
            while (lo <= hi) {
                while (lo < hi0 && (double)a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && (double)a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int T = a[lo];
                a[lo] = a[hi];
                a[hi] = T;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.QuickSort(criteria, a, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort(criteria, a, lo, hi0);
            }
        }
    }
}

