/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.StringUtilities.Filters;

import JavaNotes.TextReader;
import TimUtilities.FileUtilities.FileOutput;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.TreeSet;

public class StringFilter {
    protected TreeSet<String> rejectedList;

    protected StringFilter() {
    }

    protected StringFilter(boolean rejectedListOn) {
        if (rejectedListOn) {
            this.rejectedList = new TreeSet();
        }
    }

    public boolean hasRejectedList() {
        return this.rejectedList != null;
    }

    public boolean isAcceptable(String s) {
        return false;
    }

    public boolean isAcceptableElseRemember(String s) {
        if (this.rejectedList != null) {
            this.rejectedList.add(s);
        }
        return false;
    }

    public String description() {
        return "Basic String filter, always false, rejection list " + (this.hasRejectedList() ? "on" : "off");
    }

    public static boolean hasLetter(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (!Character.isLetter(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLetters(String s, int n) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (!Character.isLetter(s.charAt(i)) || --n != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigit(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetter(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isLetter(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterOrDigit(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isLetterOrDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String afterLastString(String s, String f) {
        int c = s.lastIndexOf(f);
        c = c < 0 ? 0 : (c += f.length());
        if (c < s.length()) {
            return s.substring(c);
        }
        return "";
    }

    public static String beforeLastString(String s, String f) {
        int c = s.lastIndexOf(f);
        if (c < 0) {
            c = s.length();
        }
        return s.substring(0, c);
    }

    public String numberRejectedString() {
        if (this.rejectedList == null) {
            return "unknown";
        }
        return Integer.toString(this.rejectedList.size());
    }

    public void printRejectedList(PrintStream PS) {
        if (this.rejectedList != null) {
            for (String r : this.rejectedList) {
                PS.println(r);
            }
        }
    }

    public void FileOutputRejectedList(String fullfilename, boolean messagesOn) {
        if (this.rejectedList == null) {
            if (messagesOn) {
                System.err.println("!!! Warning no rejected strings list in StringFilter, no file " + fullfilename + " produced");
            }
            return;
        }
        FileOutput.FileOutputCollection(fullfilename, this.rejectedList, messagesOn);
    }

    public static boolean trueString(String s) {
        if (s.length() < 1) {
            return false;
        }
        return StringFilter.trueString(s.charAt(0));
    }

    public static boolean trueString(char c) {
        return c == 't' || c == 'T' || c == 'y' || c == 'Y';
    }

    public static String onOffString(boolean b) {
        return b ? "ON" : "OFF";
    }

    public static String toDecimal(String s, String sep) {
        if (s.length() < 1) {
            return "";
        }
        StringBuffer outs = new StringBuffer(50);
        outs.append(String.format("%3d", Character.valueOf(s.charAt(0))));
        for (int c = 1; c < s.length(); ++c) {
            outs.append(sep);
            outs.append(String.format("%3d", Character.valueOf(s.charAt(c))));
        }
        return outs.toString();
    }

    public static String toHex(String s, String sep) {
        if (s.length() < 1) {
            return "";
        }
        StringBuffer outs = new StringBuffer(50);
        outs.append(String.format("%02x", s.charAt(0)));
        for (int c = 1; c < s.length(); ++c) {
            outs.append(sep);
            outs.append(String.format("%02x", s.charAt(c)));
        }
        return outs.toString();
    }

    public static String stripSpaces() {
        return null;
    }

    public static void processStringFile(String inputFileName, String outputFileName, int noFilterColumn, String sep, StringFilter sf, int sampleFrequency, boolean showProcess) {
        PrintStream PS;
        TextReader data;
        boolean readSome = sampleFrequency >= 2;
        try {
            System.out.println(" Opening Input File:  " + inputFileName);
            data = new TextReader((Reader)new FileReader(inputFileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Input file " + inputFileName + " not found, " + e);
        }
        try {
            System.out.println(" Opening Output File: " + outputFileName);
            PS = new PrintStream(new FileOutputStream(outputFileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Output file " + outputFileName + " not found, " + e);
        }
        int linenumber = 0;
        int column = 0;
        try {
            while (!data.eof()) {
                if (readSome && ++linenumber % sampleFrequency != 1) {
                    data.getln();
                    continue;
                }
                if (showProcess) {
                    System.out.print(linenumber + ": ");
                }
                while (!data.eoln()) {
                    String w = data.getWord();
                    ++column;
                    if (showProcess) {
                        System.out.print("\t" + w);
                    }
                    if (column == noFilterColumn || sf.isAcceptableElseRemember(w)) {
                        PS.print(w + sep);
                        continue;
                    }
                    if (!showProcess) continue;
                    System.out.print("<-### ");
                }
                if (showProcess) {
                    System.out.println();
                }
                PS.println();
            }
        }
        catch (TextReader.Error e) {
            throw new RuntimeException("*** Input Error on line " + linenumber + " column " + column + ": " + e.getMessage());
        }
        finally {
            data.close();
            PS.close();
        }
    }
}

