/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.StringUtilities.Filters;

import TimUtilities.StringUtilities.Filters.StopWords;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.TreeSet;

public class ImperialPapersFilter
extends StringFilter {
    public final int minLength;
    public final int minLetters;
    public final boolean keepRejectList;
    public String[] stopWordList;

    public ImperialPapersFilter(int minChar, int minL, boolean keepRejectList) {
        this.minLength = minChar;
        this.minLetters = minL;
        this.keepRejectList = keepRejectList;
        if (this.keepRejectList) {
            this.rejectedList = new TreeSet();
        }
        this.stopWordList = StopWords.MySQL_STOP_WORDS_EDITED;
    }

    public ImperialPapersFilter(int minChar, int minL, String[] stopWords, boolean keepRejectList) {
        this.minLength = minChar;
        this.minLetters = minL;
        this.keepRejectList = keepRejectList;
        if (this.keepRejectList) {
            this.rejectedList = new TreeSet();
        }
        this.stopWordList = stopWords;
    }

    @Override
    public boolean isAcceptable(String s) {
        int ls = s.length();
        if (ls < this.minLength) {
            this.rejectedList.add(s);
            return false;
        }
        if (this.isStopWord(s)) {
            this.rejectedList.add(s);
            return false;
        }
        int n = this.minLetters;
        for (int i = 0; i < ls; ++i) {
            if (!Character.isLetter(s.charAt(i)) || --n != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptableElseRemember(String s) {
        int ls = s.length();
        if (ls < this.minLength) {
            if (this.hasRejectedList()) {
                this.rejectedList.add(s);
            }
            return false;
        }
        if (this.isStopWord(s)) {
            if (this.hasRejectedList()) {
                this.rejectedList.add(s);
            }
            return false;
        }
        int n = this.minLetters;
        for (int i = 0; i < ls; ++i) {
            if (!Character.isLetter(s.charAt(i)) || --n != 0) continue;
            return true;
        }
        if (this.hasRejectedList()) {
            this.rejectedList.add(s);
        }
        return false;
    }

    public boolean isStopWord(String s) {
        for (int w = 0; w < this.stopWordList.length; ++w) {
            if (!this.stopWordList[w].equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String description() {
        return "Imperial Papers filter, rejects strings with less than " + this.minLength + " letters, and not in StopWords.MySQL_STOP_WORDS_EDITED, rejected list " + (this.hasRejectedList() ? "on" : "off");
    }
}

