/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

public class StatisticalQuantity {
    static double MAX = 7.0E99;
    public int count;
    private double total;
    private double squaretotal;
    public double maximum;
    public double minimum;
    private double average;
    private double sigma;
    private double error;
    private double secondmoment;
    private boolean updatestatistics;

    public StatisticalQuantity() {
        this.setDefaultValues(MAX, -MAX);
    }

    public StatisticalQuantity(double intialMinimum, double initialMaximum) {
        this.setDefaultValues(initialMaximum, intialMinimum);
    }

    public StatisticalQuantity(StatisticalQuantity sq) {
        if (sq == null) {
            this.setDefaultValues(MAX, -MAX);
            return;
        }
        this.total = sq.total;
        this.squaretotal = sq.squaretotal;
        this.count = sq.count;
        this.maximum = sq.maximum;
        this.minimum = sq.minimum;
        this.updatestatistics = true;
        this.average = 0.0;
        this.secondmoment = 0.0;
        this.sigma = 0.0;
        this.error = 0.0;
    }

    public void setDefaultValues(double intialMinimum, double initialMaximum) {
        this.total = 0.0;
        this.squaretotal = 0.0;
        this.count = 0;
        this.average = 0.0;
        this.secondmoment = 0.0;
        this.sigma = 0.0;
        this.error = 0.0;
        this.maximum = initialMaximum;
        this.minimum = intialMinimum;
        this.updatestatistics = false;
    }

    public void add(double x) {
        this.updatestatistics = true;
        this.total += x;
        this.squaretotal += x * x;
        ++this.count;
        if (this.count > 1) {
            if (this.maximum < x) {
                this.maximum = x;
            }
            if (this.minimum > x) {
                this.minimum = x;
            }
        } else {
            this.maximum = x;
            this.minimum = x;
        }
    }

    public double getTotal() {
        return this.total;
    }

    public double getAverage() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.average;
    }

    public double getSecondMoment() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.secondmoment;
    }

    public double getSigma() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.sigma;
    }

    public double getError() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.error;
    }

    private void calcStatistics() {
        if (!this.updatestatistics) {
            return;
        }
        this.updatestatistics = false;
        if (this.count == 0) {
            return;
        }
        this.average = this.total / (double)this.count;
        this.secondmoment = this.squaretotal / (double)this.count;
        if (this.count > 1) {
            this.sigma = Math.sqrt(this.secondmoment - this.average * this.average);
            this.error = this.sigma / Math.sqrt(this.count);
        } else {
            this.sigma = 0.0;
            this.error = 0.0;
        }
    }
}

