/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

public class Range {
    public double min;
    public double max;
    public double step;
    public double value;
    public int type = -1;

    public Range() {
        this.min = 8.0E99;
        this.max = -this.min;
        this.step = 1.0;
        this.value = this.min;
        this.type = -1;
    }

    public Range(double v) {
        if (Math.abs(v) > 1.0E-6) {
            this.min = v;
            this.max = Math.abs(v) * 0.1 + v;
            this.step = v;
            this.value = v;
        } else {
            this.min = v;
            this.max = v + 2.0E-6;
            this.step = 1.0E-5;
            this.value = v;
        }
        this.type = -1;
    }

    public Range(Range r) {
        this.min = r.min;
        this.max = r.max;
        this.step = r.step;
        this.value = r.value;
        this.type = r.type;
    }

    public String toString(String SEP) {
        String s = this.min + SEP + this.max + SEP + this.step + SEP + this.value + SEP + this.getTypeString() + SEP + this.count();
        return s;
    }

    public String getTypeString() {
        String s = "Unknown";
        switch (this.type) {
            case -1: {
                s = "one value";
                break;
            }
            case 1: {
                s = "multiply";
                break;
            }
            case 0: {
                s = "add";
                break;
            }
            default: {
                s = "UNKNOWN";
            }
        }
        return s;
    }

    public int count() {
        int n;
        switch (this.type) {
            case -1: {
                n = 1;
                break;
            }
            case 1: {
                n = (int)(Math.log(this.max / this.min) / Math.log(this.step)) + 1;
                break;
            }
            case 0: {
                n = (int)((this.max - this.min) / this.step) + 1;
                break;
            }
            default: {
                n = 999;
            }
        }
        return n > 1 ? n : 1;
    }

    public double nextValue() {
        switch (this.type) {
            case -1: {
                this.value = this.max * 2.0;
                break;
            }
            case 1: {
                this.value *= this.step;
                break;
            }
            case 0: {
                this.value += this.step;
                break;
            }
            default: {
                this.value = this.max * 2.0;
            }
        }
        return this.value;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getStep() {
        return this.step;
    }

    public double getValue() {
        return this.value;
    }
}

