/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeel {
    static String LOOKANDFEEL;

    public LookAndFeel() {
        LOOKANDFEEL = "System";
    }

    public LookAndFeel(String s) {
        LOOKANDFEEL = s;
    }

    public static void initLookAndFeel() {
        String lookAndFeel = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                LookAndFeel.metalLookAndFeel();
                return;
            }
            if (LOOKANDFEEL.equals("System")) {
                LookAndFeel.systemLookAndFeel();
                return;
            }
            if (LOOKANDFEEL.equals("Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals("GTK+")) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: " + LOOKANDFEEL);
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
        }
        LookAndFeel.tryLookAndFeel(lookAndFeel);
    }

    public static void systemLookAndFeel() {
        LookAndFeel.tryLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static void metalLookAndFeel() {
        LookAndFeel.tryLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public static void tryLookAndFeel(String lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Couldn't find class for specified look and feel:" + lookAndFeel);
            System.err.println("Did you include the L&F library in the class path?");
            System.err.println("Using the default look and feel.");
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println("Can't use the specified look and feel (" + lookAndFeel + ") on this platform.");
            System.err.println("Using the default look and feel.");
        }
        catch (Exception e) {
            System.err.println("Couldn't get specified look and feel (" + lookAndFeel + "), for some reason.");
            System.err.println("Using the default look and feel.");
            e.printStackTrace();
        }
    }
}

